/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.db;

import com.orientechnologies.orient.core.db.object.OLazyObjectMapInterface;
import com.orientechnologies.orient.core.db.object.OObjectLazyMultivalueElement;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.object.db.ODatabasePojoAbstract;
import com.orientechnologies.orient.object.db.OLazyCollectionUtil;
import com.orientechnologies.orient.object.db.OObjectDatabaseTx;
import com.orientechnologies.orient.object.enhancement.OObjectEntitySerializer;
import com.orientechnologies.orient.object.enhancement.OObjectProxyMethodHandler;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyObject;

public class OObjectLazyMap<TYPE>
extends HashMap<Object, Object>
implements Serializable,
OObjectLazyMultivalueElement<Map<Object, TYPE>>,
OLazyObjectMapInterface<TYPE> {
    private static final long serialVersionUID = -7071023580831419958L;
    private final ProxyObject sourceRecord;
    private final Map<Object, OIdentifiable> underlying;
    private String fetchPlan;
    private boolean converted = false;
    private boolean convertToRecord = true;
    private final boolean orphanRemoval;

    public OObjectLazyMap(Object iSourceRecord, Map<Object, OIdentifiable> iRecordMap, boolean orphanRemoval) {
        this.sourceRecord = iSourceRecord instanceof ProxyObject ? (ProxyObject)iSourceRecord : null;
        this.underlying = iRecordMap;
        this.converted = iRecordMap.isEmpty();
        this.orphanRemoval = orphanRemoval;
    }

    public OObjectLazyMap(Object iSourceRecord, Map<Object, OIdentifiable> iRecordMap, Map<Object, Object> iSourceMap, boolean orphanRemoval) {
        this(iSourceRecord, iRecordMap, orphanRemoval);
        this.putAll(iSourceMap);
    }

    @Override
    public int size() {
        return this.underlying.size();
    }

    @Override
    public boolean isEmpty() {
        return this.underlying.isEmpty();
    }

    @Override
    public boolean containsKey(Object k) {
        return this.underlying.containsKey(k);
    }

    @Override
    public boolean containsValue(Object o) {
        if (o instanceof OIdentifiable) {
            return this.underlying.containsValue((OIdentifiable)o);
        }
        if (o instanceof Proxy) {
            return this.underlying.containsValue(OObjectEntitySerializer.getDocument((Proxy)o));
        }
        return super.containsValue(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object iKey, Object e) {
        try {
            if (e instanceof OIdentifiable) {
                OIdentifiable record = (OIdentifiable)e;
                this.converted = false;
                OIdentifiable o = this.underlying.put(iKey, record);
                if (this.orphanRemoval && this.sourceRecord != null) {
                    if (record != null) {
                        ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().remove(record.getIdentity());
                    }
                    if (o != null && !o.getIdentity().equals(((OIdentifiable)e).getIdentity())) {
                        ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().add(o.getIdentity());
                    }
                }
                OIdentifiable oIdentifiable = o;
                return oIdentifiable;
            }
            ODocument record = e != null ? this.getDatabase().getRecordByUserObject(e, true) : null;
            OIdentifiable oldValue = this.underlying.get(iKey);
            this.underlying.put(iKey, (OIdentifiable)record);
            if (this.orphanRemoval && this.sourceRecord != null) {
                if (record != null) {
                    ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().remove(record.getIdentity());
                }
                if (record == null && oldValue != null || oldValue != null && !oldValue.getIdentity().equals(record.getIdentity())) {
                    ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().add(oldValue.getIdentity());
                }
            }
            Object object = super.put(iKey, e);
            return object;
        }
        finally {
            this.setDirty();
        }
    }

    @Override
    public Object remove(Object iKey) {
        OIdentifiable record = this.underlying.remove((String)iKey);
        if (this.orphanRemoval && record != null && this.sourceRecord != null) {
            ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().add(record.getIdentity());
        }
        this.setDirty();
        return super.remove(iKey);
    }

    @Override
    public void clear() {
        this.converted = true;
        if (this.orphanRemoval && this.sourceRecord != null) {
            for (OIdentifiable value : this.underlying.values()) {
                ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).getOrphans().add(value.getIdentity());
            }
        }
        this.underlying.clear();
        super.clear();
        this.setDirty();
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    public boolean isConvertToRecord() {
        return this.convertToRecord;
    }

    public void setConvertToRecord(boolean convertToRecord) {
        this.convertToRecord = convertToRecord;
    }

    public boolean isConverted() {
        return this.converted;
    }

    public OObjectLazyMap<TYPE> setFetchPlan(String fetchPlan) {
        this.fetchPlan = fetchPlan;
        return this;
    }

    @Override
    public String toString() {
        return this.underlying.toString();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        this.convertAll();
        return super.entrySet();
    }

    @Override
    public Object get(Object iKey) {
        this.convert((String)iKey);
        return super.get(iKey);
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        String keyAsString = String.valueOf(key);
        Object valueToReturn = this.get(keyAsString);
        return valueToReturn != null || this.containsKey(keyAsString) ? valueToReturn : defaultValue;
    }

    @Override
    public Set<Object> keySet() {
        this.convertAll();
        return this.underlying.keySet();
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> iMap) {
        for (Map.Entry<? extends Object, ? extends Object> e : iMap.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Collection<Object> values() {
        this.convertAll();
        return super.values();
    }

    public void setDirty() {
        if (this.sourceRecord != null) {
            ((OObjectProxyMethodHandler)this.sourceRecord.getHandler()).setDirty();
        }
    }

    public Map<Object, OIdentifiable> getUnderlying() {
        return this.underlying;
    }

    private void convert(String iKey) {
        if (this.converted || !this.convertToRecord) {
            return;
        }
        if (super.containsKey(iKey)) {
            return;
        }
        ORecord record = (ORecord)this.underlying.get(iKey);
        if (record == null) {
            return;
        }
        TYPE o = this.getDatabase().getUserObjectByRecord((OIdentifiable)record, null);
        ((OObjectProxyMethodHandler)((ProxyObject)o).getHandler()).setParentObject(this.sourceRecord);
        super.put(iKey, o);
    }

    public void detach() {
        this.convertAll();
    }

    public void detach(boolean nonProxiedInstance) {
        this.convertAll();
    }

    public void detachAll(boolean nonProxiedInstance, Map<Object, Object> alreadyDetached, Map<Object, Object> lazyObjects) {
        this.convertAndDetachAll(nonProxiedInstance, alreadyDetached, lazyObjects);
    }

    public Map<Object, TYPE> getNonOrientInstance() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.putAll(this);
        return map;
    }

    protected void convertAll() {
        if (this.converted || !this.convertToRecord) {
            return;
        }
        for (Map.Entry<Object, OIdentifiable> e : this.underlying.entrySet()) {
            super.put(e.getKey(), this.getDatabase().getUserObjectByRecord((OIdentifiable)e.getValue().getRecord(), null));
        }
        this.converted = true;
    }

    protected void convertAndDetachAll(boolean nonProxiedInstance, Map<Object, Object> alreadyDetached, Map<Object, Object> lazyObjects) {
        if (this.converted || !this.convertToRecord) {
            return;
        }
        for (Map.Entry<Object, OIdentifiable> e : this.underlying.entrySet()) {
            Object o = this.getDatabase().getUserObjectByRecord((OIdentifiable)e.getValue().getRecord(), null);
            o = ((OObjectDatabaseTx)this.getDatabase()).detachAll(o, nonProxiedInstance, alreadyDetached, lazyObjects);
            super.put(e.getKey(), o);
        }
        this.converted = true;
    }

    protected ODatabasePojoAbstract<TYPE> getDatabase() {
        return OLazyCollectionUtil.getDatabase();
    }
}

