/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.sql.functions;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandExecutorAbstract;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionMathAbstract;
import com.orientechnologies.orient.graph.sql.OGraphCommandExecutorSQLFactory;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class OSQLFunctionShortestPath
extends OSQLFunctionMathAbstract {
    public static final String NAME = "shortestPath";
    public static final String PARAM_MAX_DEPTH = "maxDepth";
    protected static final float DISTANCE = 1.0f;

    public OSQLFunctionShortestPath() {
        super(NAME, 2, 5);
    }

    public List<ORID> execute(Object iThis, final OIdentifiable iCurrentRecord, Object iCurrentResult, final Object[] iParams, final OCommandContext iContext) {
        return OGraphCommandExecutorSQLFactory.runWithAnyGraph(new OGraphCommandExecutorSQLFactory.GraphCallBack<List<ORID>>(){

            @Override
            public List<ORID> call(OrientBaseGraph graph) {
                ORecord record = iCurrentRecord != null ? iCurrentRecord.getRecord() : null;
                OShortestPathContext ctx = new OShortestPathContext();
                Object source = iParams[0];
                if (OMultiValue.isMultiValue((Object)source)) {
                    if (OMultiValue.getSize((Object)source) > 1) {
                        throw new IllegalArgumentException("Only one sourceVertex is allowed");
                    }
                    source = OMultiValue.getFirstValue((Object)source);
                }
                ctx.sourceVertex = graph.getVertex(OSQLHelper.getValue((Object)source, (ORecord)record, (OCommandContext)iContext));
                Object dest = iParams[1];
                if (OMultiValue.isMultiValue((Object)dest)) {
                    if (OMultiValue.getSize((Object)dest) > 1) {
                        throw new IllegalArgumentException("Only one destinationVertex is allowed");
                    }
                    dest = OMultiValue.getFirstValue((Object)dest);
                }
                ctx.destinationVertex = graph.getVertex(OSQLHelper.getValue((Object)dest, (ORecord)record, (OCommandContext)iContext));
                if (ctx.sourceVertex == null || ctx.destinationVertex == null) {
                    return new ArrayList<ORID>();
                }
                if (ctx.sourceVertex.equals(ctx.destinationVertex)) {
                    ArrayList<ORID> result = new ArrayList<ORID>(1);
                    result.add(ctx.destinationVertex.getIdentity());
                    return result;
                }
                if (iParams.length > 2 && iParams[2] != null) {
                    ctx.directionLeft = Direction.valueOf((String)iParams[2].toString().toUpperCase(Locale.ENGLISH));
                }
                if (ctx.directionLeft == Direction.OUT) {
                    ctx.directionRight = Direction.IN;
                } else if (ctx.directionLeft == Direction.IN) {
                    ctx.directionRight = Direction.OUT;
                }
                ctx.edgeType = null;
                if (iParams.length > 3) {
                    String string = ctx.edgeType = iParams[3] == null ? null : "" + iParams[3];
                }
                if (iParams != null && iParams.length > 2 && iParams[3] instanceof Collection) {
                    ctx.edgeTypeParam = new String[((Collection)iParams[3]).size()];
                    Collection coll = (Collection)iParams[3];
                    int i = 0;
                    for (Object o : coll) {
                        ctx.edgeTypeParam[i++] = "" + o;
                    }
                } else {
                    ctx.edgeTypeParam = new String[]{ctx.edgeType};
                }
                if (iParams.length > 4) {
                    OSQLFunctionShortestPath.this.bindAdditionalParams(iParams[4], ctx);
                }
                ctx.queueLeft.add(ctx.sourceVertex);
                ctx.leftVisited.add(ctx.sourceVertex.getIdentity());
                ctx.queueRight.add(ctx.destinationVertex);
                ctx.rightVisited.add(ctx.destinationVertex.getIdentity());
                for (int depth = 1; !(ctx.maxDepth != null && ctx.maxDepth <= depth || ctx.queueLeft.isEmpty() || ctx.queueRight.isEmpty()); ++depth) {
                    List<ORID> neighborIdentity;
                    if (Thread.interrupted()) {
                        throw new OCommandExecutionException("The shortestPath() function has been interrupted");
                    }
                    if (!OCommandExecutorAbstract.checkInterruption((OCommandContext)iContext)) break;
                    if (ctx.queueLeft.size() <= ctx.queueRight.size()) {
                        neighborIdentity = OSQLFunctionShortestPath.this.walkLeft(ctx);
                        if (neighborIdentity != null) {
                            return neighborIdentity;
                        }
                        if (ctx.maxDepth != null && ctx.maxDepth <= ++depth || ctx.queueLeft.isEmpty()) break;
                        neighborIdentity = OSQLFunctionShortestPath.this.walkRight(ctx);
                        if (neighborIdentity == null) continue;
                        return neighborIdentity;
                    }
                    neighborIdentity = OSQLFunctionShortestPath.this.walkRight(ctx);
                    if (neighborIdentity != null) {
                        return neighborIdentity;
                    }
                    if (ctx.maxDepth != null && ctx.maxDepth <= ++depth || ctx.queueRight.isEmpty()) break;
                    neighborIdentity = OSQLFunctionShortestPath.this.walkLeft(ctx);
                    if (neighborIdentity == null) continue;
                    return neighborIdentity;
                }
                return new ArrayList<ORID>();
            }
        });
    }

    private void bindAdditionalParams(Object additionalParams, OShortestPathContext ctx) {
        if (additionalParams == null) {
            return;
        }
        Map mapParams = null;
        if (additionalParams instanceof Map) {
            mapParams = (Map)additionalParams;
        } else if (additionalParams instanceof OIdentifiable) {
            mapParams = ((ODocument)((OIdentifiable)additionalParams).getRecord()).toMap();
        }
        if (mapParams != null) {
            ctx.maxDepth = this.integer(mapParams.get(PARAM_MAX_DEPTH));
        }
    }

    private Integer integer(Object fromObject) {
        if (fromObject == null) {
            return null;
        }
        if (fromObject instanceof Number) {
            return ((Number)fromObject).intValue();
        }
        if (fromObject instanceof String) {
            try {
                return Integer.parseInt((String)fromObject);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String getSyntax() {
        return "shortestPath(<sourceVertex>, <destinationVertex>, [<direction>, [ <edgeTypeAsString> ]])";
    }

    protected List<ORID> walkLeft(OShortestPathContext ctx) {
        ArrayDeque<OrientVertex> nextLevelQueue = new ArrayDeque<OrientVertex>();
        while (!ctx.queueLeft.isEmpty()) {
            ctx.current = ctx.queueLeft.poll();
            Iterable<Vertex> neighbors = ctx.edgeType == null ? ctx.current.getVertices(ctx.directionLeft, new String[0]) : ctx.current.getVertices(ctx.directionLeft, ctx.edgeTypeParam);
            for (Vertex neighbor : neighbors) {
                OrientVertex v = (OrientVertex)neighbor;
                ORID neighborIdentity = v.getIdentity();
                if (ctx.rightVisited.contains(neighborIdentity)) {
                    ctx.previouses.put(neighborIdentity, ctx.current.getIdentity());
                    return this.computePath(ctx.previouses, ctx.nexts, neighborIdentity);
                }
                if (ctx.leftVisited.contains(neighborIdentity)) continue;
                ctx.previouses.put(neighborIdentity, ctx.current.getIdentity());
                nextLevelQueue.offer(v);
                ctx.leftVisited.add(neighborIdentity);
            }
        }
        ctx.queueLeft = nextLevelQueue;
        return null;
    }

    protected List<ORID> walkRight(OShortestPathContext ctx) {
        ArrayDeque<OrientVertex> nextLevelQueue = new ArrayDeque<OrientVertex>();
        while (!ctx.queueRight.isEmpty()) {
            ctx.currentRight = ctx.queueRight.poll();
            Iterable<Vertex> neighbors = ctx.edgeType == null ? ctx.currentRight.getVertices(ctx.directionRight, new String[0]) : ctx.currentRight.getVertices(ctx.directionRight, ctx.edgeTypeParam);
            for (Vertex neighbor : neighbors) {
                OrientVertex v = (OrientVertex)neighbor;
                ORID neighborIdentity = v.getIdentity();
                if (ctx.leftVisited.contains(neighborIdentity)) {
                    ctx.nexts.put(neighborIdentity, ctx.currentRight.getIdentity());
                    return this.computePath(ctx.previouses, ctx.nexts, neighborIdentity);
                }
                if (ctx.rightVisited.contains(neighborIdentity)) continue;
                ctx.nexts.put(neighborIdentity, ctx.currentRight.getIdentity());
                nextLevelQueue.offer(v);
                ctx.rightVisited.add(neighborIdentity);
            }
        }
        ctx.queueRight = nextLevelQueue;
        return null;
    }

    private List<ORID> computePath(Map<ORID, ORID> leftDistances, Map<ORID, ORID> rightDistances, ORID neighbor) {
        ArrayList<ORID> result = new ArrayList<ORID>();
        ORID current = neighbor;
        while (current != null) {
            result.add(0, current);
            current = leftDistances.get(current);
        }
        current = neighbor;
        while (current != null) {
            if ((current = rightDistances.get(current)) == null) continue;
            result.add(current);
        }
        return result;
    }

    private class OShortestPathContext {
        OrientVertex sourceVertex;
        OrientVertex destinationVertex;
        Direction directionLeft = Direction.BOTH;
        Direction directionRight = Direction.BOTH;
        String edgeType;
        String[] edgeTypeParam;
        ArrayDeque<OrientVertex> queueLeft = new ArrayDeque();
        ArrayDeque<OrientVertex> queueRight = new ArrayDeque();
        final Set<ORID> leftVisited = new HashSet<ORID>();
        final Set<ORID> rightVisited = new HashSet<ORID>();
        final Map<ORID, ORID> previouses = new HashMap<ORID, ORID>();
        final Map<ORID, ORID> nexts = new HashMap<ORID, ORID>();
        OrientVertex current;
        OrientVertex currentRight;
        public Integer maxDepth;

        private OShortestPathContext() {
        }
    }
}

