/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.graphml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.tool.ODatabaseImportException;
import com.orientechnologies.orient.graph.graphml.OGraphSONUtility;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.io.graphson.ElementFactory;
import com.tinkerpop.blueprints.util.io.graphson.GraphElementFactory;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONMode;
import com.tinkerpop.blueprints.util.wrappers.batch.BatchGraph;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;

public class OGraphSONReader {
    private static final JsonFactory jsonFactory = new MappingJsonFactory();
    private final Graph graph;
    private OCommandOutputListener output;
    private long inputSize;

    public OGraphSONReader(Graph graph) {
        this.graph = graph;
    }

    public void inputGraph(InputStream jsonInputStream) throws IOException {
        this.inputGraph(jsonInputStream, 1000);
    }

    public void inputGraph(String filename) throws IOException {
        this.inputGraph(filename, 1000);
    }

    public void inputGraph(InputStream jsonInputStream, int bufferSize) throws IOException {
        this.inputGraph(jsonInputStream, bufferSize, null, null);
    }

    public void inputGraph(String filename, int bufferSize) throws IOException {
        this.inputGraph(filename, bufferSize, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputGraph(String filename, int bufferSize, Set<String> edgePropertyKeys, Set<String> vertexPropertyKeys) throws IOException {
        File file = new File(filename);
        if (!file.exists()) {
            throw new ODatabaseImportException("File '" + filename + "' not found");
        }
        this.inputSize = file.length();
        FileInputStream fis = new FileInputStream(filename);
        try {
            this.inputGraph(fis, bufferSize, edgePropertyKeys, vertexPropertyKeys);
        }
        finally {
            fis.close();
        }
    }

    public void inputGraph(InputStream jsonInputStream, int bufferSize, Set<String> edgePropertyKeys, Set<String> vertexPropertyKeys) throws IOException {
        JsonParser jp = jsonFactory.createJsonParser(jsonInputStream);
        BatchGraph batchGraph = BatchGraph.wrap((Graph)this.graph, (long)bufferSize);
        GraphElementFactory elementFactory = new GraphElementFactory((Graph)batchGraph);
        OGraphSONUtility graphson = new OGraphSONUtility(GraphSONMode.NORMAL, (ElementFactory)elementFactory, vertexPropertyKeys, edgePropertyKeys);
        long importedVertices = 0L;
        long importedEdges = 0L;
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            JsonNode node;
            String fieldname;
            String string = fieldname = jp.getCurrentName() == null ? "" : jp.getCurrentName();
            if (fieldname.equals("mode")) {
                jp.nextToken();
                GraphSONMode mode = GraphSONMode.valueOf((String)jp.getText());
                graphson = new OGraphSONUtility(mode, (ElementFactory)elementFactory, vertexPropertyKeys, edgePropertyKeys);
                continue;
            }
            if (fieldname.equals("vertices")) {
                jp.nextToken();
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    node = (JsonNode)jp.readValueAsTree();
                    graphson.vertexFromJson(node);
                    this.printStatus(jp, ++importedVertices, importedEdges);
                    if (importedVertices % 1000L != 0L) continue;
                    ODatabaseRecordThreadLocal.instance().get().getLocalCache().invalidate();
                }
                continue;
            }
            if (!fieldname.equals("edges")) continue;
            jp.nextToken();
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                node = (JsonNode)jp.readValueAsTree();
                Vertex inV = batchGraph.getVertex(OGraphSONUtility.getTypedValueFromJsonNode(node.get("_inV")));
                Vertex outV = batchGraph.getVertex(OGraphSONUtility.getTypedValueFromJsonNode(node.get("_outV")));
                graphson.edgeFromJson(node, outV, inV);
                this.printStatus(jp, importedVertices, ++importedEdges);
                if (importedEdges % 1000L != 0L) continue;
                ODatabaseRecordThreadLocal.instance().get().getLocalCache().invalidate();
            }
        }
        jp.close();
        batchGraph.commit();
    }

    public OCommandOutputListener getOutput() {
        return this.output;
    }

    public OGraphSONReader setOutput(OCommandOutputListener output) {
        this.output = output;
        return this;
    }

    protected void printStatus(JsonParser jp, long importedVertices, long importedEdges) {
        if (this.output != null && (importedVertices + importedEdges) % 50000L == 0L) {
            long parsed = jp.getCurrentLocation().getByteOffset();
            if (this.inputSize > 0L) {
                this.output.onMessage(String.format("Imported %d graph elements: %d vertices and %d edges. Parsed %s/%s (uncompressed) (%s%%)", importedVertices + importedEdges, importedVertices, importedEdges, OFileUtils.getSizeAsString((long)parsed), "" + OFileUtils.getSizeAsString((long)this.inputSize), "" + parsed * 100L / this.inputSize));
            } else {
                this.output.onMessage(String.format("Imported %d graph elements: %d vertices and %d edges. Parsed %s (uncompressed)", importedVertices + importedEdges, importedVertices, importedEdges, OFileUtils.getSizeAsString((long)parsed)));
            }
        }
    }
}

