/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OCloseQueryResponse;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public final class OCloseQueryRequest
implements OBinaryRequest<OCloseQueryResponse> {
    private String queryId;

    public OCloseQueryRequest(String queryId) {
        this.queryId = queryId;
    }

    public OCloseQueryRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        network.writeString(this.queryId);
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.queryId = channel.readString();
    }

    @Override
    public byte getCommand() {
        return 46;
    }

    @Override
    public String getDescription() {
        return "Close remote query";
    }

    @Override
    public OCloseQueryResponse createResponse() {
        return new OCloseQueryResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.closeQuery(this);
    }

    public String getQueryId() {
        return this.queryId;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }
}

