/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.ODatabaseException;

public class OBinaryProtocolHelper {
    public static void checkProtocolVersion(Object caller, int protocolVersion) {
        if (26 > protocolVersion) {
            String message = String.format("Backward compatibility support available from to version %d your version is %d", 26, protocolVersion);
            OLogManager.instance().error(caller, message, null, new Object[0]);
            throw new ODatabaseException(message);
        }
        if (OGlobalConfiguration.NETWORK_BINARY_MIN_PROTOCOL_VERSION.getValueAsInteger() > protocolVersion) {
            String message = String.format("Backward compatibility support enabled from version %d your version is %d, check `%s` settings", OGlobalConfiguration.NETWORK_BINARY_MIN_PROTOCOL_VERSION.getValueAsInteger(), protocolVersion, OGlobalConfiguration.NETWORK_BINARY_MIN_PROTOCOL_VERSION.getKey());
            OLogManager.instance().error(caller, message, null, new Object[0]);
            throw new ODatabaseException(message);
        }
    }
}

