/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.OOrientShutdownListener;
import com.orientechnologies.orient.core.OOrientStartupListener;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OSBTreeBonsai;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManager;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class OSBTreeCollectionManagerRemote
implements OCloseable,
OSBTreeCollectionManager,
OOrientStartupListener,
OOrientShutdownListener {
    private volatile ThreadLocal<Map<UUID, WeakReference<ORidBag>>> pendingCollections = new PendingCollectionsThreadLocal();

    public OSBTreeCollectionManagerRemote() {
        Orient.instance().registerWeakOrientStartupListener((OOrientStartupListener)this);
        Orient.instance().registerWeakOrientShutdownListener((OOrientShutdownListener)this);
    }

    public void onShutdown() {
        this.pendingCollections = null;
    }

    public void onStartup() {
        if (this.pendingCollections == null) {
            this.pendingCollections = new PendingCollectionsThreadLocal();
        }
    }

    protected OSBTreeBonsai<OIdentifiable, Integer> createEdgeTree(OAtomicOperation atomicOperation, int clusterId) {
        throw new UnsupportedOperationException("Creation of SB-Tree from remote storage is not allowed");
    }

    protected OSBTreeBonsai<OIdentifiable, Integer> loadTree(OBonsaiCollectionPointer collectionPointer) {
        throw new UnsupportedOperationException();
    }

    public UUID listenForChanges(ORidBag collection) {
        UUID id = collection.getTemporaryId();
        if (id == null) {
            id = UUID.randomUUID();
        }
        this.pendingCollections.get().put(id, new WeakReference<ORidBag>(collection));
        return id;
    }

    public void updateCollectionPointer(UUID uuid, OBonsaiCollectionPointer pointer) {
        WeakReference<ORidBag> reference = this.pendingCollections.get().get(uuid);
        if (reference == null) {
            OLogManager.instance().warn((Object)this, "Update of collection pointer is received but collection is not registered", new Object[0]);
            return;
        }
        ORidBag collection = (ORidBag)reference.get();
        if (collection != null) {
            collection.notifySaved(pointer);
        }
    }

    public void clearPendingCollections() {
        this.pendingCollections.get().clear();
    }

    public Map<UUID, OBonsaiCollectionPointer> changedIds() {
        throw new UnsupportedOperationException();
    }

    public void clearChangedIds() {
        throw new UnsupportedOperationException();
    }

    public OSBTreeBonsai<OIdentifiable, Integer> createAndLoadTree(OAtomicOperation atomicOperation, int clusterId) throws IOException {
        return this.loadSBTree(this.createSBTree(clusterId, atomicOperation, null));
    }

    public OBonsaiCollectionPointer createSBTree(int clusterId, OAtomicOperation atomicOperation, UUID ownerUUID) throws IOException {
        OSBTreeBonsai<OIdentifiable, Integer> tree = this.createEdgeTree(atomicOperation, clusterId);
        return tree.getCollectionPointer();
    }

    public OSBTreeBonsai<OIdentifiable, Integer> loadSBTree(OBonsaiCollectionPointer collectionPointer) {
        OSBTreeBonsai<OIdentifiable, Integer> tree = this.loadTree(collectionPointer);
        return tree;
    }

    public void releaseSBTree(OBonsaiCollectionPointer collectionPointer) {
    }

    public void delete(OBonsaiCollectionPointer collectionPointer) {
    }

    public void close() {
        this.clear();
    }

    public void clear() {
    }

    void clearClusterCache(long fileId, String fileName) {
    }

    int size() {
        return 0;
    }

    private static class PendingCollectionsThreadLocal
    extends ThreadLocal<Map<UUID, WeakReference<ORidBag>>> {
        private PendingCollectionsThreadLocal() {
        }

        @Override
        protected Map<UUID, WeakReference<ORidBag>> initialValue() {
            return new HashMap<UUID, WeakReference<ORidBag>>();
        }
    }
}

