/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.client.remote.db.document.ODatabaseDocumentRemote;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabasePoolInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OSharedContext;

public class ODatabaseDocumentRemotePooled
extends ODatabaseDocumentRemote {
    private ODatabasePoolInternal pool;

    public ODatabaseDocumentRemotePooled(ODatabasePoolInternal pool, OStorageRemote storage, OSharedContext sharedContext) {
        super(storage, sharedContext);
        this.pool = pool;
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.internalClose(true);
        this.pool.release((ODatabaseDocumentInternal)this);
    }

    @Override
    public ODatabaseDocumentInternal copy() {
        return (ODatabaseDocumentInternal)this.pool.acquire();
    }

    public void reuse() {
        this.activateOnCurrentThread();
        this.setStatus(ODatabase.STATUS.OPEN);
    }

    public void realClose() {
        ODatabaseDocumentInternal old = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            this.activateOnCurrentThread();
            super.close();
        }
        finally {
            if (old == null) {
                ODatabaseRecordThreadLocal.instance().remove();
            } else {
                ODatabaseRecordThreadLocal.instance().set(old);
            }
        }
    }
}

