package com.orbitz.consul.model.operator;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RaftServer}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRaftServer.builder()}.
 */
@Generated(from = "RaftServer", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableRaftServer extends RaftServer {
  private final String id;
  private final String node;
  private final String address;
  private final Boolean leader;
  private final Boolean voter;

  private ImmutableRaftServer(
      String id,
      String node,
      String address,
      Boolean leader,
      Boolean voter) {
    this.id = id;
    this.node = node;
    this.address = address;
    this.leader = leader;
    this.voter = voter;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("ID")
  @Override
  public String id() {
    return id;
  }

  /**
   * @return The value of the {@code node} attribute
   */
  @JsonProperty("Node")
  @Override
  public String node() {
    return node;
  }

  /**
   * @return The value of the {@code address} attribute
   */
  @JsonProperty("Address")
  @Override
  public String address() {
    return address;
  }

  /**
   * @return The value of the {@code leader} attribute
   */
  @JsonProperty("Leader")
  @Override
  public Boolean leader() {
    return leader;
  }

  /**
   * @return The value of the {@code voter} attribute
   */
  @JsonProperty("Voter")
  @Override
  public Boolean voter() {
    return voter;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RaftServer#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRaftServer withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableRaftServer(newValue, this.node, this.address, this.leader, this.voter);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RaftServer#node() node} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for node
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRaftServer withNode(String value) {
    String newValue = Objects.requireNonNull(value, "node");
    if (this.node.equals(newValue)) return this;
    return new ImmutableRaftServer(this.id, newValue, this.address, this.leader, this.voter);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RaftServer#address() address} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for address
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRaftServer withAddress(String value) {
    String newValue = Objects.requireNonNull(value, "address");
    if (this.address.equals(newValue)) return this;
    return new ImmutableRaftServer(this.id, this.node, newValue, this.leader, this.voter);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RaftServer#leader() leader} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for leader
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRaftServer withLeader(Boolean value) {
    Boolean newValue = Objects.requireNonNull(value, "leader");
    if (this.leader.equals(newValue)) return this;
    return new ImmutableRaftServer(this.id, this.node, this.address, newValue, this.voter);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RaftServer#voter() voter} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for voter
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRaftServer withVoter(Boolean value) {
    Boolean newValue = Objects.requireNonNull(value, "voter");
    if (this.voter.equals(newValue)) return this;
    return new ImmutableRaftServer(this.id, this.node, this.address, this.leader, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRaftServer} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRaftServer
        && equalTo((ImmutableRaftServer) another);
  }

  private boolean equalTo(ImmutableRaftServer another) {
    return id.equals(another.id)
        && node.equals(another.node)
        && address.equals(another.address)
        && leader.equals(another.leader)
        && voter.equals(another.voter);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code node}, {@code address}, {@code leader}, {@code voter}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + node.hashCode();
    h += (h << 5) + address.hashCode();
    h += (h << 5) + leader.hashCode();
    h += (h << 5) + voter.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RaftServer} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RaftServer")
        .omitNullValues()
        .add("id", id)
        .add("node", node)
        .add("address", address)
        .add("leader", leader)
        .add("voter", voter)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "RaftServer", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends RaftServer {
    @Nullable String id;
    @Nullable String node;
    @Nullable String address;
    @Nullable Boolean leader;
    @Nullable Boolean voter;
    @JsonProperty("ID")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("Node")
    public void setNode(String node) {
      this.node = node;
    }
    @JsonProperty("Address")
    public void setAddress(String address) {
      this.address = address;
    }
    @JsonProperty("Leader")
    public void setLeader(Boolean leader) {
      this.leader = leader;
    }
    @JsonProperty("Voter")
    public void setVoter(Boolean voter) {
      this.voter = voter;
    }
    @Override
    public String id() { throw new UnsupportedOperationException(); }
    @Override
    public String node() { throw new UnsupportedOperationException(); }
    @Override
    public String address() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean leader() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean voter() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableRaftServer fromJson(Json json) {
    ImmutableRaftServer.Builder builder = ImmutableRaftServer.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.node != null) {
      builder.node(json.node);
    }
    if (json.address != null) {
      builder.address(json.address);
    }
    if (json.leader != null) {
      builder.leader(json.leader);
    }
    if (json.voter != null) {
      builder.voter(json.voter);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link RaftServer} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RaftServer instance
   */
  public static ImmutableRaftServer copyOf(RaftServer instance) {
    if (instance instanceof ImmutableRaftServer) {
      return (ImmutableRaftServer) instance;
    }
    return ImmutableRaftServer.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRaftServer ImmutableRaftServer}.
   * <pre>
   * ImmutableRaftServer.builder()
   *    .id(String) // required {@link RaftServer#id() id}
   *    .node(String) // required {@link RaftServer#node() node}
   *    .address(String) // required {@link RaftServer#address() address}
   *    .leader(Boolean) // required {@link RaftServer#leader() leader}
   *    .voter(Boolean) // required {@link RaftServer#voter() voter}
   *    .build();
   * </pre>
   * @return A new ImmutableRaftServer builder
   */
  public static ImmutableRaftServer.Builder builder() {
    return new ImmutableRaftServer.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRaftServer ImmutableRaftServer}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RaftServer", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NODE = 0x2L;
    private static final long INIT_BIT_ADDRESS = 0x4L;
    private static final long INIT_BIT_LEADER = 0x8L;
    private static final long INIT_BIT_VOTER = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String id;
    private @Nullable String node;
    private @Nullable String address;
    private @Nullable Boolean leader;
    private @Nullable Boolean voter;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RaftServer} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RaftServer instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.id());
      node(instance.node());
      address(instance.address());
      leader(instance.leader());
      voter(instance.voter());
      return this;
    }

    /**
     * Initializes the value for the {@link RaftServer#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ID")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RaftServer#node() node} attribute.
     * @param node The value for node 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Node")
    public final Builder node(String node) {
      this.node = Objects.requireNonNull(node, "node");
      initBits &= ~INIT_BIT_NODE;
      return this;
    }

    /**
     * Initializes the value for the {@link RaftServer#address() address} attribute.
     * @param address The value for address 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Address")
    public final Builder address(String address) {
      this.address = Objects.requireNonNull(address, "address");
      initBits &= ~INIT_BIT_ADDRESS;
      return this;
    }

    /**
     * Initializes the value for the {@link RaftServer#leader() leader} attribute.
     * @param leader The value for leader 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Leader")
    public final Builder leader(Boolean leader) {
      this.leader = Objects.requireNonNull(leader, "leader");
      initBits &= ~INIT_BIT_LEADER;
      return this;
    }

    /**
     * Initializes the value for the {@link RaftServer#voter() voter} attribute.
     * @param voter The value for voter 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Voter")
    public final Builder voter(Boolean voter) {
      this.voter = Objects.requireNonNull(voter, "voter");
      initBits &= ~INIT_BIT_VOTER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRaftServer ImmutableRaftServer}.
     * @return An immutable instance of RaftServer
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRaftServer build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRaftServer(id, node, address, leader, voter);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NODE) != 0) attributes.add("node");
      if ((initBits & INIT_BIT_ADDRESS) != 0) attributes.add("address");
      if ((initBits & INIT_BIT_LEADER) != 0) attributes.add("leader");
      if ((initBits & INIT_BIT_VOTER) != 0) attributes.add("voter");
      return "Cannot build RaftServer, some of required attributes are not set " + attributes;
    }
  }
}
