package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DebugConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDebugConfig.builder()}.
 */
@Generated(from = "DebugConfig", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableDebugConfig extends DebugConfig {
  private final boolean bootstrap;
  private final String datacenter;
  private final String dataDir;
  private final ImmutableList<String> dnsRecursors;
  private final String dnsDomain;
  private final String logLevel;
  private final String nodeName;
  private final ImmutableList<String> clientAddrs;
  private final String bindAddr;
  private final boolean leaveOnTerm;
  private final boolean skipLeaveOnInt;
  private final boolean enableDebug;
  private final boolean verifyIncoming;
  private final boolean verifyOutgoing;
  private final String caFile;
  private final String certFile;
  private final String keyFile;
  private final @Nullable String uiDir;
  private final String pidFile;
  private final boolean enableSyslog;
  private final boolean rejoinAfterLeave;
  private final String advertiseAddrLAN;
  private final String advertiseAddrWAN;

  private ImmutableDebugConfig(
      boolean bootstrap,
      String datacenter,
      String dataDir,
      ImmutableList<String> dnsRecursors,
      String dnsDomain,
      String logLevel,
      String nodeName,
      ImmutableList<String> clientAddrs,
      String bindAddr,
      boolean leaveOnTerm,
      boolean skipLeaveOnInt,
      boolean enableDebug,
      boolean verifyIncoming,
      boolean verifyOutgoing,
      String caFile,
      String certFile,
      String keyFile,
      @Nullable String uiDir,
      String pidFile,
      boolean enableSyslog,
      boolean rejoinAfterLeave,
      String advertiseAddrLAN,
      String advertiseAddrWAN) {
    this.bootstrap = bootstrap;
    this.datacenter = datacenter;
    this.dataDir = dataDir;
    this.dnsRecursors = dnsRecursors;
    this.dnsDomain = dnsDomain;
    this.logLevel = logLevel;
    this.nodeName = nodeName;
    this.clientAddrs = clientAddrs;
    this.bindAddr = bindAddr;
    this.leaveOnTerm = leaveOnTerm;
    this.skipLeaveOnInt = skipLeaveOnInt;
    this.enableDebug = enableDebug;
    this.verifyIncoming = verifyIncoming;
    this.verifyOutgoing = verifyOutgoing;
    this.caFile = caFile;
    this.certFile = certFile;
    this.keyFile = keyFile;
    this.uiDir = uiDir;
    this.pidFile = pidFile;
    this.enableSyslog = enableSyslog;
    this.rejoinAfterLeave = rejoinAfterLeave;
    this.advertiseAddrLAN = advertiseAddrLAN;
    this.advertiseAddrWAN = advertiseAddrWAN;
  }

  /**
   * @return The value of the {@code bootstrap} attribute
   */
  @JsonProperty("Bootstrap")
  @Override
  public boolean getBootstrap() {
    return bootstrap;
  }

  /**
   * @return The value of the {@code datacenter} attribute
   */
  @JsonProperty("Datacenter")
  @Override
  public String getDatacenter() {
    return datacenter;
  }

  /**
   * @return The value of the {@code dataDir} attribute
   */
  @JsonProperty("DataDir")
  @Override
  public String getDataDir() {
    return dataDir;
  }

  /**
   * @return The value of the {@code dnsRecursors} attribute
   */
  @JsonProperty("DNSRecursors")
  @Override
  public ImmutableList<String> dnsRecursors() {
    return dnsRecursors;
  }

  /**
   * @return The value of the {@code dnsDomain} attribute
   */
  @JsonProperty("DNSDomain")
  @Override
  public String getDnsDomain() {
    return dnsDomain;
  }

  /**
   * @return The value of the {@code logLevel} attribute
   */
  @JsonProperty("LogLevel")
  @Override
  public String getLogLevel() {
    return logLevel;
  }

  /**
   * @return The value of the {@code nodeName} attribute
   */
  @JsonProperty("NodeName")
  @Override
  public String getNodeName() {
    return nodeName;
  }

  /**
   * @return The value of the {@code clientAddrs} attribute
   */
  @JsonProperty("ClientAddrs")
  @Override
  public ImmutableList<String> getClientAddrs() {
    return clientAddrs;
  }

  /**
   * @return The value of the {@code bindAddr} attribute
   */
  @JsonProperty("BindAddr")
  @Override
  public String getBindAddr() {
    return bindAddr;
  }

  /**
   * @return The value of the {@code leaveOnTerm} attribute
   */
  @JsonProperty("LeaveOnTerm")
  @Override
  public boolean getLeaveOnTerm() {
    return leaveOnTerm;
  }

  /**
   * @return The value of the {@code skipLeaveOnInt} attribute
   */
  @JsonProperty("SkipLeaveOnInt")
  @Override
  public boolean getSkipLeaveOnInt() {
    return skipLeaveOnInt;
  }

  /**
   * @return The value of the {@code enableDebug} attribute
   */
  @JsonProperty("EnableDebug")
  @Override
  public boolean getEnableDebug() {
    return enableDebug;
  }

  /**
   * @return The value of the {@code verifyIncoming} attribute
   */
  @JsonProperty("VerifyIncoming")
  @Override
  public boolean getVerifyIncoming() {
    return verifyIncoming;
  }

  /**
   * @return The value of the {@code verifyOutgoing} attribute
   */
  @JsonProperty("VerifyOutgoing")
  @Override
  public boolean getVerifyOutgoing() {
    return verifyOutgoing;
  }

  /**
   * @return The value of the {@code caFile} attribute
   */
  @JsonProperty("CAFile")
  @Override
  public String getCaFile() {
    return caFile;
  }

  /**
   * @return The value of the {@code certFile} attribute
   */
  @JsonProperty("CertFile")
  @Override
  public String getCertFile() {
    return certFile;
  }

  /**
   * @return The value of the {@code keyFile} attribute
   */
  @JsonProperty("KeyFile")
  @Override
  public String getKeyFile() {
    return keyFile;
  }

  /**
   * @return The value of the {@code uiDir} attribute
   */
  @JsonProperty("UiDir")
  @Override
  public Optional<String> getUiDir() {
    return Optional.ofNullable(uiDir);
  }

  /**
   * @return The value of the {@code pidFile} attribute
   */
  @JsonProperty("PidFile")
  @Override
  public String getPidFile() {
    return pidFile;
  }

  /**
   * @return The value of the {@code enableSyslog} attribute
   */
  @JsonProperty("EnableSyslog")
  @Override
  public boolean getEnableSyslog() {
    return enableSyslog;
  }

  /**
   * @return The value of the {@code rejoinAfterLeave} attribute
   */
  @JsonProperty("RejoinAfterLeave")
  @Override
  public boolean getRejoinAfterLeave() {
    return rejoinAfterLeave;
  }

  /**
   * @return The value of the {@code advertiseAddrLAN} attribute
   */
  @JsonProperty("AdvertiseAddrLAN")
  @Override
  public String getAdvertiseAddrLAN() {
    return advertiseAddrLAN;
  }

  /**
   * @return The value of the {@code advertiseAddrWAN} attribute
   */
  @JsonProperty("AdvertiseAddrWAN")
  @Override
  public String getAdvertiseAddrWAN() {
    return advertiseAddrWAN;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getBootstrap() bootstrap} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bootstrap
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withBootstrap(boolean value) {
    if (this.bootstrap == value) return this;
    return new ImmutableDebugConfig(
        value,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getDatacenter() datacenter} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for datacenter
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withDatacenter(String value) {
    String newValue = Objects.requireNonNull(value, "datacenter");
    if (this.datacenter.equals(newValue)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        newValue,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getDataDir() dataDir} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dataDir
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withDataDir(String value) {
    String newValue = Objects.requireNonNull(value, "dataDir");
    if (this.dataDir.equals(newValue)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        newValue,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DebugConfig#dnsRecursors() dnsRecursors}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDebugConfig withDnsRecursors(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        newValue,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DebugConfig#dnsRecursors() dnsRecursors}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of dnsRecursors elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDebugConfig withDnsRecursors(Iterable<String> elements) {
    if (this.dnsRecursors == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        newValue,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getDnsDomain() dnsDomain} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dnsDomain
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withDnsDomain(String value) {
    String newValue = Objects.requireNonNull(value, "dnsDomain");
    if (this.dnsDomain.equals(newValue)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        newValue,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getLogLevel() logLevel} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for logLevel
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withLogLevel(String value) {
    String newValue = Objects.requireNonNull(value, "logLevel");
    if (this.logLevel.equals(newValue)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        newValue,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getNodeName() nodeName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nodeName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withNodeName(String value) {
    String newValue = Objects.requireNonNull(value, "nodeName");
    if (this.nodeName.equals(newValue)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        newValue,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DebugConfig#getClientAddrs() clientAddrs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDebugConfig withClientAddrs(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        newValue,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DebugConfig#getClientAddrs() clientAddrs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of clientAddrs elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDebugConfig withClientAddrs(Iterable<String> elements) {
    if (this.clientAddrs == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        newValue,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getBindAddr() bindAddr} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bindAddr
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withBindAddr(String value) {
    String newValue = Objects.requireNonNull(value, "bindAddr");
    if (this.bindAddr.equals(newValue)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        newValue,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getLeaveOnTerm() leaveOnTerm} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for leaveOnTerm
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withLeaveOnTerm(boolean value) {
    if (this.leaveOnTerm == value) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        value,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getSkipLeaveOnInt() skipLeaveOnInt} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for skipLeaveOnInt
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withSkipLeaveOnInt(boolean value) {
    if (this.skipLeaveOnInt == value) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        value,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getEnableDebug() enableDebug} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for enableDebug
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withEnableDebug(boolean value) {
    if (this.enableDebug == value) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        value,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getVerifyIncoming() verifyIncoming} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for verifyIncoming
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withVerifyIncoming(boolean value) {
    if (this.verifyIncoming == value) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        value,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getVerifyOutgoing() verifyOutgoing} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for verifyOutgoing
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withVerifyOutgoing(boolean value) {
    if (this.verifyOutgoing == value) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        value,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getCaFile() caFile} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for caFile
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withCaFile(String value) {
    String newValue = Objects.requireNonNull(value, "caFile");
    if (this.caFile.equals(newValue)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        newValue,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getCertFile() certFile} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for certFile
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withCertFile(String value) {
    String newValue = Objects.requireNonNull(value, "certFile");
    if (this.certFile.equals(newValue)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        newValue,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getKeyFile() keyFile} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for keyFile
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withKeyFile(String value) {
    String newValue = Objects.requireNonNull(value, "keyFile");
    if (this.keyFile.equals(newValue)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        newValue,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link DebugConfig#getUiDir() uiDir} attribute.
   * @param value The value for uiDir
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDebugConfig withUiDir(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "uiDir");
    if (Objects.equals(this.uiDir, newValue)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        newValue,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link DebugConfig#getUiDir() uiDir} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for uiDir
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDebugConfig withUiDir(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.uiDir, value)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        value,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getPidFile() pidFile} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pidFile
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withPidFile(String value) {
    String newValue = Objects.requireNonNull(value, "pidFile");
    if (this.pidFile.equals(newValue)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        newValue,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getEnableSyslog() enableSyslog} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for enableSyslog
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withEnableSyslog(boolean value) {
    if (this.enableSyslog == value) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        value,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getRejoinAfterLeave() rejoinAfterLeave} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rejoinAfterLeave
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withRejoinAfterLeave(boolean value) {
    if (this.rejoinAfterLeave == value) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        value,
        this.advertiseAddrLAN,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getAdvertiseAddrLAN() advertiseAddrLAN} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for advertiseAddrLAN
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withAdvertiseAddrLAN(String value) {
    String newValue = Objects.requireNonNull(value, "advertiseAddrLAN");
    if (this.advertiseAddrLAN.equals(newValue)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        newValue,
        this.advertiseAddrWAN);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DebugConfig#getAdvertiseAddrWAN() advertiseAddrWAN} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for advertiseAddrWAN
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDebugConfig withAdvertiseAddrWAN(String value) {
    String newValue = Objects.requireNonNull(value, "advertiseAddrWAN");
    if (this.advertiseAddrWAN.equals(newValue)) return this;
    return new ImmutableDebugConfig(
        this.bootstrap,
        this.datacenter,
        this.dataDir,
        this.dnsRecursors,
        this.dnsDomain,
        this.logLevel,
        this.nodeName,
        this.clientAddrs,
        this.bindAddr,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave,
        this.advertiseAddrLAN,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDebugConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDebugConfig
        && equalTo((ImmutableDebugConfig) another);
  }

  private boolean equalTo(ImmutableDebugConfig another) {
    return bootstrap == another.bootstrap
        && datacenter.equals(another.datacenter)
        && dataDir.equals(another.dataDir)
        && dnsRecursors.equals(another.dnsRecursors)
        && dnsDomain.equals(another.dnsDomain)
        && logLevel.equals(another.logLevel)
        && nodeName.equals(another.nodeName)
        && clientAddrs.equals(another.clientAddrs)
        && bindAddr.equals(another.bindAddr)
        && leaveOnTerm == another.leaveOnTerm
        && skipLeaveOnInt == another.skipLeaveOnInt
        && enableDebug == another.enableDebug
        && verifyIncoming == another.verifyIncoming
        && verifyOutgoing == another.verifyOutgoing
        && caFile.equals(another.caFile)
        && certFile.equals(another.certFile)
        && keyFile.equals(another.keyFile)
        && Objects.equals(uiDir, another.uiDir)
        && pidFile.equals(another.pidFile)
        && enableSyslog == another.enableSyslog
        && rejoinAfterLeave == another.rejoinAfterLeave
        && advertiseAddrLAN.equals(another.advertiseAddrLAN)
        && advertiseAddrWAN.equals(another.advertiseAddrWAN);
  }

  /**
   * Computes a hash code from attributes: {@code bootstrap}, {@code datacenter}, {@code dataDir}, {@code dnsRecursors}, {@code dnsDomain}, {@code logLevel}, {@code nodeName}, {@code clientAddrs}, {@code bindAddr}, {@code leaveOnTerm}, {@code skipLeaveOnInt}, {@code enableDebug}, {@code verifyIncoming}, {@code verifyOutgoing}, {@code caFile}, {@code certFile}, {@code keyFile}, {@code uiDir}, {@code pidFile}, {@code enableSyslog}, {@code rejoinAfterLeave}, {@code advertiseAddrLAN}, {@code advertiseAddrWAN}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Booleans.hashCode(bootstrap);
    h += (h << 5) + datacenter.hashCode();
    h += (h << 5) + dataDir.hashCode();
    h += (h << 5) + dnsRecursors.hashCode();
    h += (h << 5) + dnsDomain.hashCode();
    h += (h << 5) + logLevel.hashCode();
    h += (h << 5) + nodeName.hashCode();
    h += (h << 5) + clientAddrs.hashCode();
    h += (h << 5) + bindAddr.hashCode();
    h += (h << 5) + Booleans.hashCode(leaveOnTerm);
    h += (h << 5) + Booleans.hashCode(skipLeaveOnInt);
    h += (h << 5) + Booleans.hashCode(enableDebug);
    h += (h << 5) + Booleans.hashCode(verifyIncoming);
    h += (h << 5) + Booleans.hashCode(verifyOutgoing);
    h += (h << 5) + caFile.hashCode();
    h += (h << 5) + certFile.hashCode();
    h += (h << 5) + keyFile.hashCode();
    h += (h << 5) + Objects.hashCode(uiDir);
    h += (h << 5) + pidFile.hashCode();
    h += (h << 5) + Booleans.hashCode(enableSyslog);
    h += (h << 5) + Booleans.hashCode(rejoinAfterLeave);
    h += (h << 5) + advertiseAddrLAN.hashCode();
    h += (h << 5) + advertiseAddrWAN.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DebugConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DebugConfig")
        .omitNullValues()
        .add("bootstrap", bootstrap)
        .add("datacenter", datacenter)
        .add("dataDir", dataDir)
        .add("dnsRecursors", dnsRecursors)
        .add("dnsDomain", dnsDomain)
        .add("logLevel", logLevel)
        .add("nodeName", nodeName)
        .add("clientAddrs", clientAddrs)
        .add("bindAddr", bindAddr)
        .add("leaveOnTerm", leaveOnTerm)
        .add("skipLeaveOnInt", skipLeaveOnInt)
        .add("enableDebug", enableDebug)
        .add("verifyIncoming", verifyIncoming)
        .add("verifyOutgoing", verifyOutgoing)
        .add("caFile", caFile)
        .add("certFile", certFile)
        .add("keyFile", keyFile)
        .add("uiDir", uiDir)
        .add("pidFile", pidFile)
        .add("enableSyslog", enableSyslog)
        .add("rejoinAfterLeave", rejoinAfterLeave)
        .add("advertiseAddrLAN", advertiseAddrLAN)
        .add("advertiseAddrWAN", advertiseAddrWAN)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DebugConfig", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends DebugConfig {
    boolean bootstrap;
    boolean bootstrapIsSet;
    @Nullable String datacenter;
    @Nullable String dataDir;
    @Nullable List<String> dnsRecursors = ImmutableList.of();
    @Nullable String dnsDomain;
    @Nullable String logLevel;
    @Nullable String nodeName;
    @Nullable List<String> clientAddrs = ImmutableList.of();
    @Nullable String bindAddr;
    boolean leaveOnTerm;
    boolean leaveOnTermIsSet;
    boolean skipLeaveOnInt;
    boolean skipLeaveOnIntIsSet;
    boolean enableDebug;
    boolean enableDebugIsSet;
    boolean verifyIncoming;
    boolean verifyIncomingIsSet;
    boolean verifyOutgoing;
    boolean verifyOutgoingIsSet;
    @Nullable String caFile;
    @Nullable String certFile;
    @Nullable String keyFile;
    @Nullable Optional<String> uiDir = Optional.empty();
    @Nullable String pidFile;
    boolean enableSyslog;
    boolean enableSyslogIsSet;
    boolean rejoinAfterLeave;
    boolean rejoinAfterLeaveIsSet;
    @Nullable String advertiseAddrLAN;
    @Nullable String advertiseAddrWAN;
    @JsonProperty("Bootstrap")
    public void setBootstrap(boolean bootstrap) {
      this.bootstrap = bootstrap;
      this.bootstrapIsSet = true;
    }
    @JsonProperty("Datacenter")
    public void setDatacenter(String datacenter) {
      this.datacenter = datacenter;
    }
    @JsonProperty("DataDir")
    public void setDataDir(String dataDir) {
      this.dataDir = dataDir;
    }
    @JsonProperty("DNSRecursors")
    public void setDnsRecursors(List<String> dnsRecursors) {
      this.dnsRecursors = dnsRecursors;
    }
    @JsonProperty("DNSDomain")
    public void setDnsDomain(String dnsDomain) {
      this.dnsDomain = dnsDomain;
    }
    @JsonProperty("LogLevel")
    public void setLogLevel(String logLevel) {
      this.logLevel = logLevel;
    }
    @JsonProperty("NodeName")
    public void setNodeName(String nodeName) {
      this.nodeName = nodeName;
    }
    @JsonProperty("ClientAddrs")
    public void setClientAddrs(List<String> clientAddrs) {
      this.clientAddrs = clientAddrs;
    }
    @JsonProperty("BindAddr")
    public void setBindAddr(String bindAddr) {
      this.bindAddr = bindAddr;
    }
    @JsonProperty("LeaveOnTerm")
    public void setLeaveOnTerm(boolean leaveOnTerm) {
      this.leaveOnTerm = leaveOnTerm;
      this.leaveOnTermIsSet = true;
    }
    @JsonProperty("SkipLeaveOnInt")
    public void setSkipLeaveOnInt(boolean skipLeaveOnInt) {
      this.skipLeaveOnInt = skipLeaveOnInt;
      this.skipLeaveOnIntIsSet = true;
    }
    @JsonProperty("EnableDebug")
    public void setEnableDebug(boolean enableDebug) {
      this.enableDebug = enableDebug;
      this.enableDebugIsSet = true;
    }
    @JsonProperty("VerifyIncoming")
    public void setVerifyIncoming(boolean verifyIncoming) {
      this.verifyIncoming = verifyIncoming;
      this.verifyIncomingIsSet = true;
    }
    @JsonProperty("VerifyOutgoing")
    public void setVerifyOutgoing(boolean verifyOutgoing) {
      this.verifyOutgoing = verifyOutgoing;
      this.verifyOutgoingIsSet = true;
    }
    @JsonProperty("CAFile")
    public void setCaFile(String caFile) {
      this.caFile = caFile;
    }
    @JsonProperty("CertFile")
    public void setCertFile(String certFile) {
      this.certFile = certFile;
    }
    @JsonProperty("KeyFile")
    public void setKeyFile(String keyFile) {
      this.keyFile = keyFile;
    }
    @JsonProperty("UiDir")
    public void setUiDir(Optional<String> uiDir) {
      this.uiDir = uiDir;
    }
    @JsonProperty("PidFile")
    public void setPidFile(String pidFile) {
      this.pidFile = pidFile;
    }
    @JsonProperty("EnableSyslog")
    public void setEnableSyslog(boolean enableSyslog) {
      this.enableSyslog = enableSyslog;
      this.enableSyslogIsSet = true;
    }
    @JsonProperty("RejoinAfterLeave")
    public void setRejoinAfterLeave(boolean rejoinAfterLeave) {
      this.rejoinAfterLeave = rejoinAfterLeave;
      this.rejoinAfterLeaveIsSet = true;
    }
    @JsonProperty("AdvertiseAddrLAN")
    public void setAdvertiseAddrLAN(String advertiseAddrLAN) {
      this.advertiseAddrLAN = advertiseAddrLAN;
    }
    @JsonProperty("AdvertiseAddrWAN")
    public void setAdvertiseAddrWAN(String advertiseAddrWAN) {
      this.advertiseAddrWAN = advertiseAddrWAN;
    }
    @Override
    public boolean getBootstrap() { throw new UnsupportedOperationException(); }
    @Override
    public String getDatacenter() { throw new UnsupportedOperationException(); }
    @Override
    public String getDataDir() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> dnsRecursors() { throw new UnsupportedOperationException(); }
    @Override
    public String getDnsDomain() { throw new UnsupportedOperationException(); }
    @Override
    public String getLogLevel() { throw new UnsupportedOperationException(); }
    @Override
    public String getNodeName() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getClientAddrs() { throw new UnsupportedOperationException(); }
    @Override
    public String getBindAddr() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getLeaveOnTerm() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getSkipLeaveOnInt() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getEnableDebug() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getVerifyIncoming() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getVerifyOutgoing() { throw new UnsupportedOperationException(); }
    @Override
    public String getCaFile() { throw new UnsupportedOperationException(); }
    @Override
    public String getCertFile() { throw new UnsupportedOperationException(); }
    @Override
    public String getKeyFile() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getUiDir() { throw new UnsupportedOperationException(); }
    @Override
    public String getPidFile() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getEnableSyslog() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getRejoinAfterLeave() { throw new UnsupportedOperationException(); }
    @Override
    public String getAdvertiseAddrLAN() { throw new UnsupportedOperationException(); }
    @Override
    public String getAdvertiseAddrWAN() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDebugConfig fromJson(Json json) {
    ImmutableDebugConfig.Builder builder = ImmutableDebugConfig.builder();
    if (json.bootstrapIsSet) {
      builder.bootstrap(json.bootstrap);
    }
    if (json.datacenter != null) {
      builder.datacenter(json.datacenter);
    }
    if (json.dataDir != null) {
      builder.dataDir(json.dataDir);
    }
    if (json.dnsRecursors != null) {
      builder.addAllDnsRecursors(json.dnsRecursors);
    }
    if (json.dnsDomain != null) {
      builder.dnsDomain(json.dnsDomain);
    }
    if (json.logLevel != null) {
      builder.logLevel(json.logLevel);
    }
    if (json.nodeName != null) {
      builder.nodeName(json.nodeName);
    }
    if (json.clientAddrs != null) {
      builder.addAllClientAddrs(json.clientAddrs);
    }
    if (json.bindAddr != null) {
      builder.bindAddr(json.bindAddr);
    }
    if (json.leaveOnTermIsSet) {
      builder.leaveOnTerm(json.leaveOnTerm);
    }
    if (json.skipLeaveOnIntIsSet) {
      builder.skipLeaveOnInt(json.skipLeaveOnInt);
    }
    if (json.enableDebugIsSet) {
      builder.enableDebug(json.enableDebug);
    }
    if (json.verifyIncomingIsSet) {
      builder.verifyIncoming(json.verifyIncoming);
    }
    if (json.verifyOutgoingIsSet) {
      builder.verifyOutgoing(json.verifyOutgoing);
    }
    if (json.caFile != null) {
      builder.caFile(json.caFile);
    }
    if (json.certFile != null) {
      builder.certFile(json.certFile);
    }
    if (json.keyFile != null) {
      builder.keyFile(json.keyFile);
    }
    if (json.uiDir != null) {
      builder.uiDir(json.uiDir);
    }
    if (json.pidFile != null) {
      builder.pidFile(json.pidFile);
    }
    if (json.enableSyslogIsSet) {
      builder.enableSyslog(json.enableSyslog);
    }
    if (json.rejoinAfterLeaveIsSet) {
      builder.rejoinAfterLeave(json.rejoinAfterLeave);
    }
    if (json.advertiseAddrLAN != null) {
      builder.advertiseAddrLAN(json.advertiseAddrLAN);
    }
    if (json.advertiseAddrWAN != null) {
      builder.advertiseAddrWAN(json.advertiseAddrWAN);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DebugConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DebugConfig instance
   */
  public static ImmutableDebugConfig copyOf(DebugConfig instance) {
    if (instance instanceof ImmutableDebugConfig) {
      return (ImmutableDebugConfig) instance;
    }
    return ImmutableDebugConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDebugConfig ImmutableDebugConfig}.
   * <pre>
   * ImmutableDebugConfig.builder()
   *    .bootstrap(boolean) // required {@link DebugConfig#getBootstrap() bootstrap}
   *    .datacenter(String) // required {@link DebugConfig#getDatacenter() datacenter}
   *    .dataDir(String) // required {@link DebugConfig#getDataDir() dataDir}
   *    .addDnsRecursors|addAllDnsRecursors(String) // {@link DebugConfig#dnsRecursors() dnsRecursors} elements
   *    .dnsDomain(String) // required {@link DebugConfig#getDnsDomain() dnsDomain}
   *    .logLevel(String) // required {@link DebugConfig#getLogLevel() logLevel}
   *    .nodeName(String) // required {@link DebugConfig#getNodeName() nodeName}
   *    .addClientAddrs|addAllClientAddrs(String) // {@link DebugConfig#getClientAddrs() clientAddrs} elements
   *    .bindAddr(String) // required {@link DebugConfig#getBindAddr() bindAddr}
   *    .leaveOnTerm(boolean) // required {@link DebugConfig#getLeaveOnTerm() leaveOnTerm}
   *    .skipLeaveOnInt(boolean) // required {@link DebugConfig#getSkipLeaveOnInt() skipLeaveOnInt}
   *    .enableDebug(boolean) // required {@link DebugConfig#getEnableDebug() enableDebug}
   *    .verifyIncoming(boolean) // required {@link DebugConfig#getVerifyIncoming() verifyIncoming}
   *    .verifyOutgoing(boolean) // required {@link DebugConfig#getVerifyOutgoing() verifyOutgoing}
   *    .caFile(String) // required {@link DebugConfig#getCaFile() caFile}
   *    .certFile(String) // required {@link DebugConfig#getCertFile() certFile}
   *    .keyFile(String) // required {@link DebugConfig#getKeyFile() keyFile}
   *    .uiDir(String) // optional {@link DebugConfig#getUiDir() uiDir}
   *    .pidFile(String) // required {@link DebugConfig#getPidFile() pidFile}
   *    .enableSyslog(boolean) // required {@link DebugConfig#getEnableSyslog() enableSyslog}
   *    .rejoinAfterLeave(boolean) // required {@link DebugConfig#getRejoinAfterLeave() rejoinAfterLeave}
   *    .advertiseAddrLAN(String) // required {@link DebugConfig#getAdvertiseAddrLAN() advertiseAddrLAN}
   *    .advertiseAddrWAN(String) // required {@link DebugConfig#getAdvertiseAddrWAN() advertiseAddrWAN}
   *    .build();
   * </pre>
   * @return A new ImmutableDebugConfig builder
   */
  public static ImmutableDebugConfig.Builder builder() {
    return new ImmutableDebugConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDebugConfig ImmutableDebugConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DebugConfig", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_BOOTSTRAP = 0x1L;
    private static final long INIT_BIT_DATACENTER = 0x2L;
    private static final long INIT_BIT_DATA_DIR = 0x4L;
    private static final long INIT_BIT_DNS_DOMAIN = 0x8L;
    private static final long INIT_BIT_LOG_LEVEL = 0x10L;
    private static final long INIT_BIT_NODE_NAME = 0x20L;
    private static final long INIT_BIT_BIND_ADDR = 0x40L;
    private static final long INIT_BIT_LEAVE_ON_TERM = 0x80L;
    private static final long INIT_BIT_SKIP_LEAVE_ON_INT = 0x100L;
    private static final long INIT_BIT_ENABLE_DEBUG = 0x200L;
    private static final long INIT_BIT_VERIFY_INCOMING = 0x400L;
    private static final long INIT_BIT_VERIFY_OUTGOING = 0x800L;
    private static final long INIT_BIT_CA_FILE = 0x1000L;
    private static final long INIT_BIT_CERT_FILE = 0x2000L;
    private static final long INIT_BIT_KEY_FILE = 0x4000L;
    private static final long INIT_BIT_PID_FILE = 0x8000L;
    private static final long INIT_BIT_ENABLE_SYSLOG = 0x10000L;
    private static final long INIT_BIT_REJOIN_AFTER_LEAVE = 0x20000L;
    private static final long INIT_BIT_ADVERTISE_ADDR_L_A_N = 0x40000L;
    private static final long INIT_BIT_ADVERTISE_ADDR_W_A_N = 0x80000L;
    private long initBits = 0xfffffL;

    private boolean bootstrap;
    private @Nullable String datacenter;
    private @Nullable String dataDir;
    private ImmutableList.Builder<String> dnsRecursors = ImmutableList.builder();
    private @Nullable String dnsDomain;
    private @Nullable String logLevel;
    private @Nullable String nodeName;
    private ImmutableList.Builder<String> clientAddrs = ImmutableList.builder();
    private @Nullable String bindAddr;
    private boolean leaveOnTerm;
    private boolean skipLeaveOnInt;
    private boolean enableDebug;
    private boolean verifyIncoming;
    private boolean verifyOutgoing;
    private @Nullable String caFile;
    private @Nullable String certFile;
    private @Nullable String keyFile;
    private @Nullable String uiDir;
    private @Nullable String pidFile;
    private boolean enableSyslog;
    private boolean rejoinAfterLeave;
    private @Nullable String advertiseAddrLAN;
    private @Nullable String advertiseAddrWAN;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DebugConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DebugConfig instance) {
      Objects.requireNonNull(instance, "instance");
      bootstrap(instance.getBootstrap());
      datacenter(instance.getDatacenter());
      dataDir(instance.getDataDir());
      addAllDnsRecursors(instance.dnsRecursors());
      dnsDomain(instance.getDnsDomain());
      logLevel(instance.getLogLevel());
      nodeName(instance.getNodeName());
      addAllClientAddrs(instance.getClientAddrs());
      bindAddr(instance.getBindAddr());
      leaveOnTerm(instance.getLeaveOnTerm());
      skipLeaveOnInt(instance.getSkipLeaveOnInt());
      enableDebug(instance.getEnableDebug());
      verifyIncoming(instance.getVerifyIncoming());
      verifyOutgoing(instance.getVerifyOutgoing());
      caFile(instance.getCaFile());
      certFile(instance.getCertFile());
      keyFile(instance.getKeyFile());
      Optional<String> uiDirOptional = instance.getUiDir();
      if (uiDirOptional.isPresent()) {
        uiDir(uiDirOptional);
      }
      pidFile(instance.getPidFile());
      enableSyslog(instance.getEnableSyslog());
      rejoinAfterLeave(instance.getRejoinAfterLeave());
      advertiseAddrLAN(instance.getAdvertiseAddrLAN());
      advertiseAddrWAN(instance.getAdvertiseAddrWAN());
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getBootstrap() bootstrap} attribute.
     * @param bootstrap The value for bootstrap 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Bootstrap")
    public final Builder bootstrap(boolean bootstrap) {
      this.bootstrap = bootstrap;
      initBits &= ~INIT_BIT_BOOTSTRAP;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getDatacenter() datacenter} attribute.
     * @param datacenter The value for datacenter 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Datacenter")
    public final Builder datacenter(String datacenter) {
      this.datacenter = Objects.requireNonNull(datacenter, "datacenter");
      initBits &= ~INIT_BIT_DATACENTER;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getDataDir() dataDir} attribute.
     * @param dataDir The value for dataDir 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("DataDir")
    public final Builder dataDir(String dataDir) {
      this.dataDir = Objects.requireNonNull(dataDir, "dataDir");
      initBits &= ~INIT_BIT_DATA_DIR;
      return this;
    }

    /**
     * Adds one element to {@link DebugConfig#dnsRecursors() dnsRecursors} list.
     * @param element A dnsRecursors element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addDnsRecursors(String element) {
      this.dnsRecursors.add(element);
      return this;
    }

    /**
     * Adds elements to {@link DebugConfig#dnsRecursors() dnsRecursors} list.
     * @param elements An array of dnsRecursors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addDnsRecursors(String... elements) {
      this.dnsRecursors.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DebugConfig#dnsRecursors() dnsRecursors} list.
     * @param elements An iterable of dnsRecursors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("DNSRecursors")
    public final Builder dnsRecursors(Iterable<String> elements) {
      this.dnsRecursors = ImmutableList.builder();
      return addAllDnsRecursors(elements);
    }

    /**
     * Adds elements to {@link DebugConfig#dnsRecursors() dnsRecursors} list.
     * @param elements An iterable of dnsRecursors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllDnsRecursors(Iterable<String> elements) {
      this.dnsRecursors.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getDnsDomain() dnsDomain} attribute.
     * @param dnsDomain The value for dnsDomain 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("DNSDomain")
    public final Builder dnsDomain(String dnsDomain) {
      this.dnsDomain = Objects.requireNonNull(dnsDomain, "dnsDomain");
      initBits &= ~INIT_BIT_DNS_DOMAIN;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getLogLevel() logLevel} attribute.
     * @param logLevel The value for logLevel 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("LogLevel")
    public final Builder logLevel(String logLevel) {
      this.logLevel = Objects.requireNonNull(logLevel, "logLevel");
      initBits &= ~INIT_BIT_LOG_LEVEL;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getNodeName() nodeName} attribute.
     * @param nodeName The value for nodeName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("NodeName")
    public final Builder nodeName(String nodeName) {
      this.nodeName = Objects.requireNonNull(nodeName, "nodeName");
      initBits &= ~INIT_BIT_NODE_NAME;
      return this;
    }

    /**
     * Adds one element to {@link DebugConfig#getClientAddrs() clientAddrs} list.
     * @param element A clientAddrs element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addClientAddrs(String element) {
      this.clientAddrs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link DebugConfig#getClientAddrs() clientAddrs} list.
     * @param elements An array of clientAddrs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addClientAddrs(String... elements) {
      this.clientAddrs.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DebugConfig#getClientAddrs() clientAddrs} list.
     * @param elements An iterable of clientAddrs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ClientAddrs")
    public final Builder clientAddrs(Iterable<String> elements) {
      this.clientAddrs = ImmutableList.builder();
      return addAllClientAddrs(elements);
    }

    /**
     * Adds elements to {@link DebugConfig#getClientAddrs() clientAddrs} list.
     * @param elements An iterable of clientAddrs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllClientAddrs(Iterable<String> elements) {
      this.clientAddrs.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getBindAddr() bindAddr} attribute.
     * @param bindAddr The value for bindAddr 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("BindAddr")
    public final Builder bindAddr(String bindAddr) {
      this.bindAddr = Objects.requireNonNull(bindAddr, "bindAddr");
      initBits &= ~INIT_BIT_BIND_ADDR;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getLeaveOnTerm() leaveOnTerm} attribute.
     * @param leaveOnTerm The value for leaveOnTerm 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("LeaveOnTerm")
    public final Builder leaveOnTerm(boolean leaveOnTerm) {
      this.leaveOnTerm = leaveOnTerm;
      initBits &= ~INIT_BIT_LEAVE_ON_TERM;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getSkipLeaveOnInt() skipLeaveOnInt} attribute.
     * @param skipLeaveOnInt The value for skipLeaveOnInt 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("SkipLeaveOnInt")
    public final Builder skipLeaveOnInt(boolean skipLeaveOnInt) {
      this.skipLeaveOnInt = skipLeaveOnInt;
      initBits &= ~INIT_BIT_SKIP_LEAVE_ON_INT;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getEnableDebug() enableDebug} attribute.
     * @param enableDebug The value for enableDebug 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("EnableDebug")
    public final Builder enableDebug(boolean enableDebug) {
      this.enableDebug = enableDebug;
      initBits &= ~INIT_BIT_ENABLE_DEBUG;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getVerifyIncoming() verifyIncoming} attribute.
     * @param verifyIncoming The value for verifyIncoming 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("VerifyIncoming")
    public final Builder verifyIncoming(boolean verifyIncoming) {
      this.verifyIncoming = verifyIncoming;
      initBits &= ~INIT_BIT_VERIFY_INCOMING;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getVerifyOutgoing() verifyOutgoing} attribute.
     * @param verifyOutgoing The value for verifyOutgoing 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("VerifyOutgoing")
    public final Builder verifyOutgoing(boolean verifyOutgoing) {
      this.verifyOutgoing = verifyOutgoing;
      initBits &= ~INIT_BIT_VERIFY_OUTGOING;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getCaFile() caFile} attribute.
     * @param caFile The value for caFile 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("CAFile")
    public final Builder caFile(String caFile) {
      this.caFile = Objects.requireNonNull(caFile, "caFile");
      initBits &= ~INIT_BIT_CA_FILE;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getCertFile() certFile} attribute.
     * @param certFile The value for certFile 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("CertFile")
    public final Builder certFile(String certFile) {
      this.certFile = Objects.requireNonNull(certFile, "certFile");
      initBits &= ~INIT_BIT_CERT_FILE;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getKeyFile() keyFile} attribute.
     * @param keyFile The value for keyFile 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("KeyFile")
    public final Builder keyFile(String keyFile) {
      this.keyFile = Objects.requireNonNull(keyFile, "keyFile");
      initBits &= ~INIT_BIT_KEY_FILE;
      return this;
    }

    /**
     * Initializes the optional value {@link DebugConfig#getUiDir() uiDir} to uiDir.
     * @param uiDir The value for uiDir
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder uiDir(String uiDir) {
      this.uiDir = Objects.requireNonNull(uiDir, "uiDir");
      return this;
    }

    /**
     * Initializes the optional value {@link DebugConfig#getUiDir() uiDir} to uiDir.
     * @param uiDir The value for uiDir
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("UiDir")
    public final Builder uiDir(Optional<String> uiDir) {
      this.uiDir = uiDir.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getPidFile() pidFile} attribute.
     * @param pidFile The value for pidFile 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("PidFile")
    public final Builder pidFile(String pidFile) {
      this.pidFile = Objects.requireNonNull(pidFile, "pidFile");
      initBits &= ~INIT_BIT_PID_FILE;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getEnableSyslog() enableSyslog} attribute.
     * @param enableSyslog The value for enableSyslog 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("EnableSyslog")
    public final Builder enableSyslog(boolean enableSyslog) {
      this.enableSyslog = enableSyslog;
      initBits &= ~INIT_BIT_ENABLE_SYSLOG;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getRejoinAfterLeave() rejoinAfterLeave} attribute.
     * @param rejoinAfterLeave The value for rejoinAfterLeave 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("RejoinAfterLeave")
    public final Builder rejoinAfterLeave(boolean rejoinAfterLeave) {
      this.rejoinAfterLeave = rejoinAfterLeave;
      initBits &= ~INIT_BIT_REJOIN_AFTER_LEAVE;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getAdvertiseAddrLAN() advertiseAddrLAN} attribute.
     * @param advertiseAddrLAN The value for advertiseAddrLAN 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("AdvertiseAddrLAN")
    public final Builder advertiseAddrLAN(String advertiseAddrLAN) {
      this.advertiseAddrLAN = Objects.requireNonNull(advertiseAddrLAN, "advertiseAddrLAN");
      initBits &= ~INIT_BIT_ADVERTISE_ADDR_L_A_N;
      return this;
    }

    /**
     * Initializes the value for the {@link DebugConfig#getAdvertiseAddrWAN() advertiseAddrWAN} attribute.
     * @param advertiseAddrWAN The value for advertiseAddrWAN 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("AdvertiseAddrWAN")
    public final Builder advertiseAddrWAN(String advertiseAddrWAN) {
      this.advertiseAddrWAN = Objects.requireNonNull(advertiseAddrWAN, "advertiseAddrWAN");
      initBits &= ~INIT_BIT_ADVERTISE_ADDR_W_A_N;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDebugConfig ImmutableDebugConfig}.
     * @return An immutable instance of DebugConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDebugConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDebugConfig(
          bootstrap,
          datacenter,
          dataDir,
          dnsRecursors.build(),
          dnsDomain,
          logLevel,
          nodeName,
          clientAddrs.build(),
          bindAddr,
          leaveOnTerm,
          skipLeaveOnInt,
          enableDebug,
          verifyIncoming,
          verifyOutgoing,
          caFile,
          certFile,
          keyFile,
          uiDir,
          pidFile,
          enableSyslog,
          rejoinAfterLeave,
          advertiseAddrLAN,
          advertiseAddrWAN);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BOOTSTRAP) != 0) attributes.add("bootstrap");
      if ((initBits & INIT_BIT_DATACENTER) != 0) attributes.add("datacenter");
      if ((initBits & INIT_BIT_DATA_DIR) != 0) attributes.add("dataDir");
      if ((initBits & INIT_BIT_DNS_DOMAIN) != 0) attributes.add("dnsDomain");
      if ((initBits & INIT_BIT_LOG_LEVEL) != 0) attributes.add("logLevel");
      if ((initBits & INIT_BIT_NODE_NAME) != 0) attributes.add("nodeName");
      if ((initBits & INIT_BIT_BIND_ADDR) != 0) attributes.add("bindAddr");
      if ((initBits & INIT_BIT_LEAVE_ON_TERM) != 0) attributes.add("leaveOnTerm");
      if ((initBits & INIT_BIT_SKIP_LEAVE_ON_INT) != 0) attributes.add("skipLeaveOnInt");
      if ((initBits & INIT_BIT_ENABLE_DEBUG) != 0) attributes.add("enableDebug");
      if ((initBits & INIT_BIT_VERIFY_INCOMING) != 0) attributes.add("verifyIncoming");
      if ((initBits & INIT_BIT_VERIFY_OUTGOING) != 0) attributes.add("verifyOutgoing");
      if ((initBits & INIT_BIT_CA_FILE) != 0) attributes.add("caFile");
      if ((initBits & INIT_BIT_CERT_FILE) != 0) attributes.add("certFile");
      if ((initBits & INIT_BIT_KEY_FILE) != 0) attributes.add("keyFile");
      if ((initBits & INIT_BIT_PID_FILE) != 0) attributes.add("pidFile");
      if ((initBits & INIT_BIT_ENABLE_SYSLOG) != 0) attributes.add("enableSyslog");
      if ((initBits & INIT_BIT_REJOIN_AFTER_LEAVE) != 0) attributes.add("rejoinAfterLeave");
      if ((initBits & INIT_BIT_ADVERTISE_ADDR_L_A_N) != 0) attributes.add("advertiseAddrLAN");
      if ((initBits & INIT_BIT_ADVERTISE_ADDR_W_A_N) != 0) attributes.add("advertiseAddrWAN");
      return "Cannot build DebugConfig, some of required attributes are not set " + attributes;
    }
  }
}
