package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Config}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableConfig.builder()}.
 */
@Generated(from = "Config", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableConfig extends Config {
  private final String datacenter;
  private final String nodeName;
  private final String revision;
  private final boolean server;
  private final String version;

  private ImmutableConfig(
      String datacenter,
      String nodeName,
      String revision,
      boolean server,
      String version) {
    this.datacenter = datacenter;
    this.nodeName = nodeName;
    this.revision = revision;
    this.server = server;
    this.version = version;
  }

  /**
   * @return The value of the {@code datacenter} attribute
   */
  @JsonProperty("Datacenter")
  @Override
  public String getDatacenter() {
    return datacenter;
  }

  /**
   * @return The value of the {@code nodeName} attribute
   */
  @JsonProperty("NodeName")
  @Override
  public String getNodeName() {
    return nodeName;
  }

  /**
   * @return The value of the {@code revision} attribute
   */
  @JsonProperty("Revision")
  @Override
  public String getRevision() {
    return revision;
  }

  /**
   * @return The value of the {@code server} attribute
   */
  @JsonProperty("Server")
  @Override
  public boolean getServer() {
    return server;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("Version")
  @Override
  public String getVersion() {
    return version;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getDatacenter() datacenter} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for datacenter
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withDatacenter(String value) {
    String newValue = Objects.requireNonNull(value, "datacenter");
    if (this.datacenter.equals(newValue)) return this;
    return new ImmutableConfig(newValue, this.nodeName, this.revision, this.server, this.version);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getNodeName() nodeName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nodeName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withNodeName(String value) {
    String newValue = Objects.requireNonNull(value, "nodeName");
    if (this.nodeName.equals(newValue)) return this;
    return new ImmutableConfig(this.datacenter, newValue, this.revision, this.server, this.version);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getRevision() revision} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for revision
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withRevision(String value) {
    String newValue = Objects.requireNonNull(value, "revision");
    if (this.revision.equals(newValue)) return this;
    return new ImmutableConfig(this.datacenter, this.nodeName, newValue, this.server, this.version);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getServer() server} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for server
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withServer(boolean value) {
    if (this.server == value) return this;
    return new ImmutableConfig(this.datacenter, this.nodeName, this.revision, value, this.version);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getVersion() version} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withVersion(String value) {
    String newValue = Objects.requireNonNull(value, "version");
    if (this.version.equals(newValue)) return this;
    return new ImmutableConfig(this.datacenter, this.nodeName, this.revision, this.server, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConfig
        && equalTo((ImmutableConfig) another);
  }

  private boolean equalTo(ImmutableConfig another) {
    return datacenter.equals(another.datacenter)
        && nodeName.equals(another.nodeName)
        && revision.equals(another.revision)
        && server == another.server
        && version.equals(another.version);
  }

  /**
   * Computes a hash code from attributes: {@code datacenter}, {@code nodeName}, {@code revision}, {@code server}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + datacenter.hashCode();
    h += (h << 5) + nodeName.hashCode();
    h += (h << 5) + revision.hashCode();
    h += (h << 5) + Booleans.hashCode(server);
    h += (h << 5) + version.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Config} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Config")
        .omitNullValues()
        .add("datacenter", datacenter)
        .add("nodeName", nodeName)
        .add("revision", revision)
        .add("server", server)
        .add("version", version)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Config", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends Config {
    @Nullable String datacenter;
    @Nullable String nodeName;
    @Nullable String revision;
    boolean server;
    boolean serverIsSet;
    @Nullable String version;
    @JsonProperty("Datacenter")
    public void setDatacenter(String datacenter) {
      this.datacenter = datacenter;
    }
    @JsonProperty("NodeName")
    public void setNodeName(String nodeName) {
      this.nodeName = nodeName;
    }
    @JsonProperty("Revision")
    public void setRevision(String revision) {
      this.revision = revision;
    }
    @JsonProperty("Server")
    public void setServer(boolean server) {
      this.server = server;
      this.serverIsSet = true;
    }
    @JsonProperty("Version")
    public void setVersion(String version) {
      this.version = version;
    }
    @Override
    public String getDatacenter() { throw new UnsupportedOperationException(); }
    @Override
    public String getNodeName() { throw new UnsupportedOperationException(); }
    @Override
    public String getRevision() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getServer() { throw new UnsupportedOperationException(); }
    @Override
    public String getVersion() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableConfig fromJson(Json json) {
    ImmutableConfig.Builder builder = ImmutableConfig.builder();
    if (json.datacenter != null) {
      builder.datacenter(json.datacenter);
    }
    if (json.nodeName != null) {
      builder.nodeName(json.nodeName);
    }
    if (json.revision != null) {
      builder.revision(json.revision);
    }
    if (json.serverIsSet) {
      builder.server(json.server);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Config} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Config instance
   */
  public static ImmutableConfig copyOf(Config instance) {
    if (instance instanceof ImmutableConfig) {
      return (ImmutableConfig) instance;
    }
    return ImmutableConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableConfig ImmutableConfig}.
   * <pre>
   * ImmutableConfig.builder()
   *    .datacenter(String) // required {@link Config#getDatacenter() datacenter}
   *    .nodeName(String) // required {@link Config#getNodeName() nodeName}
   *    .revision(String) // required {@link Config#getRevision() revision}
   *    .server(boolean) // required {@link Config#getServer() server}
   *    .version(String) // required {@link Config#getVersion() version}
   *    .build();
   * </pre>
   * @return A new ImmutableConfig builder
   */
  public static ImmutableConfig.Builder builder() {
    return new ImmutableConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableConfig ImmutableConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Config", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DATACENTER = 0x1L;
    private static final long INIT_BIT_NODE_NAME = 0x2L;
    private static final long INIT_BIT_REVISION = 0x4L;
    private static final long INIT_BIT_SERVER = 0x8L;
    private static final long INIT_BIT_VERSION = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String datacenter;
    private @Nullable String nodeName;
    private @Nullable String revision;
    private boolean server;
    private @Nullable String version;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Config} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Config instance) {
      Objects.requireNonNull(instance, "instance");
      datacenter(instance.getDatacenter());
      nodeName(instance.getNodeName());
      revision(instance.getRevision());
      server(instance.getServer());
      version(instance.getVersion());
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getDatacenter() datacenter} attribute.
     * @param datacenter The value for datacenter 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Datacenter")
    public final Builder datacenter(String datacenter) {
      this.datacenter = Objects.requireNonNull(datacenter, "datacenter");
      initBits &= ~INIT_BIT_DATACENTER;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getNodeName() nodeName} attribute.
     * @param nodeName The value for nodeName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("NodeName")
    public final Builder nodeName(String nodeName) {
      this.nodeName = Objects.requireNonNull(nodeName, "nodeName");
      initBits &= ~INIT_BIT_NODE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getRevision() revision} attribute.
     * @param revision The value for revision 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Revision")
    public final Builder revision(String revision) {
      this.revision = Objects.requireNonNull(revision, "revision");
      initBits &= ~INIT_BIT_REVISION;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getServer() server} attribute.
     * @param server The value for server 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Server")
    public final Builder server(boolean server) {
      this.server = server;
      initBits &= ~INIT_BIT_SERVER;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Version")
    public final Builder version(String version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableConfig ImmutableConfig}.
     * @return An immutable instance of Config
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableConfig(datacenter, nodeName, revision, server, version);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DATACENTER) != 0) attributes.add("datacenter");
      if ((initBits & INIT_BIT_NODE_NAME) != 0) attributes.add("nodeName");
      if ((initBits & INIT_BIT_REVISION) != 0) attributes.add("revision");
      if ((initBits & INIT_BIT_SERVER) != 0) attributes.add("server");
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      return "Cannot build Config, some of required attributes are not set " + attributes;
    }
  }
}
