/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.target;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.reflect.target.ReflectionHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Map;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;

@TargetClass(value=Executable.class)
public final class Target_java_lang_reflect_Executable {
    @Alias
    Parameter[] parameters;
    @Alias
    Map<Class<? extends Annotation>, Annotation> declaredAnnotations;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ParameterAnnotationsComputer.class)
    Annotation[][] parameterAnnotations;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=AnnotatedReceiverTypeComputer.class)
    AnnotatedType annotatedReceiverType;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=AnnotatedParameterTypesComputer.class)
    AnnotatedType[] annotatedParameterTypes;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=AnnotatedReturnTypeComputer.class)
    AnnotatedType annotatedReturnType;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=AnnotatedExceptionTypesComputer.class)
    AnnotatedType[] annotatedExceptionTypes;

    @Alias
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    native Target_java_lang_reflect_Executable getRoot();

    @Substitute
    private Parameter[] privateGetParameters() {
        Target_java_lang_reflect_Executable holder = ReflectionHelper.getHolder(this);
        return ReflectionHelper.requireNonNull(holder.parameters, "Parameters must be computed during native image generation");
    }

    @Substitute
    Map<Class<? extends Annotation>, Annotation> declaredAnnotations() {
        Target_java_lang_reflect_Executable holder = ReflectionHelper.getHolder(this);
        return ReflectionHelper.requireNonNull(holder.declaredAnnotations, "Annotations must be computed during native image generation");
    }

    @Substitute
    Annotation[][] sharedGetParameterAnnotations(Class<?>[] parameterTypes, byte[] annotations) {
        Target_java_lang_reflect_Executable holder = ReflectionHelper.getHolder(this);
        return ReflectionHelper.requireNonNull(holder.parameterAnnotations, "Parameter annotations must be computed during native image generation");
    }

    @Substitute
    public AnnotatedType getAnnotatedReceiverType() {
        Target_java_lang_reflect_Executable holder = ReflectionHelper.getHolder(this);
        return holder.annotatedReceiverType;
    }

    @Substitute
    public AnnotatedType[] getAnnotatedParameterTypes() {
        Target_java_lang_reflect_Executable holder = ReflectionHelper.getHolder(this);
        return ReflectionHelper.requireNonNull(holder.annotatedParameterTypes, "Annotated parameter types must be computed during native image generation");
    }

    @Substitute
    public AnnotatedType getAnnotatedReturnType0(Type returnType) {
        Target_java_lang_reflect_Executable holder = ReflectionHelper.getHolder(this);
        return ReflectionHelper.requireNonNull(holder.annotatedReturnType, "Annotated return type must be computed during native image generation");
    }

    @Substitute
    public AnnotatedType[] getAnnotatedExceptionTypes() {
        Target_java_lang_reflect_Executable holder = ReflectionHelper.getHolder(this);
        return ReflectionHelper.requireNonNull(holder.annotatedExceptionTypes, "Annotated exception types must be computed during native image generation");
    }

    public static final class AnnotatedExceptionTypesComputer
    implements RecomputeFieldValue.CustomFieldValueComputer {
        @Override
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            Executable executable = (Executable)receiver;
            return executable.getAnnotatedExceptionTypes();
        }
    }

    public static final class AnnotatedReturnTypeComputer
    implements RecomputeFieldValue.CustomFieldValueComputer {
        @Override
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            Executable executable = (Executable)receiver;
            return executable.getAnnotatedReturnType();
        }
    }

    public static final class AnnotatedParameterTypesComputer
    implements RecomputeFieldValue.CustomFieldValueComputer {
        @Override
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            Executable executable = (Executable)receiver;
            return executable.getAnnotatedParameterTypes();
        }
    }

    public static final class AnnotatedReceiverTypeComputer
    implements RecomputeFieldValue.CustomFieldValueComputer {
        @Override
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            Executable executable = (Executable)receiver;
            return executable.getAnnotatedReceiverType();
        }
    }

    public static final class ParameterAnnotationsComputer
    implements RecomputeFieldValue.CustomFieldValueComputer {
        @Override
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            Executable executable = (Executable)receiver;
            return executable.getParameterAnnotations();
        }
    }
}

