/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.util.ConstantFoldUtil;
import org.graalvm.compiler.options.OptionValues;

public final class ConstantFoldLoadFieldPlugin
implements NodePlugin {
    private ClassInitializationSupport classInitializationSupport;

    public ConstantFoldLoadFieldPlugin(ClassInitializationSupport classInitializationSupport) {
        this.classInitializationSupport = classInitializationSupport;
    }

    public boolean handleLoadField(GraphBuilderContext b, ValueNode receiver, ResolvedJavaField field) {
        if (receiver.isConstant()) {
            JavaConstant asJavaConstant = receiver.asJavaConstant();
            return this.tryConstantFold(b, field, asJavaConstant);
        }
        return false;
    }

    public boolean handleLoadStaticField(GraphBuilderContext b, ResolvedJavaField staticField) {
        return this.tryConstantFold(b, staticField, null);
    }

    private boolean tryConstantFold(GraphBuilderContext b, ResolvedJavaField field, JavaConstant receiver) {
        ConstantNode result = ConstantFoldUtil.tryConstantFold((ConstantFieldProvider)b.getConstantFieldProvider(), (ConstantReflectionProvider)b.getConstantReflection(), (MetaAccessProvider)b.getMetaAccess(), (ResolvedJavaField)field, (JavaConstant)receiver, (OptionValues)b.getOptions());
        if (result != null) {
            assert (result.asJavaConstant() != null);
            JavaConstant value = result.asJavaConstant();
            if (b.getMetaAccess() instanceof AnalysisMetaAccess && value.getJavaKind() == JavaKind.Object && value.isNonNull()) {
                Object root;
                SubstrateObjectConstant sValue = (SubstrateObjectConstant)value;
                SubstrateObjectConstant sReceiver = (SubstrateObjectConstant)receiver;
                if (receiver == null) {
                    root = field;
                } else {
                    root = sReceiver.getRoot();
                    assert (root != null || SubstrateObjectConstant.asObject((Constant)receiver) instanceof String) : receiver.toValueString() + " : " + field + " : " + b.getGraph();
                }
                sValue.setRoot(root);
            }
            assert (!this.classInitializationSupport.shouldInitializeAtRuntime(field.getDeclaringClass()) || value.isDefaultForKind()) : "Fields in classes that are marked for initialization at run time must not be constant folded, unless they are not written in the static initializer, i.e., have the default value: " + field.format("%H.%n");
            result = (ConstantNode)b.getGraph().unique((Node)result);
            b.push(field.getJavaKind(), (ValueNode)result);
            return true;
        }
        return false;
    }
}

