/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.hosted.meta.MethodPointer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.serviceprovider.BufferUtil;
import org.graalvm.nativeimage.c.function.CFunctionPointer;

public final class RelocatableBuffer {
    protected final String name;
    protected final long size;
    protected final ByteBuffer buffer;
    private final TreeMap<Integer, Info> map;
    static final long serialVersionUID = 0L;
    static final int WORD_SIZE = 8;

    public static RelocatableBuffer factory(String name, long size, ByteOrder byteOrder) {
        return new RelocatableBuffer(name, size, byteOrder);
    }

    public Info getInfo(int key) {
        return this.getMap().get(key);
    }

    public Info addDirectRelocationWithAddend(int key, int relocationSize, Long explicitAddend, Object targetObject) {
        Info info = this.infoFactory(ObjectFile.RelocationKind.DIRECT, relocationSize, explicitAddend, targetObject);
        Info result = this.putInfo(key, info);
        return result;
    }

    public Info addDirectRelocationWithoutAddend(int key, int relocationSize, Object targetObject) {
        Info info = this.infoFactory(ObjectFile.RelocationKind.DIRECT, relocationSize, null, targetObject);
        Info result = this.putInfo(key, info);
        return result;
    }

    public Info addPCRelativeRelocationWithAddend(int key, int relocationSize, Long explicitAddend, Object targetObject) {
        Info info = this.infoFactory(ObjectFile.RelocationKind.PC_RELATIVE, relocationSize, explicitAddend, targetObject);
        Info result = this.putInfo(key, info);
        return result;
    }

    public Info addRelocation(int key, ObjectFile.RelocationKind relocationKind, int relocationSize, Long explicitAddend, Object targetObject) {
        Info info = this.infoFactory(relocationKind, relocationSize, explicitAddend, targetObject);
        Info result = this.putInfo(key, info);
        return result;
    }

    public int mapSize() {
        return this.getMap().size();
    }

    public Set<Map.Entry<Integer, Info>> entrySet() {
        return this.getMap().entrySet();
    }

    private Info putInfo(int key, Info value) {
        return this.getMap().put(key, value);
    }

    protected Map<Integer, Info> getMap() {
        return this.map;
    }

    public byte getByte(int index) {
        return this.getBuffer().get(index);
    }

    public RelocatableBuffer putByte(byte value) {
        this.getBuffer().put(value);
        return this;
    }

    public RelocatableBuffer putByte(int index, byte value) {
        this.getBuffer().put(index, value);
        return this;
    }

    public RelocatableBuffer putBytes(byte[] source, int offset, int length) {
        this.getBuffer().put(source, offset, length);
        return this;
    }

    public RelocatableBuffer putInt(int index, int value) {
        this.getBuffer().putInt(index, value);
        return this;
    }

    public int getPosition() {
        return this.getBuffer().position();
    }

    public RelocatableBuffer setPosition(int newPosition) {
        BufferUtil.asBaseBuffer((Buffer)this.getBuffer()).position(newPosition);
        return this;
    }

    protected byte[] getBytes() {
        return this.getBuffer().array();
    }

    protected ByteBuffer getBuffer() {
        return this.buffer;
    }

    private Info infoFactory(ObjectFile.RelocationKind kind, int relocationSize, Long explicitAddend, Object targetObject) {
        return new Info(kind, relocationSize, explicitAddend, targetObject);
    }

    public String getName() {
        return this.name;
    }

    protected static String targetObjectClassification(Object targetObject) {
        StringBuilder result = new StringBuilder();
        if (targetObject == null) {
            result.append("null");
        } else if (targetObject instanceof CFunctionPointer) {
            result.append("pointer to function");
            if (targetObject instanceof MethodPointer) {
                MethodPointer mp = (MethodPointer)targetObject;
                ResolvedJavaMethod hm = mp.getMethod();
                result.append("  name: ");
                result.append(hm.getName());
            }
        } else {
            result.append("pointer to data");
        }
        return result.toString();
    }

    private RelocatableBuffer(String name, long size, ByteOrder byteOrder) {
        this.name = name;
        this.size = size;
        int intSize = NumUtil.safeToInt((long)size);
        this.buffer = ByteBuffer.wrap(new byte[intSize]).order(byteOrder);
        this.map = new TreeMap();
    }

    public class Info {
        private final int relocationSize;
        private final ObjectFile.RelocationKind relocationKind;
        private final Long explicitAddend;
        private final Object targetObject;

        public int getRelocationSize() {
            return this.relocationSize;
        }

        public ObjectFile.RelocationKind getRelocationKind() {
            return this.relocationKind;
        }

        public boolean hasExplicitAddend() {
            return this.explicitAddend != null;
        }

        public Long getExplicitAddend() {
            return this.explicitAddend;
        }

        public Object getTargetObject() {
            return this.targetObject;
        }

        protected Info(ObjectFile.RelocationKind kind, int relocationSize, Long explicitAddend, Object targetObject) {
            this.relocationKind = kind;
            this.relocationSize = relocationSize;
            this.explicitAddend = explicitAddend;
            this.targetObject = targetObject;
        }

        public String toString() {
            return "RelocatableBuffer.Info(targetObject=" + this.targetObject + " relocationSize=" + this.relocationSize + " relocationKind=" + this.relocationKind + " explicitAddend=" + this.explicitAddend + ")";
        }
    }
}

