/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.agent;

import com.oracle.svm.hosted.agent.ClassInitializationTrackingVisitor;
import com.oracle.svm.util.AgentSupport;
import java.lang.instrument.Instrumentation;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public class NativeImageBytecodeInstrumentationAgent {
    public static void premain(String agentArgs, Instrumentation inst) {
        inst.addTransformer(AgentSupport.createClassInstrumentationTransformer(NativeImageBytecodeInstrumentationAgent::applyTransformation), false);
    }

    static byte[] applyTransformation(String moduleName, ClassLoader loader, String className, byte[] classfileBuffer) {
        ClassReader reader = new ClassReader(classfileBuffer);
        ClassWriter writer = new ClassWriter(reader, 2);
        ClassInitializationTrackingVisitor visitor = new ClassInitializationTrackingVisitor(moduleName, loader, className, writer);
        reader.accept(visitor, 0);
        return writer.toByteArray();
    }
}

