/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class ReachabilityHandlerFeature
implements Feature {
    private final IdentityHashMap<Consumer<Feature.DuringAnalysisAccess>, Set<Object>> activeHandlers = new IdentityHashMap();
    private final IdentityHashMap<Consumer<Feature.DuringAnalysisAccess>, Boolean> triggeredHandlers = new IdentityHashMap();

    public static ReachabilityHandlerFeature singleton() {
        return (ReachabilityHandlerFeature)ImageSingletons.lookup(ReachabilityHandlerFeature.class);
    }

    public void registerReachabilityHandler(Feature.BeforeAnalysisAccess a, Consumer<Feature.DuringAnalysisAccess> callback, Object[] triggers) {
        if (this.triggeredHandlers.containsKey(callback)) {
            return;
        }
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        AnalysisMetaAccess metaAccess = access.getMetaAccess();
        Set triggerSet = this.activeHandlers.computeIfAbsent(callback, c -> new HashSet());
        for (Object trigger : triggers) {
            if (trigger instanceof Class) {
                triggerSet.add(metaAccess.lookupJavaType((Class)trigger));
                continue;
            }
            if (trigger instanceof Field) {
                triggerSet.add(metaAccess.lookupJavaField((Field)trigger));
                continue;
            }
            if (trigger instanceof Executable) {
                triggerSet.add(metaAccess.lookupJavaMethod((Executable)trigger));
                continue;
            }
            throw UserError.abort("registerReachabilityHandler called with an element that is not a Class, Field, Method, or Constructor: " + trigger.getClass().getTypeName());
        }
        if (access instanceof Feature.DuringAnalysisAccess) {
            ((Feature.DuringAnalysisAccess)access).requireAnalysisIteration();
        }
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        Iterator<Map.Entry<Consumer<Feature.DuringAnalysisAccess>, Set<Object>>> iter = this.activeHandlers.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Consumer<Feature.DuringAnalysisAccess>, Set<Object>> entry = iter.next();
            if (!ReachabilityHandlerFeature.isTriggered(access, entry.getValue())) continue;
            Consumer<Feature.DuringAnalysisAccess> callback = entry.getKey();
            this.triggeredHandlers.put(callback, Boolean.TRUE);
            iter.remove();
            callback.accept(access);
        }
    }

    private static boolean isTriggered(FeatureImpl.DuringAnalysisAccessImpl access, Set<Object> triggers) {
        for (Object trigger : triggers) {
            if (trigger instanceof AnalysisType) {
                if (!access.isReachable((AnalysisType)trigger)) continue;
                return true;
            }
            if (trigger instanceof AnalysisField) {
                if (!access.isReachable((AnalysisField)trigger)) continue;
                return true;
            }
            if (trigger instanceof AnalysisMethod) {
                if (!access.isReachable((AnalysisMethod)trigger)) continue;
                return true;
            }
            throw VMError.shouldNotReachHere("Unexpected trigger: " + trigger.getClass().getTypeName());
        }
        return false;
    }
}

