/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jni.JNIRuntimeAccess;
import com.oracle.svm.core.util.VMError;
import java.net.InetAddress;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@Platforms(value={Platform.WINDOWS.class})
@AutomaticFeature
@CLibrary(value="net", requireStatic=true)
class WindowsJavaNetSubstitutionsFeature
implements Feature {
    WindowsJavaNetSubstitutionsFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        try {
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddress").getDeclaredMethod("anyLocalAddress", new Class[0]));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddressContainer"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddressContainer").getDeclaredField("addr"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetSocketAddress"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetSocketAddress").getDeclaredConstructor(InetAddress.class, Integer.TYPE));
            JNIRuntimeAccess.register(String.class.getDeclaredConstructor(byte[].class, String.class));
            JNIRuntimeAccess.register(String.class.getDeclaredMethod("getBytes", String.class));
            JNIRuntimeAccess.register(access.findClassByName("java.net.SocketInputStream"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.SocketOutputStream"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.DualStackPlainDatagramSocketImpl"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.DatagramSocketImpl"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.DatagramSocketImpl").getDeclaredField("fd"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.DatagramSocketImpl").getDeclaredField("localPort"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.AbstractPlainDatagramSocketImpl"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.AbstractPlainDatagramSocketImpl").getDeclaredField("timeout"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.AbstractPlainDatagramSocketImpl").getDeclaredField("trafficClass"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.AbstractPlainDatagramSocketImpl").getDeclaredField("connected"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.TwoStacksPlainDatagramSocketImpl"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.TwoStacksPlainDatagramSocketImpl").getDeclaredField("fd1"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.TwoStacksPlainDatagramSocketImpl").getDeclaredField("fduse"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.TwoStacksPlainDatagramSocketImpl").getDeclaredField("lastfd"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.TwoStacksPlainSocketImpl"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.TwoStacksPlainSocketImpl").getDeclaredField("fd1"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.TwoStacksPlainSocketImpl").getDeclaredField("lastfd"));
            JNIRuntimeAccess.register(access.findClassByName("java.lang.Integer").getDeclaredConstructor(Integer.TYPE));
            JNIRuntimeAccess.register(access.findClassByName("java.lang.Integer").getDeclaredField("value"));
            JNIRuntimeAccess.register(access.findClassByName("java.lang.Boolean"));
            JNIRuntimeAccess.register(access.findClassByName("java.lang.Boolean").getDeclaredConstructor(Boolean.TYPE));
            JNIRuntimeAccess.register(access.findClassByName("java.lang.Boolean").getDeclaredMethod("getBoolean", String.class));
            RuntimeReflection.register((Class[])new Class[]{access.findClassByName("java.net.InetAddressImpl")});
            RuntimeReflection.register((Class[])new Class[]{access.findClassByName("java.net.Inet4AddressImpl")});
            RuntimeReflection.register((Class[])new Class[]{access.findClassByName("java.net.Inet6AddressImpl")});
            RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{access.findClassByName("java.net.Inet4AddressImpl")});
            RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{access.findClassByName("java.net.Inet6AddressImpl")});
        }
        catch (Exception e) {
            VMError.shouldNotReachHere("WindowsJavaNetSubstitutionsFeature: Error registering class or method: ", e);
        }
    }
}

