/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jni.JNIRuntimeAccess;
import com.oracle.svm.core.util.VMError;
import java.io.FileDescriptor;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.hosted.Feature;

@Platforms(value={Platform.WINDOWS.class})
@AutomaticFeature
@CLibrary(value="java", requireStatic=true)
class WindowsJavaIOSubstituteFeature
implements Feature {
    WindowsJavaIOSubstituteFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        JNIRuntimeAccess.register(access.findClassByName("java.io.WinNTFileSystem"));
        try {
            JNIRuntimeAccess.register(FileDescriptor.class.getDeclaredField("handle"));
        }
        catch (NoSuchFieldException e) {
            VMError.shouldNotReachHere("WindowsJavaIOSubstitutionFeature: Error registering class or method: ", e);
        }
    }
}

