/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.stack;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.stack.JavaFrameAnchors;
import com.oracle.svm.core.stack.JavaStackWalk;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class JavaStackWalker {
    private JavaStackWalker() {
    }

    public static boolean initWalk(JavaStackWalk walk, Pointer startSP, CodePointer startIP) {
        walk.setSP(startSP);
        walk.setIP(startIP);
        walk.setStartSP(startSP);
        walk.setStartIP(startIP);
        walk.setAnchor(JavaFrameAnchors.getFrameAnchor());
        return true;
    }

    public static boolean initWalk(JavaStackWalk walk, IsolateThread thread) {
        VMOperation.guaranteeInProgress("Walking the stack of another thread is only safe when that thread is stopped at a safepoint");
        JavaFrameAnchor anchor = JavaFrameAnchors.getFrameAnchor(thread);
        boolean result = anchor.isNonNull();
        Pointer sp = (Pointer)WordFactory.nullPointer();
        CodePointer ip = (CodePointer)WordFactory.nullPointer();
        if (result) {
            sp = anchor.getLastJavaSP();
            ip = anchor.getLastJavaIP();
        }
        walk.setSP(sp);
        walk.setIP(ip);
        walk.setStartSP(sp);
        walk.setStartIP(ip);
        walk.setAnchor(anchor);
        return result;
    }

    public static boolean continueWalk(JavaStackWalk walk) {
        if (walk.getSP().isNull() || walk.getIP().isNull()) {
            return false;
        }
        Pointer sp = walk.getSP();
        CodePointer ip = walk.getIP();
        DeoptimizedFrame deoptFrame = Deoptimizer.checkDeoptimized(sp);
        long totalFrameSize = deoptFrame != null ? deoptFrame.getSourceTotalFrameSize() : CodeInfoTable.lookupTotalFrameSize(ip);
        if (totalFrameSize == -1L) {
            Log.log().string("Stack walk must walk only frames of known code:").string("  startSP=").hex((WordBase)walk.getStartSP()).string("  startIP=").hex((WordBase)walk.getStartIP()).string("  sp=").hex((WordBase)sp).string("  ip=").hex((WordBase)ip).string("  deoptFrame=").object(deoptFrame).newline();
            throw VMError.shouldNotReachHere("Stack walk must walk only frames of known code");
        }
        if (totalFrameSize != 1L) {
            sp = sp.add(WordFactory.unsigned((long)totalFrameSize));
            ip = FrameAccess.singleton().readReturnAddress(sp);
            walk.setSP(sp);
            walk.setIP(ip);
            return true;
        }
        JavaFrameAnchor anchor = walk.getAnchor();
        while (anchor.isNonNull() && anchor.getLastJavaSP().belowOrEqual((UnsignedWord)sp)) {
            anchor = anchor.getPreviousAnchor();
        }
        if (anchor.isNonNull()) {
            assert (anchor.getLastJavaSP().aboveThan((UnsignedWord)sp));
            walk.setSP(anchor.getLastJavaSP());
            walk.setIP(anchor.getLastJavaIP());
            walk.setAnchor(anchor.getPreviousAnchor());
            return true;
        }
        walk.setSP((Pointer)WordFactory.nullPointer());
        walk.setIP((CodePointer)WordFactory.nullPointer());
        walk.setAnchor((JavaFrameAnchor)WordFactory.nullPointer());
        return false;
    }

    @AlwaysInline(value="avoid virtual call to visitor")
    public static boolean walkCurrentThread(Pointer startSP, CodePointer startIP, StackFrameVisitor visitor) {
        JavaStackWalk walk = (JavaStackWalk)StackValue.get(JavaStackWalk.class);
        boolean hasFrames = JavaStackWalker.initWalk(walk, startSP, startIP);
        return JavaStackWalker.doWalk(walk, visitor, hasFrames);
    }

    @AlwaysInline(value="avoid virtual call to visitor")
    public static boolean walkThread(IsolateThread thread, StackFrameVisitor visitor) {
        JavaStackWalk walk = (JavaStackWalk)StackValue.get(JavaStackWalk.class);
        boolean hasFrames = JavaStackWalker.initWalk(walk, thread);
        return JavaStackWalker.doWalk(walk, visitor, hasFrames);
    }

    @AlwaysInline(value="avoid virtual call to visitor")
    private static boolean doWalk(JavaStackWalk walk, StackFrameVisitor visitor, boolean hasFrames) {
        if (!visitor.prologue()) {
            return false;
        }
        if (hasFrames) {
            do {
                if (visitor.visitFrame(walk.getSP(), walk.getIP(), Deoptimizer.checkDeoptimized(walk.getSP()))) continue;
                return false;
            } while (JavaStackWalker.continueWalk(walk));
        }
        return visitor.epilogue();
    }
}

