/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.headers;

import com.oracle.svm.core.posix.headers.PosixDirectives;
import com.oracle.svm.core.posix.headers.Uio;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.struct.AllowNarrowingCast;
import org.graalvm.nativeimage.c.struct.AllowWideningCast;
import org.graalvm.nativeimage.c.struct.CField;
import org.graalvm.nativeimage.c.struct.CFieldAddress;
import org.graalvm.nativeimage.c.struct.CPointerTo;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;

@CContext(value=PosixDirectives.class)
public class Socket {
    @CConstant
    public static native int SOCK_STREAM();

    @CConstant
    public static native int SOCK_DGRAM();

    @CConstant
    public static native int SOCK_RAW();

    @CConstant
    public static native int SOCK_RDM();

    @CConstant
    public static native int SOCK_SEQPACKET();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int SOCK_PACKET();

    @CConstant
    public static native int PF_UNSPEC();

    @CConstant
    public static native int PF_LOCAL();

    @CConstant
    public static native int PF_UNIX();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int PF_FILE();

    @CConstant
    public static native int PF_INET();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int PF_AX25();

    @CConstant
    public static native int PF_IPX();

    @CConstant
    public static native int PF_APPLETALK();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int PF_NETROM();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int PF_BRIDGE();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int PF_ATMPVC();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int PF_X25();

    @CConstant
    public static native int PF_INET6();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int PF_ROSE();

    @CConstant
    public static native int PF_DECnet();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int PF_NETBEUI();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int PF_SECURITY();

    @CConstant
    public static native int PF_KEY();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int PF_NETLINK();

    @CConstant
    public static native int PF_ROUTE();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int PF_PACKET();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int PF_ASH();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int PF_ECONET();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int PF_ATMSVC();

    @CConstant
    public static native int PF_SNA();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int PF_IRDA();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int PF_PPPOX();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int PF_WANPIPE();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int PF_BLUETOOTH();

    @CConstant
    public static native int PF_MAX();

    @CConstant
    public static native int AF_UNSPEC();

    @CConstant
    @Platforms(value={Platform.DARWIN.class})
    public static native int AF_LINK();

    @CConstant
    public static native int AF_LOCAL();

    @CConstant
    public static native int AF_UNIX();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int AF_FILE();

    @CConstant
    public static native int AF_INET();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int AF_AX25();

    @CConstant
    public static native int AF_IPX();

    @CConstant
    public static native int AF_APPLETALK();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int AF_NETROM();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int AF_BRIDGE();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int AF_ATMPVC();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int AF_X25();

    @CConstant
    public static native int AF_INET6();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int AF_ROSE();

    @CConstant
    public static native int AF_DECnet();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int AF_NETBEUI();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int AF_SECURITY();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int AF_KEY();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int AF_NETLINK();

    @CConstant
    public static native int AF_ROUTE();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int AF_PACKET();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int AF_ASH();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int AF_ECONET();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int AF_ATMSVC();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int AF_SNA();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int AF_IRDA();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int AF_PPPOX();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int AF_WANPIPE();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int AF_BLUETOOTH();

    @CConstant
    public static native int AF_MAX();

    @CConstant
    public static native int MSG_OOB();

    @CConstant
    public static native int MSG_PEEK();

    @CConstant
    public static native int MSG_DONTROUTE();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int MSG_TRYHARD();

    @CConstant
    public static native int MSG_CTRUNC();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int MSG_PROXY();

    @CConstant
    public static native int MSG_TRUNC();

    @CConstant
    public static native int MSG_DONTWAIT();

    @CConstant
    public static native int MSG_EOR();

    @CConstant
    public static native int MSG_WAITALL();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int MSG_FIN();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int MSG_SYN();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int MSG_CONFIRM();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int MSG_RST();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int MSG_ERRQUEUE();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int MSG_NOSIGNAL();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int MSG_MORE();

    @CConstant
    public static native int SCM_RIGHTS();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int SCM_CREDENTIALS();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int FIOSETOWN();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int SIOCSPGRP();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int FIOGETOWN();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int SIOCGPGRP();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int SIOCATMARK();

    @CConstant
    public static native long SIOCGIFCONF();

    @CConstant
    public static native long SIOCGIFFLAGS();

    @CConstant
    public static native long SIOCGIFBRDADDR();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int SIOCGIFHWADDR();

    @CConstant
    public static native long SIOCGIFNETMASK();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int SIOCGIFINDEX();

    @CConstant
    public static native int SOL_SOCKET();

    @CConstant
    public static native int SO_REUSEADDR();

    @CConstant
    public static native int SO_TYPE();

    @CConstant
    public static native int SO_ERROR();

    @CConstant
    public static native int SO_DONTROUTE();

    @CConstant
    public static native int SO_BROADCAST();

    @CConstant
    public static native int SO_SNDBUF();

    @CConstant
    public static native int SO_RCVBUF();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int SO_SNDBUFFORCE();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int SO_RCVBUFFORCE();

    @CConstant
    public static native int SO_KEEPALIVE();

    @CConstant
    public static native int SO_OOBINLINE();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int SO_NO_CHECK();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int SO_PRIORITY();

    @CConstant
    public static native int SO_LINGER();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int SO_BSDCOMPAT();

    @CConstant
    public static native int SO_REUSEPORT();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int SO_PASSCRED();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int SO_PEERCRED();

    @CConstant
    public static native int SO_RCVLOWAT();

    @CConstant
    public static native int SO_SNDLOWAT();

    @CConstant
    public static native int SO_RCVTIMEO();

    @CConstant
    public static native int SO_SNDTIMEO();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int SO_SECURITY_AUTHENTICATION();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int SO_SECURITY_ENCRYPTION_TRANSPORT();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int SO_SECURITY_ENCRYPTION_NETWORK();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int SO_BINDTODEVICE();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int SO_ATTACH_FILTER();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int SO_DETACH_FILTER();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int SO_PEERNAME();

    @CConstant
    public static native int SO_TIMESTAMP();

    @CConstant
    public static native int SCM_TIMESTAMP();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int SO_PEERSEC();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int SO_PASSSEC();

    @CConstant
    public static native int SHUT_RD();

    @CConstant
    public static native int SHUT_WR();

    @CConstant
    public static native int SHUT_RDWR();

    @CFunction
    public static native int socket(int var0, int var1, int var2);

    @CFunction
    public static native int socketpair(int var0, int var1, int var2, CIntPointer var3);

    @CFunction
    public static native int bind(int var0, sockaddr var1, int var2);

    @CFunction
    public static native int getsockname(int var0, sockaddr var1, CIntPointer var2);

    @CFunction
    public static native int connect(int var0, sockaddr var1, int var2);

    @CFunction
    public static native int getpeername(int var0, sockaddr var1, CIntPointer var2);

    @CFunction
    public static native SignedWord send(int var0, PointerBase var1, UnsignedWord var2, int var3);

    @CFunction
    public static native SignedWord recv(int var0, PointerBase var1, UnsignedWord var2, int var3);

    @CFunction
    public static native SignedWord sendto(int var0, PointerBase var1, UnsignedWord var2, int var3, sockaddr var4, int var5);

    @CFunction
    public static native SignedWord recvfrom(int var0, PointerBase var1, UnsignedWord var2, int var3, sockaddr var4, CIntPointer var5);

    @CFunction
    public static native SignedWord sendmsg(int var0, msghdr var1, int var2);

    @CFunction
    public static native SignedWord recvmsg(int var0, msghdr var1, int var2);

    @CFunction
    public static native int getsockopt(int var0, int var1, int var2, PointerBase var3, CIntPointer var4);

    @CFunction
    public static native int setsockopt(int var0, int var1, int var2, PointerBase var3, int var4);

    @CFunction
    public static native int listen(int var0, int var1);

    @CFunction
    public static native int accept(int var0, sockaddr var1, CIntPointer var2);

    @CFunction
    public static native int accept4(int var0, sockaddr var1, CIntPointer var2, int var3);

    @CFunction
    public static native int shutdown(int var0, int var1);

    @CFunction
    public static native int sockatmark(int var0);

    @CFunction
    public static native int isfdtype(int var0, int var1);

    @CStruct(addStructKeyword=true)
    public static interface linger
    extends PointerBase {
        @CField
        public int l_onoff();

        @CField
        public void set_l_onoff(int var1);

        @CField
        public int l_linger();

        @CField
        public void set_l_linger(int var1);
    }

    @CStruct(addStructKeyword=true)
    @Platforms(value={Platform.LINUX.class})
    public static interface ucred
    extends PointerBase {
        @CField
        public int pid();

        @CField
        public int uid();

        @CField
        public int gid();
    }

    @CStruct(addStructKeyword=true)
    public static interface cmsghdr
    extends PointerBase {
        @CField
        @AllowWideningCast
        public long cmsg_len();

        @CField
        @AllowNarrowingCast
        public void cmsg_len(long var1);

        @CField
        public int cmsg_level();

        @CField
        public void cmsg_level(int var1);

        @CField
        public int cmsg_type();

        @CField
        public void cmsg_type(int var1);
    }

    @CStruct(addStructKeyword=true)
    public static interface msghdr
    extends PointerBase {
        @CField
        public PointerBase msg_name();

        @CField
        public void msg_name(PointerBase var1);

        @CField
        @AllowWideningCast
        public long msg_namelen();

        @CField
        @AllowNarrowingCast
        public void msg_namelen(long var1);

        @CField
        public Uio.iovec msg_iov();

        @CField
        public void msg_iov(Uio.iovec var1);

        @CField
        @AllowWideningCast
        public long msg_iovlen();

        @CField
        @AllowNarrowingCast
        public void msg_iovlen(long var1);

        @CField
        public PointerBase msg_control();

        @CField
        public void msg_control(PointerBase var1);

        @CField
        @AllowWideningCast
        public long msg_controllen();

        @CField
        @AllowNarrowingCast
        public void msg_controllen(long var1);

        @CField
        public int msg_flags();

        @CField
        public void msg_flags(int var1);
    }

    @CPointerTo(value=sockaddr.class)
    public static interface sockaddrPointer
    extends PointerBase {
        public sockaddr read();

        public void write(sockaddr var1);
    }

    @CStruct(addStructKeyword=true)
    public static interface sockaddr_storage
    extends PointerBase {
        @CField
        @AllowWideningCast
        public short ss_family();
    }

    @CStruct(addStructKeyword=true)
    public static interface sockaddr
    extends PointerBase {
        @Platforms(value={Platform.DARWIN.class})
        @CField
        @AllowWideningCast
        public int sa_len();

        @CField
        @AllowWideningCast
        public int sa_family();

        @CFieldAddress
        public CCharPointer sa_data();
    }
}

