/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.headers;

import com.oracle.svm.core.posix.headers.PosixDirectives;
import com.oracle.svm.core.posix.headers.Time;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.struct.CField;
import org.graalvm.nativeimage.c.struct.CFieldAddress;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.word.PointerBase;

@CContext(value=PosixDirectives.class)
public class Resource {
    @CConstant
    public static native int RLIMIT_CPU();

    @CConstant
    public static native int RLIMIT_FSIZE();

    @CConstant
    public static native int RLIMIT_DATA();

    @CConstant
    public static native int RLIMIT_STACK();

    @CConstant
    public static native int RLIMIT_CORE();

    @CConstant
    public static native int RLIMIT_RSS();

    @CConstant
    public static native int RLIMIT_NOFILE();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int RLIMIT_OFILE();

    @CConstant
    public static native int RLIMIT_AS();

    @CConstant
    public static native int RLIMIT_NPROC();

    @CConstant
    public static native int RLIMIT_MEMLOCK();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int RLIMIT_LOCKS();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int RLIMIT_SIGPENDING();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int RLIMIT_MSGQUEUE();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int RLIMIT_NICE();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int RLIMIT_RTPRIO();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int RLIMIT_NLIMITS();

    @CConstant
    public static native int RLIM_NLIMITS();

    @CConstant
    public static native long RLIM_INFINITY();

    @CConstant
    public static native long RLIM_SAVED_MAX();

    @CConstant
    public static native long RLIM_SAVED_CUR();

    @CConstant
    public static native int RUSAGE_SELF();

    @CConstant
    public static native int RUSAGE_CHILDREN();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int RUSAGE_THREAD();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int RUSAGE_LWP();

    @CConstant
    public static native int PRIO_MIN();

    @CConstant
    public static native int PRIO_MAX();

    @CConstant
    public static native int PRIO_PROCESS();

    @CConstant
    public static native int PRIO_PGRP();

    @CConstant
    public static native int PRIO_USER();

    @CFunction
    public static native int prlimit(int var0, int var1, rlimit var2, rlimit var3);

    @CFunction
    public static native int getrlimit(int var0, rlimit var1);

    @CFunction
    public static native int setrlimit(int var0, rlimit var1);

    @CFunction
    public static native int getrusage(int var0, rusage var1);

    @CFunction
    public static native int getpriority(int var0, int var1);

    @CFunction
    public static native int setpriority(int var0, int var1, int var2);

    @CStruct(value="struct rusage")
    public static interface rusage
    extends PointerBase {
        @CFieldAddress
        public Time.timeval ru_utime();

        @CFieldAddress
        public Time.timeval ru_stime();

        @CField
        public long ru_maxrss();

        @CField
        public long ru_ixrss();

        @CField
        public long ru_idrss();

        @CField
        public long ru_isrss();

        @CField
        public long ru_minflt();

        @CField
        public long ru_majflt();

        @CField
        public long ru_nswap();

        @CField
        public long ru_inblock();

        @CField
        public long ru_oublock();

        @CField
        public long ru_msgsnd();

        @CField
        public long ru_msgrcv();

        @CField
        public long ru_nsignals();

        @CField
        public long ru_nvcsw();

        @CField
        public long ru_nivcsw();
    }

    @CStruct(addStructKeyword=true)
    public static interface rlimit
    extends PointerBase {
        @CField
        public long rlim_cur();

        @CField
        public void set_rlim_cur(long var1);

        @CField
        public long rlim_max();

        @CField
        public void set_rlim_max(long var1);
    }
}

