/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.posix.Target_os;
import com.oracle.svm.core.posix.headers.Socket;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.PointerBase;

@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
public final class VmPrimsJVM {
    private VmPrimsJVM() {
    }

    public static int JVM_Socket(int domain, int type, int protocol) {
        return Socket.socket(domain, type, protocol);
    }

    static int JVM_Connect(int fd, Socket.sockaddr him, int len) {
        return Socket.connect(fd, him, len);
    }

    static int JVM_SocketShutdown(int fd, int howto) {
        return Socket.shutdown(fd, howto);
    }

    static int JVM_Accept(int fd, Socket.sockaddr him, CIntPointer len_Pointer) {
        CIntPointer socklen_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        socklen_Pointer.write(len_Pointer.read());
        int result = Target_os.accept(fd, him, socklen_Pointer);
        len_Pointer.write(socklen_Pointer.read());
        return result;
    }

    static int JVM_GetSockOpt(int fd, int level, int optname, CCharPointer optval, CIntPointer optlen) {
        CIntPointer socklen_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        socklen_Pointer.write(optlen.read());
        int result = Socket.getsockopt(fd, level, optname, (PointerBase)optval, optlen);
        optlen.write(socklen_Pointer.read());
        return result;
    }

    static int JVM_SetSockOpt(int fd, int level, int optname, CCharPointer optval, int optlen) {
        return Socket.setsockopt(fd, level, optname, (PointerBase)optval, optlen);
    }

    static int JVM_GetSockName(int fd, Socket.sockaddr him, CIntPointer len_Pointer) {
        CIntPointer socklen_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        socklen_Pointer.write(len_Pointer.read());
        int result = Target_os.get_sock_name(fd, him, socklen_Pointer);
        len_Pointer.write(socklen_Pointer.read());
        return result;
    }

    static int JVM_Read(int fd, CCharPointer buf, int nbytes) {
        return (int)Target_os.restartable_read(fd, buf, nbytes);
    }

    static int JVM_SocketAvailable(int fd, CIntPointer pbytes) {
        return Target_os.socket_available(fd, pbytes);
    }

    static int JVM_Send(int fd, CCharPointer buf, int nBytes, int flags) {
        return Target_os.send(fd, buf, nBytes, flags);
    }

    static int JVM_SendTo(int fd, CCharPointer buf, int n, int flags, Socket.sockaddr addr, int addr_len) {
        return Target_os.sendto(fd, buf, n, flags, addr, addr_len);
    }

    static int JVM_RecvFrom(int fd, CCharPointer buf, int n, int flags, Socket.sockaddr addr, CIntPointer addr_len) {
        return Target_os.recvfrom(fd, buf, n, flags, addr, addr_len);
    }

    static int JVM_SocketClose(int fd) {
        return Target_os.socket_close(fd);
    }

    static int JVM_GetHostName(CCharPointer name, int namelen) {
        return Target_os.get_host_name(name, namelen);
    }

    static int JVM_Listen(int fd, int count) {
        return Target_os.listen(fd, count);
    }
}

