/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.OS;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jni.JNIRuntimeAccess;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

@Platforms(value={InternalPlatform.LINUX_JNI.class, InternalPlatform.DARWIN_JNI.class})
@AutomaticFeature
@CLibrary(value="nio", requireStatic=true)
class PosixJavaNIOSubstituteFeature
implements Feature {
    PosixJavaNIOSubstituteFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("sun.nio.ch.FileKey"), "required for substitutions");
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("sun.nio.fs.UnixNativeDispatcher"), "required for substitutions");
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("sun.nio.ch.ServerSocketChannelImpl"), "required for substitutions");
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("sun.nio.ch.IOUtil"), "required for substitutions");
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("sun.nio.ch.FileChannelImpl"), "required for substitutions");
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.nio.file.FileSystems"), "required for substitutions");
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        try {
            if (OS.getCurrent() == OS.DARWIN || OS.getCurrent() == OS.LINUX) {
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixFileAttributes"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixFileAttributes").getDeclaredField("st_mode"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixFileAttributes").getDeclaredField("st_ino"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixFileAttributes").getDeclaredField("st_dev"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixFileAttributes").getDeclaredField("st_rdev"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixFileAttributes").getDeclaredField("st_nlink"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixFileAttributes").getDeclaredField("st_uid"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixFileAttributes").getDeclaredField("st_gid"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixFileAttributes").getDeclaredField("st_size"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixFileAttributes").getDeclaredField("st_atime_sec"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixFileAttributes").getDeclaredField("st_atime_nsec"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixFileAttributes").getDeclaredField("st_mtime_sec"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixFileAttributes").getDeclaredField("st_mtime_nsec"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixFileAttributes").getDeclaredField("st_ctime_sec"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixFileAttributes").getDeclaredField("st_ctime_nsec"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixFileAttributes").getDeclaredField("st_birthtime_sec"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixFileStoreAttributes"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixFileStoreAttributes").getDeclaredField("f_frsize"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixFileStoreAttributes").getDeclaredField("f_blocks"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixFileStoreAttributes").getDeclaredField("f_bfree"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixFileStoreAttributes").getDeclaredField("f_bavail"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixMountEntry"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixMountEntry").getDeclaredField("name"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixMountEntry").getDeclaredField("dir"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixMountEntry").getDeclaredField("fstype"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixMountEntry").getDeclaredField("opts"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixMountEntry").getDeclaredField("dev"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.ch.FileKey"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.ch.FileKey").getDeclaredField("st_dev"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.ch.FileKey").getDeclaredField("st_ino"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.ch.FileChannelImpl"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.ch.FileChannelImpl").getDeclaredField("fd"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.ch.DatagramChannelImpl"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.ch.DatagramChannelImpl").getDeclaredField("sender"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.ch.DatagramChannelImpl").getDeclaredField("cachedSenderInetAddress"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.ch.DatagramChannelImpl").getDeclaredField("cachedSenderPort"));
                JNIRuntimeAccess.register(access.findClassByName("java.lang.Exception"));
                JNIRuntimeAccess.register(access.findClassByName("java.lang.Exception").getDeclaredConstructor(new Class[0]));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixException"));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixException").getDeclaredConstructor(Integer.TYPE));
                JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.UnixException").getDeclaredConstructor(String.class));
            }
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            VMError.shouldNotReachHere("JNIRuntimeAccess.register failed: ", e);
        }
    }
}

