/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.FileTypeDetectorSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.nio.file.spi.FileTypeDetector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
final class FileTypeDetectorFeature
implements Feature {
    List<FileTypeDetector> installedDetectors;
    FileTypeDetector defaultFileTypeDetector;

    FileTypeDetectorFeature() {
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        this.installedDetectors = new ArrayList<FileTypeDetector>();
        if (FileTypeDetectorSupport.Options.AddAllFileTypeDetectors.getValue().booleanValue()) {
            Class jdkClass = access.findClassByName("java.nio.file.Files$FileTypeDetectors");
            String installedDetectorsFieldName = JavaVersionUtil.JAVA_SPEC <= 8 ? "installeDetectors" : "installedDetectors";
            this.installedDetectors.addAll((Collection)ReflectionUtil.readStaticField((Class)jdkClass, (String)installedDetectorsFieldName));
            this.defaultFileTypeDetector = (FileTypeDetector)ReflectionUtil.readStaticField((Class)jdkClass, (String)"defaultFileTypeDetector");
        }
        if (this.defaultFileTypeDetector == null) {
            this.defaultFileTypeDetector = new FileTypeDetectorSupport.AlwaysNullFileTypeDetector();
        }
    }
}

