/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.ThreadStackPrinter;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import sun.misc.Signal;
import sun.misc.SignalHandler;

class DumpAllStacks
implements SignalHandler {
    DumpAllStacks() {
    }

    static void install() {
        Signal.handle(new Signal("QUIT"), new DumpAllStacks());
    }

    @Override
    public void handle(Signal arg0) {
        VMOperation.enqueueBlockingSafepoint("DumpAllStacks", () -> {
            Log log = Log.log();
            IsolateThread vmThread = VMThreads.firstThread();
            while (VMThreads.isNonNullThread(vmThread)) {
                if (vmThread != CurrentIsolate.getCurrentThread()) {
                    try {
                        DumpAllStacks.dumpStack(log, vmThread);
                    }
                    catch (Exception e) {
                        log.string("Exception during dumpStack: ").string(e.getClass().getName()).newline();
                        log.string(e.getMessage()).newline();
                    }
                }
                vmThread = VMThreads.nextThread(vmThread);
            }
            log.flush();
        });
    }

    @NeverInline(value="catch implicit exceptions")
    private static void dumpStack(Log log, IsolateThread vmThread) {
        log.string("VMThread ").zhex(vmThread.rawValue()).spaces(2).string(VMThreads.StatusSupport.getStatusString(vmThread)).newline();
        log.indent(true);
        JavaStackWalker.walkThread(vmThread, ThreadStackPrinter.AllocationFreeStackFrameVisitor);
        log.indent(false);
    }
}

