/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.thread;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.meta.ReadableJavaField;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.threadlocal.FastThreadLocal;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfo;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.nativeimage.hosted.Feature;

class VMThreadLocalCollector
implements Function<Object, Object> {
    final Map<FastThreadLocal, VMThreadLocalInfo> threadLocals = new ConcurrentHashMap<FastThreadLocal, VMThreadLocalInfo>();
    private boolean sealed;

    VMThreadLocalCollector() {
    }

    @Override
    public Object apply(Object source) {
        if (source instanceof FastThreadLocal) {
            FastThreadLocal threadLocal = (FastThreadLocal)source;
            if (this.sealed) {
                assert (this.threadLocals.containsKey(threadLocal)) : "VMThreadLocal must have been discovered during static analysis";
            } else {
                this.threadLocals.putIfAbsent(threadLocal, new VMThreadLocalInfo(threadLocal));
            }
        }
        return source;
    }

    public VMThreadLocalInfo getInfo(FastThreadLocal threadLocal) {
        VMThreadLocalInfo result = this.threadLocals.get(threadLocal);
        assert (result != null);
        return result;
    }

    public VMThreadLocalInfo findInfo(GraphBuilderContext b, ValueNode threadLocalNode) {
        if (!threadLocalNode.isConstant()) {
            throw VMError.shouldNotReachHere("Accessed VMThreadLocal is not a compile time constant: " + b.getMethod().asStackTraceElement(b.bci()));
        }
        FastThreadLocal threadLocal = (FastThreadLocal)SubstrateObjectConstant.asObject(threadLocalNode.asConstant());
        VMThreadLocalInfo result = this.threadLocals.get(threadLocal);
        assert (result != null);
        return result;
    }

    public List<VMThreadLocalInfo> sortThreadLocals(Feature.CompilationAccess config) {
        return this.sortThreadLocals(config, null);
    }

    public List<VMThreadLocalInfo> sortThreadLocals(Feature.CompilationAccess a, FastThreadLocal first) {
        FeatureImpl.CompilationAccessImpl config = (FeatureImpl.CompilationAccessImpl)a;
        this.sealed = true;
        for (ResolvedJavaField resolvedJavaField : config.getFields()) {
            Object fieldValue;
            SharedField field = (SharedField)resolvedJavaField;
            if (!field.isStatic() || field.getStorageKind() != JavaKind.Object || !((fieldValue = SubstrateObjectConstant.asObject((Constant)((ReadableJavaField)((Object)field)).readValue(null))) instanceof FastThreadLocal)) continue;
            FastThreadLocal threadLocal = (FastThreadLocal)fieldValue;
            VMThreadLocalInfo info = this.threadLocals.get(threadLocal);
            String fieldName = field.format("%H.%n");
            if (!field.isFinal()) {
                throw VMError.shouldNotReachHere("VMThreadLocal referenced from non-final field: " + fieldName);
            }
            if (info.name != null) {
                throw VMError.shouldNotReachHere("VMThreadLocal referenced from two static final fields: " + info.name + ", " + fieldName);
            }
            info.name = fieldName;
        }
        for (VMThreadLocalInfo vMThreadLocalInfo : this.threadLocals.values()) {
            if (vMThreadLocalInfo.name == null) {
                VMError.shouldNotReachHere("VMThreadLocal found that is not referenced from a static final field");
            }
            assert (vMThreadLocalInfo.sizeInBytes == -1);
            if (vMThreadLocalInfo.sizeSupplier != null) {
                vMThreadLocalInfo.sizeInBytes = NumUtil.roundUp((int)vMThreadLocalInfo.sizeSupplier.getAsInt(), (int)8);
                continue;
            }
            vMThreadLocalInfo.sizeInBytes = ConfigurationValues.getObjectLayout().sizeInBytes(vMThreadLocalInfo.storageKind);
        }
        ArrayList<VMThreadLocalInfo> sortedThreadLocals = new ArrayList<VMThreadLocalInfo>(this.threadLocals.values());
        sortedThreadLocals.sort(VMThreadLocalCollector::compareThreadLocal);
        if (first != null) {
            VMThreadLocalInfo vMThreadLocalInfo = this.threadLocals.get(first);
            assert (vMThreadLocalInfo != null && sortedThreadLocals.contains(vMThreadLocalInfo));
            sortedThreadLocals.remove(vMThreadLocalInfo);
            sortedThreadLocals.add(0, vMThreadLocalInfo);
        }
        return sortedThreadLocals;
    }

    private static int compareThreadLocal(VMThreadLocalInfo info1, VMThreadLocalInfo info2) {
        if (info1 == info2) {
            return 0;
        }
        int result = -Integer.compare(info1.sizeInBytes, info2.sizeInBytes);
        if (result == 0 && (result = -Boolean.compare(info1.isObject, info2.isObject)) == 0) {
            result = info1.name.compareTo(info2.name);
        }
        assert (result != 0) : "not distinguishable: " + info1 + ", " + info2;
        return result;
    }
}

