/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.lambda;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.GraalAccess;
import com.oracle.svm.hosted.lambda.LambdaSubstitutionType;
import com.oracle.svm.hosted.phases.NoClassInitializationPlugin;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.ClassInitializationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;

public class LambdaProxyRenamingSubstitutionProcessor
extends SubstitutionProcessor {
    private static final Pattern LAMBDA_PATTERN = Pattern.compile("\\$\\$Lambda\\$\\d+/\\d+");
    private static final GraphBuilderPhase LAMBDA_PARSER_PHASE = new GraphBuilderPhase(LambdaProxyRenamingSubstitutionProcessor.buildLambdaParserConfig());
    private final BigBang bb;
    private final ConcurrentHashMap<ResolvedJavaType, LambdaSubstitutionType> typeSubstitutions = new ConcurrentHashMap();
    private final Set<String> uniqueLambdaProxyNames = new HashSet<String>();

    private static GraphBuilderConfiguration buildLambdaParserConfig() {
        GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(new InvocationPlugins());
        plugins.setClassInitializationPlugin((ClassInitializationPlugin)new NoClassInitializationPlugin());
        return GraphBuilderConfiguration.getDefault((GraphBuilderConfiguration.Plugins)plugins).withEagerResolving(true);
    }

    static boolean isLambdaType(ResolvedJavaType type) {
        return type.isFinalFlagSet() && type.getName().contains("/") && LambdaProxyRenamingSubstitutionProcessor.lambdaMatcher(type.getName()).find();
    }

    LambdaProxyRenamingSubstitutionProcessor(BigBang bigBang) {
        this.bb = bigBang;
    }

    public ResolvedJavaType lookup(ResolvedJavaType type) {
        if (LambdaProxyRenamingSubstitutionProcessor.isLambdaType(type)) {
            return this.getSubstitution(type);
        }
        return type;
    }

    public ResolvedJavaType resolve(ResolvedJavaType type) {
        if (type instanceof LambdaSubstitutionType) {
            return ((LambdaSubstitutionType)type).getOriginal();
        }
        return type;
    }

    private static String createStableLambdaName(ResolvedJavaType lambdaType, ResolvedJavaMethod targetMethod) {
        assert (LambdaProxyRenamingSubstitutionProcessor.lambdaMatcher(lambdaType.getName()).find()) : "Stable name should be created only for lambda types.";
        Matcher m = LambdaProxyRenamingSubstitutionProcessor.lambdaMatcher(lambdaType.getName());
        String stableTargetMethod = SubstrateUtil.digest(targetMethod.format("%H.%n(%P)%R"));
        return m.replaceFirst("\\$\\$Lambda\\$" + stableTargetMethod);
    }

    private LambdaSubstitutionType getSubstitution(ResolvedJavaType original) {
        return this.typeSubstitutions.computeIfAbsent(original, key -> {
            OptionValues options = this.bb.getOptions();
            DebugContext debug = DebugContext.create((OptionValues)options, (DebugHandlersFactory)new GraalDebugHandlersFactory(this.bb.getProviders().getSnippetReflection()));
            ResolvedJavaMethod[] lambdaProxyMethods = (ResolvedJavaMethod[])Arrays.stream(key.getDeclaredMethods()).filter(m -> !m.isBridge() && m.isPublic()).toArray(ResolvedJavaMethod[]::new);
            assert (lambdaProxyMethods.length == 1) : "There must be only one method calling the target.";
            StructuredGraph graph = new StructuredGraph.Builder(options, debug).method(lambdaProxyMethods[0]).build();
            try (DebugContext.Scope ignored = debug.scope((Object)"Lambda target method analysis", (Object)graph, key, (Object)this);){
                HighTierContext context = new HighTierContext(GraalAccess.getOriginalProviders(), null, OptimisticOptimizations.NONE);
                LAMBDA_PARSER_PHASE.apply(graph, (Object)context);
            }
            catch (Throwable e) {
                throw debug.handle(e);
            }
            Optional lambdaTargetInvokeOption = StreamSupport.stream(graph.getInvokes().spliterator(), false).findFirst();
            if (!lambdaTargetInvokeOption.isPresent()) {
                throw VMError.shouldNotReachHere("Lambda without a target invoke.");
            }
            String lambdaTargetName = LambdaProxyRenamingSubstitutionProcessor.createStableLambdaName(key, ((Invoke)lambdaTargetInvokeOption.get()).getTargetMethod());
            return new LambdaSubstitutionType((ResolvedJavaType)key, this.findUniqueLambdaProxyName(lambdaTargetName));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findUniqueLambdaProxyName(String lambdaTargetName) {
        Set<String> set = this.uniqueLambdaProxyNames;
        synchronized (set) {
            String newStableName = lambdaTargetName;
            CharSequence stableNameBase = lambdaTargetName.subSequence(0, lambdaTargetName.length() - 1);
            int i = 1;
            while (this.uniqueLambdaProxyNames.contains(newStableName)) {
                newStableName = stableNameBase + "_" + i + ";";
                ++i;
            }
            this.uniqueLambdaProxyNames.add(newStableName);
            return newStableName;
        }
    }

    private static Matcher lambdaMatcher(String value) {
        return LAMBDA_PATTERN.matcher(value);
    }
}

