/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code.aarch64;

import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.hosted.code.HostedPatcher;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import jdk.vm.ci.code.site.Reference;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.code.CompilationResult;

public class AArch64HostedPatcher
extends CompilationResult.CodeAnnotation
implements HostedPatcher {
    private final AArch64Assembler.OperandDataAnnotation annotation;

    public AArch64HostedPatcher(int instructionStartPosition, AArch64Assembler.OperandDataAnnotation annotation) {
        super(instructionStartPosition);
        this.annotation = annotation;
    }

    @Override
    @Uninterruptible(reason=".")
    public void patch(int codePos, int relative, byte[] code) {
        int curValue = relative;
        curValue >>= this.annotation.shift;
        int bitsRemaining = this.annotation.operandSizeBits;
        int offsetRemaining = this.annotation.offsetBits;
        for (int i = 0; i < 4; ++i) {
            if (offsetRemaining >= 8) {
                offsetRemaining -= 8;
                continue;
            }
            int mask = 0;
            for (int j = 0; j < 8; ++j) {
                if (j >= offsetRemaining) {
                    mask |= 1 << j;
                    --bitsRemaining;
                }
                if (bitsRemaining == 0) break;
            }
            byte patchTarget = code[this.annotation.instructionPosition + i];
            byte patch = (byte)(((byte)(curValue & 0xFF) & mask) << offsetRemaining);
            byte retainedPatchTarget = (byte)(patchTarget & ~mask << offsetRemaining);
            code[this.annotation.instructionPosition + i] = patchTarget = (byte)(retainedPatchTarget | patch);
            curValue >>>= 8 - offsetRemaining;
            offsetRemaining = 0;
        }
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public void relocate(Reference ref, RelocatableBuffer relocs, int compStart) {
        int siteOffset = compStart + this.annotation.instructionPosition;
        relocs.addRelocation(siteOffset, ObjectFile.RelocationKind.AARCH64_R_AARCH64_ADR_PREL_PG_HI21, 0, 0L, ref);
        relocs.addRelocation(siteOffset += 4, ObjectFile.RelocationKind.AARCH64_R_AARCH64_ADD_ABS_LO12_NC, 0, 0L, ref);
    }
}

