/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class VMOperationControl {
    private static final FastThreadLocalInt isLockOwner = FastThreadLocalFactory.createInt();
    private final Worklist nonBlockingNonSafepointOperations = new Worklist(this.getLock(), "nonBlockingNonSafepoint");
    private final Worklist nonBlockingSafepointOperations = new Worklist(this.getLock(), "nonBlockingSafepoint");
    private final Worklist blockingNonSafepointOperations = new Worklist(this.getLock(), "blockingNonSafepoint");
    private final Worklist blockingSafepointOperations = new Worklist(this.getLock(), "blockingSafepoint");
    private String reason = "TooSoonToTell";
    private VMOperation inProgress = null;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    VMOperationControl() {
    }

    static VMOperationControl getVMOperationControl() {
        return (VMOperationControl)ImageSingletons.lookup(VMOperationControl.class);
    }

    public static void logRecentEvents(Log log) {
        VMOperation cur = VMOperationControl.getVMOperationControl().inProgress;
        if (cur == null) {
            log.string("No VMOperation in progress").newline();
        } else {
            log.string("VMOperation in progress: ").string(cur.getName()).newline();
            log.string("  blocksCaller: ").bool(cur.getBlocksCaller()).newline();
            log.string("  causesSafepoint: ").bool(cur.getCausesSafepoint()).newline();
            log.string("  queuingThread: ").zhex(cur.getQueuingVMThread().rawValue()).newline();
            log.string("  executingThread: ").zhex(cur.getExecutingVMThread().rawValue()).newline();
        }
    }

    VMOperation getInProgress() {
        return this.inProgress;
    }

    void setInProgress(VMOperation value) {
        this.inProgress = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enqueue(VMOperation operation) {
        boolean needLockUnlock;
        Log trace = SubstrateOptions.TraceVMOperations.getValue() != false ? Log.log() : Log.noopLog();
        trace.string("[VMOperationControl.enqueue:").string("  operation: ").string(operation.getName());
        boolean needsCallback = ThreadingSupportImpl.singleton().needsCallbackOnSafepointCheckSlowpath();
        long callbackTime = 0L;
        int callbackValue = 0;
        boolean bl = needLockUnlock = !VMOperationControl.isLockOwner();
        if (needLockUnlock) {
            if (needsCallback) {
                callbackTime = System.nanoTime();
                callbackValue = Safepoint.getSafepointRequested(CurrentIsolate.getCurrentThread());
                Safepoint.setSafepointRequested(CurrentIsolate.getCurrentThread(), -1);
            }
            VMOperationControl.getVMOperationControl().acquireLock();
        }
        try {
            VMOperationControl.getVMOperationControl().setReason(operation.getName());
            if (!operation.getBlocksCaller() && !operation.getCausesSafepoint()) {
                VMOperationControl.getVMOperationControl().nonBlockingNonSafepointOperations.push(operation);
            } else if (!operation.getBlocksCaller() && operation.getCausesSafepoint()) {
                VMOperationControl.getVMOperationControl().nonBlockingSafepointOperations.push(operation);
            } else if (operation.getBlocksCaller() && !operation.getCausesSafepoint()) {
                VMOperationControl.getVMOperationControl().blockingNonSafepointOperations.push(operation);
            } else if (operation.getBlocksCaller() && operation.getCausesSafepoint()) {
                VMOperationControl.getVMOperationControl().blockingSafepointOperations.push(operation);
            }
            VMOperationControl.getVMOperationControl().drain();
        }
        finally {
            if (needLockUnlock) {
                VMOperationControl.getVMOperationControl().releaseLock();
                if (needsCallback) {
                    ThreadingSupportImpl.singleton().onSafepointCheckSlowpath(callbackTime, callbackValue);
                }
            }
        }
        trace.string("]").newline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drain() {
        Log trace = SubstrateOptions.TraceVMOperations.getValue() != false ? Log.log() : Log.noopLog();
        Safepoint.Master master = Safepoint.Master.singleton();
        trace.string("[VMOperationControl.drain:").string("  MASTER.isFrozen: ").bool(master.isFrozen()).newline();
        String drainReason = this.getReason();
        this.nonBlockingNonSafepointOperations.drain();
        this.blockingNonSafepointOperations.drain();
        boolean nonEmptySafepointQueues = !this.nonBlockingSafepointOperations.isEmpty() || !this.blockingSafepointOperations.isEmpty();
        boolean startedSafepoint = false;
        if (!master.isFrozen() && nonEmptySafepointQueues) {
            startedSafepoint = true;
            master.freeze(drainReason);
        }
        try {
            this.nonBlockingSafepointOperations.drain();
            this.blockingSafepointOperations.drain();
        }
        finally {
            if (startedSafepoint) {
                master.thaw(drainReason);
            }
        }
        trace.string("]").newline();
    }

    private VMMutex getLock() {
        return Safepoint.getMutex();
    }

    private void acquireLock() {
        Log trace = SubstrateOptions.TraceVMOperations.getValue() != false ? Log.log() : Log.noopLog();
        trace.string("[VMOperationControl.acquireLock:").newline();
        this.getLock().lock();
        VMOperationControl.setLockOwner();
        trace.string("]").newline();
    }

    private void releaseLock() {
        Log trace = SubstrateOptions.TraceVMOperations.getValue() != false ? Log.log() : Log.noopLog();
        trace.string("[VMOperationControl.releaseLock: ").newline();
        VMMutex lock = this.getLock();
        lock.assertIsLocked("VMOperationControl.releaseLock but not locked.");
        VMOperationControl.unsetLockOwner();
        lock.unlock();
        trace.string("  isOwner: ").bool(VMOperationControl.isLockOwner()).string("]").newline();
    }

    private String getReason() {
        return this.reason;
    }

    private void setReason(String value) {
        this.reason = value;
    }

    @Uninterruptible(reason="Called from Uninterruptible code", mayBeInlined=true)
    protected static boolean isLockOwner() {
        return isLockOwner.get() == 1;
    }

    private static void setLockOwner() {
        assert (!VMOperationControl.isLockOwner()) : "VMOperationControl.setOwner, but already owner.";
        isLockOwner.set(1);
    }

    private static void unsetLockOwner() {
        assert (VMOperationControl.isLockOwner()) : "VMOperationControl.unsetOwner, but not owner.";
        isLockOwner.set(0);
    }

    public static void guaranteeOkayToBlock(String message) {
        if (VMOperationControl.isFrozen()) {
            Log.log().string(message).newline();
            VMError.shouldNotReachHere("Should not reach here: Not okay to block.");
        }
    }

    public static boolean isFrozen() {
        return Safepoint.Master.singleton().isFrozen();
    }

    protected static final class SynchronizedAllocationFreeStack<T extends AllocationFreeStack.Element<T>>
    extends AllocationFreeStack<T> {
        private final VMMutex lock;

        public SynchronizedAllocationFreeStack(VMMutex lock) {
            this.lock = lock;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty();
        }

        @Override
        public void push(T element) {
            this.lock.assertIsLocked("Should hold lock across synchronous push.");
            super.push(element);
        }

        @Override
        public T pop() {
            this.lock.assertIsLocked("Should hold lock across synchronous pop.");
            return super.pop();
        }
    }

    protected static class AllocationFreeStack<T extends Element<T>> {
        private Element<T> head = null;

        protected AllocationFreeStack() {
        }

        public static <U extends Element<U>> AllocationFreeStack<U> factory() {
            return new AllocationFreeStack();
        }

        public boolean isEmpty() {
            return this.head == null;
        }

        public void push(T element) {
            T asElement = element;
            VMError.guarantee(!((Element)asElement).enqueued, "Pushing element, but already enqueued.");
            ((Element)asElement).enqueued = true;
            ((Element)asElement).setNext((Element)this.head);
            this.head = asElement;
        }

        public T pop() {
            if (this.head == null) {
                return null;
            }
            Element<T> resultElement = this.head;
            this.head = ((Element)resultElement).getNext();
            ((Element)resultElement).setNext(null);
            ((Element)resultElement).enqueued = false;
            return (T)Element.asT((Element)resultElement);
        }

        public static class Element<T extends Element<T>> {
            private Element<T> next;
            private boolean enqueued;

            protected Element() {
            }

            private Element<T> getNext() {
                return this.next;
            }

            private void setNext(Element<T> newNext) {
                assert (this.next == null || newNext == null) : "Should not change next abruptly.";
                this.next = newNext;
            }

            private static <T extends Element<T>> T asT(Element<T> element) {
                return (T)element;
            }
        }
    }

    protected static final class Worklist {
        private final SynchronizedAllocationFreeStack<VMOperation> stack;
        private final String name;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        protected Worklist(VMMutex lock, String name) {
            this.stack = new SynchronizedAllocationFreeStack(lock);
            this.name = name;
        }

        protected boolean isEmpty() {
            return this.stack.isEmpty();
        }

        protected void push(VMOperation element) {
            this.stack.push(element);
        }

        private VMOperation pop() {
            return this.stack.pop();
        }

        protected void drain() {
            if (!this.isEmpty()) {
                Log trace = SubstrateOptions.TraceVMOperations.getValue() != false ? Log.log() : Log.noopLog();
                trace.string("[Worklist.drain:  queue: ").string(this.name);
                VMOperation operation = this.pop();
                while (operation != null) {
                    operation.execute();
                    operation = this.pop();
                }
                trace.string("]").newline();
            }
        }
    }

    public static class TestingBackdoor {
        public static boolean isLocked() {
            return VMMutex.TestingBackdoor.isLocked(VMOperationControl.getVMOperationControl().getLock());
        }
    }
}

