/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.headers.Errno;
import com.oracle.svm.core.posix.JavaNetNetworkInterface;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Ifaddrs;
import com.oracle.svm.core.posix.headers.Ioctl;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.NetEthernet;
import com.oracle.svm.core.posix.headers.NetIf;
import com.oracle.svm.core.posix.headers.NetIfDl;
import com.oracle.svm.core.posix.headers.NetinetIn;
import com.oracle.svm.core.posix.headers.Socket;
import com.oracle.svm.core.posix.headers.darwin.DarwinNetinet6In6_var;
import java.net.SocketException;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.DARWIN.class})
public class DarwinJavaNetNetworkInterface {

    static class PlatformSupportImpl
    implements JavaNetNetworkInterface.PlatformSupport {
        PlatformSupportImpl() {
        }

        @Override
        public JavaNetNetworkInterface.netif enumIPv4Interfaces(int sock, JavaNetNetworkInterface.netif ifsParameter) throws SocketException {
            JavaNetNetworkInterface.netif ifs = ifsParameter;
            Ifaddrs.ifaddrsPointer origifa_Pointer = (Ifaddrs.ifaddrsPointer)StackValue.get(Ifaddrs.ifaddrsPointer.class);
            if (Ifaddrs.getifaddrs(origifa_Pointer) != 0) {
                throw new SocketException(PosixUtils.lastErrorString("getifaddrs() function failed"));
            }
            Ifaddrs.ifaddrs ifa = origifa_Pointer.read();
            while (ifa.isNonNull()) {
                if (!ifa.ifa_addr().isNull() && ifa.ifa_addr().sa_family() == Socket.AF_INET()) {
                    try {
                        ifs = JavaNetNetworkInterface.addif(sock, ifa.ifa_name(), ifs, ifa.ifa_addr(), Socket.AF_INET(), (short)0);
                    }
                    catch (Exception e) {
                        Ifaddrs.freeifaddrs(origifa_Pointer.read());
                        JavaNetNetworkInterface.freeif(ifs);
                        return null;
                    }
                }
                ifa = ifa.ifa_next();
            }
            Ifaddrs.freeifaddrs(origifa_Pointer.read());
            return ifs;
        }

        @Override
        public JavaNetNetworkInterface.netif enumIPv6Interfaces(int sock, JavaNetNetworkInterface.netif ifsParameter) throws SocketException {
            JavaNetNetworkInterface.netif ifs = ifsParameter;
            Ifaddrs.ifaddrsPointer origifa_Pointer = (Ifaddrs.ifaddrsPointer)StackValue.get(Ifaddrs.ifaddrsPointer.class);
            DarwinNetinet6In6_var.in6_ifreq ifr6 = (DarwinNetinet6In6_var.in6_ifreq)StackValue.get(DarwinNetinet6In6_var.in6_ifreq.class);
            if (Ifaddrs.getifaddrs(origifa_Pointer) != 0) {
                throw new SocketException(PosixUtils.lastErrorString("getifaddrs() function failed"));
            }
            Ifaddrs.ifaddrs ifa = origifa_Pointer.read();
            while (ifa.isNonNull()) {
                if (!ifa.ifa_addr().isNull() && ifa.ifa_addr().sa_family() == Socket.AF_INET6()) {
                    LibC.memset(ifr6, WordFactory.signed((int)0), WordFactory.unsigned((int)SizeOf.get(DarwinNetinet6In6_var.in6_ifreq.class)));
                    LibC.strlcpy(ifr6.ifr_name(), ifa.ifa_name(), WordFactory.unsigned((int)NetIf.IF_NAMESIZE()));
                    int minLength = Math.min(SizeOf.get(NetinetIn.sockaddr_in6.class), ifa.ifa_addr().sa_len());
                    LibC.memcpy(ifr6.ifru_addr(), ifa.ifa_addr(), WordFactory.unsigned((int)minLength));
                    if (Ioctl.ioctl(sock, DarwinNetinet6In6_var.SIOCGIFNETMASK_IN6(), ifr6) < 0) {
                        int savedErrno = Errno.errno();
                        Ifaddrs.freeifaddrs(origifa_Pointer.read());
                        JavaNetNetworkInterface.freeif(ifs);
                        throw new SocketException(PosixUtils.errorString(savedErrno, "ioctl SIOCGIFNETMASK_IN6 failed"));
                    }
                    NetinetIn.sockaddr_in6 sin6 = ifr6.ifru_addr();
                    try {
                        short prefix = (short)PlatformSupportImpl.prefix(sin6.sin6_addr(), SizeOf.get(NetinetIn.in6_addr.class));
                        ifs = JavaNetNetworkInterface.addif(sock, ifa.ifa_name(), ifs, ifa.ifa_addr(), Socket.AF_INET6(), prefix);
                    }
                    catch (Exception e) {
                        Ifaddrs.freeifaddrs(origifa_Pointer.read());
                        JavaNetNetworkInterface.freeif(ifs);
                        return null;
                    }
                }
                ifa = ifa.ifa_next();
            }
            Ifaddrs.freeifaddrs(origifa_Pointer.read());
            return ifs;
        }

        public static int prefix(PointerBase val, int size) {
            CCharPointer name = (CCharPointer)val;
            int plen = 0;
            int bite = 0;
            while (bite < size && name.read(bite) == 255) {
                ++bite;
                plen += 8;
            }
            if (bite == size) {
                return plen;
            }
            int bit = 7;
            while (bit != 0) {
                --bit;
                ++plen;
            }
            while (bit != 0) {
                if (CTypeConversion.toBoolean((int)(name.read(bite) & 1 << bit))) {
                    return 0;
                }
                --bit;
            }
            ++bite;
            while (bite < size) {
                if (CTypeConversion.toBoolean((int)name.read(bite))) {
                    return 0;
                }
                ++bite;
            }
            return plen;
        }

        @Override
        public Socket.sockaddr getBroadcast(int sock, CCharPointer ifname, Socket.sockaddr brdcast_store) throws SocketException {
            Socket.sockaddr ret = (Socket.sockaddr)WordFactory.nullPointer();
            NetIf.ifreq if2 = (NetIf.ifreq)StackValue.get(NetIf.ifreq.class);
            LibC.memset(if2, WordFactory.signed((int)0), WordFactory.unsigned((int)SizeOf.get(NetIf.ifreq.class)));
            LibC.strcpy(if2.ifr_name(), ifname);
            if (Ioctl.ioctl(sock, Socket.SIOCGIFFLAGS(), if2) < 0) {
                throw new SocketException(PosixUtils.lastErrorString("IOCTL SIOCGIFFLAGS failed"));
            }
            if (CTypeConversion.toBoolean((int)(if2.ifr_flags() & NetIf.IFF_BROADCAST()))) {
                if (Ioctl.ioctl(sock, Socket.SIOCGIFBRDADDR(), if2) < 0) {
                    throw new SocketException(PosixUtils.lastErrorString("IOCTL SIOCGIFBRDADDR failed"));
                }
                ret = brdcast_store;
                LibC.memcpy(ret, if2.ifr_broadaddr(), WordFactory.unsigned((int)SizeOf.get(Socket.sockaddr.class)));
            }
            return ret;
        }

        @Override
        public short getSubnet(int sock, CCharPointer ifname) throws SocketException {
            NetIf.ifreq if2 = (NetIf.ifreq)StackValue.get(NetIf.ifreq.class);
            LibC.memset(if2, WordFactory.signed((int)0), WordFactory.unsigned((int)SizeOf.get(NetIf.ifreq.class)));
            LibC.strcpy(if2.ifr_name(), ifname);
            if (Ioctl.ioctl(sock, Socket.SIOCGIFNETMASK(), if2) < 0) {
                throw new SocketException(PosixUtils.lastErrorString("IOCTL SIOCGIFNETMASK failed"));
            }
            int mask = NetinetIn.ntohl(((NetinetIn.sockaddr_in)((Object)if2.ifr_addr())).sin_addr().s_addr());
            short ret = 0;
            while (CTypeConversion.toBoolean((int)mask)) {
                mask <<= 1;
                ret = (short)(ret + 1);
            }
            return ret;
        }

        @Override
        public int getFlags(int sock, CCharPointer ifname, CIntPointer flags) {
            NetIf.ifreq if2 = (NetIf.ifreq)StackValue.get(NetIf.ifreq.class);
            LibC.memset(if2, WordFactory.signed((int)0), WordFactory.unsigned((int)SizeOf.get(NetIf.ifreq.class)));
            LibC.strcpy(if2.ifr_name(), ifname);
            if (Ioctl.ioctl(sock, Socket.SIOCGIFFLAGS(), if2) < 0) {
                return -1;
            }
            flags.write(if2.ifr_flags() & 0xFFFF);
            return 0;
        }

        @Override
        public int getIndex(int sock, CCharPointer name) {
            int index = NetIf.if_nametoindex(name);
            return index == 0 ? -1 : index;
        }

        @Override
        public int getMacAddress(CCharPointer ifname, NetinetIn.in_addr addr, CCharPointer buf) throws SocketException {
            Ifaddrs.ifaddrsPointer ifa0 = (Ifaddrs.ifaddrsPointer)StackValue.get(Ifaddrs.ifaddrsPointer.class);
            if (Ifaddrs.getifaddrs(ifa0) == 0) {
                Ifaddrs.ifaddrs ifa = ifa0.read();
                while (ifa.isNonNull()) {
                    NetIfDl.sockaddr_dl sadl;
                    Socket.sockaddr saddr = ifa.ifa_addr();
                    if (saddr.sa_family() == Socket.AF_LINK() && LibC.strcmp((PointerBase)ifname, (PointerBase)ifa.ifa_name()) == 0 && (sadl = (NetIfDl.sockaddr_dl)((Object)saddr)).sdl_alen() == NetEthernet.ETHER_ADDR_LEN()) {
                        LibC.memcpy(buf, (PointerBase)sadl.sdl_data().addressOf(sadl.sdl_nlen()), WordFactory.unsigned((int)NetEthernet.ETHER_ADDR_LEN()));
                        Ifaddrs.freeifaddrs(ifa0.read());
                        return NetEthernet.ETHER_ADDR_LEN();
                    }
                    ifa = ifa.ifa_next();
                }
                Ifaddrs.freeifaddrs(ifa0.read());
            }
            return -1;
        }
    }

    @AutomaticFeature
    static class JavaNetNetworkInterfaceFeature
    implements Feature {
        JavaNetNetworkInterfaceFeature() {
        }

        public void afterRegistration(Feature.AfterRegistrationAccess access) {
            ImageSingletons.add(JavaNetNetworkInterface.PlatformSupport.class, (Object)new PlatformSupportImpl());
        }
    }
}

