/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.FileTypeDetectorSupport;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Field;
import java.nio.file.spi.FileTypeDetector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
final class FileTypeDetectorFeature
implements Feature {
    List<FileTypeDetector> installedDetectors;
    FileTypeDetector defaultFileTypeDetector;

    FileTypeDetectorFeature() {
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        this.installedDetectors = new ArrayList<FileTypeDetector>();
        if (FileTypeDetectorSupport.Options.AddAllFileTypeDetectors.getValue().booleanValue()) {
            Class jdkClass = access.findClassByName("java.nio.file.Files$FileTypeDetectors");
            String installedDetectorsFieldName = JavaVersionUtil.Java8OrEarlier ? "installeDetectors" : "installedDetectors";
            this.installedDetectors.addAll((Collection)FileTypeDetectorFeature.readStaticField(jdkClass, installedDetectorsFieldName));
            this.defaultFileTypeDetector = (FileTypeDetector)FileTypeDetectorFeature.readStaticField(jdkClass, "defaultFileTypeDetector");
        }
        if (this.defaultFileTypeDetector == null) {
            this.defaultFileTypeDetector = new FileTypeDetectorSupport.AlwaysNullFileTypeDetector();
        }
    }

    private static <T> T readStaticField(Class<?> clazz, String fieldName) {
        try {
            Field result = clazz.getDeclaredField(fieldName);
            result.setAccessible(true);
            return (T)result.get(null);
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }
}

