/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.code.aarch64;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.graal.code.SubstrateCallingConvention;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterArray;
import jdk.vm.ci.code.RegisterAttributes;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;

public class SubstrateAArch64RegisterConfig
implements SubstrateRegisterConfig {
    private final TargetDescription target;
    private final int nativeParamsStackOffset;
    private final RegisterArray generalParameterRegs;
    private final RegisterArray xmmParameterRegs;
    private final RegisterArray allocatableRegs;
    private final RegisterArray calleeSaveRegisters;
    private final RegisterAttributes[] attributesMap;
    private final MetaAccessProvider metaAccess;
    private final Register threadRegister;
    private final Register heapBaseRegister;

    public SubstrateAArch64RegisterConfig(SubstrateRegisterConfig.ConfigKind config, MetaAccessProvider metaAccess, TargetDescription target) {
        this.target = target;
        this.metaAccess = metaAccess;
        this.generalParameterRegs = new RegisterArray(new Register[]{AArch64.r0, AArch64.r1, AArch64.r2, AArch64.r3, AArch64.r4, AArch64.r5, AArch64.r6, AArch64.r7});
        this.xmmParameterRegs = new RegisterArray(new Register[]{AArch64.v0, AArch64.v1, AArch64.v2, AArch64.v3, AArch64.v4, AArch64.v5, AArch64.v6, AArch64.v7});
        this.nativeParamsStackOffset = 0;
        this.heapBaseRegister = SubstrateOptions.SpawnIsolates.getValue() != false ? AArch64.r27 : null;
        this.threadRegister = SubstrateOptions.MultiThreaded.getValue() != false ? AArch64.r28 : null;
        ArrayList regs = new ArrayList(AArch64.allRegisters.asList());
        regs.remove(AArch64.sp);
        regs.remove(AArch64.zr);
        regs.remove(AArch64.r8);
        regs.remove(AArch64.r9);
        regs.remove(AArch64.r29);
        regs.remove(this.heapBaseRegister);
        regs.remove(this.threadRegister);
        this.allocatableRegs = new RegisterArray(regs);
        switch (config) {
            case NORMAL: {
                this.calleeSaveRegisters = new RegisterArray(new Register[0]);
                break;
            }
            case NATIVE_TO_JAVA: {
                this.calleeSaveRegisters = new RegisterArray(new Register[]{AArch64.r19, AArch64.r20, AArch64.r21, AArch64.r22, AArch64.r23, AArch64.r24, AArch64.r25, AArch64.r26, AArch64.r27, AArch64.r28});
                break;
            }
            default: {
                throw VMError.shouldNotReachHere();
            }
        }
        this.attributesMap = RegisterAttributes.createMap((RegisterConfig)this, (RegisterArray)AArch64.allRegisters);
    }

    public Register getReturnRegister(JavaKind kind) {
        switch (kind) {
            case Boolean: 
            case Byte: 
            case Char: 
            case Short: 
            case Int: 
            case Long: 
            case Object: {
                return AArch64.r0;
            }
            case Float: 
            case Double: {
                return AArch64.v0;
            }
            case Void: {
                return null;
            }
        }
        throw VMError.shouldNotReachHere();
    }

    public Register getFrameRegister() {
        return AArch64.sp;
    }

    @Override
    public Register getThreadRegister() {
        return this.threadRegister;
    }

    @Override
    public Register getHeapBaseRegister() {
        return this.heapBaseRegister;
    }

    public RegisterArray getAllocatableRegisters() {
        return this.allocatableRegs;
    }

    public RegisterArray getCalleeSaveRegisters() {
        return this.calleeSaveRegisters;
    }

    public RegisterArray getCallerSaveRegisters() {
        return this.getAllocatableRegisters();
    }

    public boolean areAllAllocatableRegistersCallerSaved() {
        return true;
    }

    public RegisterAttributes[] getAttributesMap() {
        return this.attributesMap;
    }

    public RegisterArray getCallingConventionRegisters(CallingConvention.Type type, JavaKind kind) {
        throw VMError.unimplemented();
    }

    public CallingConvention getCallingConvention(CallingConvention.Type t, JavaType returnType, JavaType[] parameterTypes, ValueKindFactory<?> valueKindFactory) {
        SubstrateCallingConventionType type = (SubstrateCallingConventionType)t;
        boolean isEntryPoint = type.nativeABI && !type.outgoing;
        AllocatableValue[] locations = new AllocatableValue[parameterTypes.length];
        int currentGeneral = 0;
        int currentXMM = 0;
        int currentStackOffset = type.nativeABI ? this.nativeParamsStackOffset : this.target.wordSize;
        JavaKind[] kinds = new JavaKind[locations.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            JavaKind kind;
            kinds[i] = kind = ObjectLayout.getCallSignatureKind(isEntryPoint, (ResolvedJavaType)parameterTypes[i], this.metaAccess, this.target);
            switch (kind) {
                case Boolean: 
                case Byte: 
                case Char: 
                case Short: 
                case Int: 
                case Long: 
                case Object: {
                    if (currentGeneral >= this.generalParameterRegs.size()) break;
                    Register register = this.generalParameterRegs.get(currentGeneral++);
                    locations[i] = register.asValue(valueKindFactory.getValueKind(kind.getStackKind()));
                    break;
                }
                case Float: 
                case Double: {
                    if (currentXMM >= this.xmmParameterRegs.size()) break;
                    Register register = this.xmmParameterRegs.get(currentXMM++);
                    locations[i] = register.asValue(valueKindFactory.getValueKind(kind));
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHere();
                }
            }
            if (locations[i] != null) continue;
            ValueKind valueKind = valueKindFactory.getValueKind(kind.getStackKind());
            locations[i] = StackSlot.get((ValueKind)valueKind, (int)currentStackOffset, (!type.outgoing ? 1 : 0) != 0);
            currentStackOffset += Math.max(valueKind.getPlatformKind().getSizeInBytes(), this.target.wordSize);
        }
        JavaKind returnKind = returnType == null ? JavaKind.Void : ObjectLayout.getCallSignatureKind(isEntryPoint, (ResolvedJavaType)returnType, this.metaAccess, this.target);
        AllocatableValue returnLocation = returnKind == JavaKind.Void ? Value.ILLEGAL : this.getReturnRegister(returnKind).asValue(valueKindFactory.getValueKind(returnKind.getStackKind()));
        return new SubstrateCallingConvention(type, kinds, currentStackOffset, returnLocation, locations);
    }

    public RegisterArray filterAllocatableRegisters(PlatformKind kind, RegisterArray registers) {
        ArrayList<Register> list = new ArrayList<Register>();
        for (Register reg : registers) {
            if (!this.target.arch.canStoreValue(reg.getRegisterCategory(), kind)) continue;
            list.add(reg);
        }
        return new RegisterArray(list);
    }
}

