/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.deopt;

import com.oracle.svm.core.annotate.UnknownPrimitiveField;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunctionPointer;

public class DeoptimizationSupport {
    @UnknownPrimitiveField
    private CFunctionPointer deoptStubPointer;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public DeoptimizationSupport() {
    }

    @Fold
    public static boolean enabled() {
        return ImageSingletons.contains(DeoptimizationSupport.class);
    }

    private static DeoptimizationSupport get() {
        return (DeoptimizationSupport)ImageSingletons.lookup(DeoptimizationSupport.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void setDeoptStubPointer(CFunctionPointer deoptStub) {
        assert (DeoptimizationSupport.get().deoptStubPointer == null) : "multiple deopt stub methods registered";
        DeoptimizationSupport.get().deoptStubPointer = deoptStub;
    }

    public static CFunctionPointer getDeoptStubPointer() {
        return DeoptimizationSupport.get().deoptStubPointer;
    }
}

