/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.config;

import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.annotate.Uninterruptible;
import java.lang.reflect.AnnotatedElement;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.util.GuardedAnnotationAccess;
import org.graalvm.word.WordBase;

public class ObjectLayout {
    private final SubstrateTargetDescription target;
    private final int referenceSize;
    private final int alignmentMask;
    private static final JavaKind arrayLengthKind = JavaKind.Int;
    private static final JavaKind arrayHashCodeKind = JavaKind.Int;

    public ObjectLayout(SubstrateTargetDescription target) {
        this.target = target;
        this.referenceSize = target.arch.getPlatformKind(JavaKind.Object).getSizeInBytes();
        this.alignmentMask = target.wordSize - 1;
    }

    public int getAlignment() {
        return this.target.wordSize;
    }

    public boolean isAligned(long value) {
        return value % (long)this.getAlignment() == 0L;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getReferenceSize() {
        return this.referenceSize;
    }

    public int getDeoptScratchSpace() {
        return this.target.getDeoptScratchSpace();
    }

    public int sizeInBytes(JavaKind kind) {
        return this.target.arch.getPlatformKind(kind).getSizeInBytes();
    }

    public int getArrayIndexShift(JavaKind kind) {
        return CodeUtil.log2((int)this.getArrayIndexScale(kind));
    }

    public int getArrayIndexScale(JavaKind kind) {
        return this.sizeInBytes(kind);
    }

    public int alignUp(int obj) {
        return obj + this.alignmentMask & ~this.alignmentMask;
    }

    public long alignUp(long obj) {
        return obj + (long)this.alignmentMask & (long)(~this.alignmentMask);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getHubOffset() {
        return 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getHubNextOffset() {
        return this.getHubOffset() + this.getReferenceSize();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getFirstFieldOffset() {
        return this.getHubNextOffset();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getArrayLengthOffset() {
        return this.getHubNextOffset();
    }

    private int getArrayLengthNextOffset() {
        return this.getArrayLengthOffset() + this.sizeInBytes(arrayLengthKind);
    }

    public int getArrayHashCodeOffset() {
        return NumUtil.roundUp((int)this.getArrayLengthNextOffset(), (int)this.sizeInBytes(arrayHashCodeKind));
    }

    private int getArrayHashCodeNextOffset() {
        return this.getArrayHashCodeOffset() + this.sizeInBytes(arrayHashCodeKind);
    }

    public int getArrayBaseOffset(JavaKind kind) {
        return NumUtil.roundUp((int)this.getArrayHashCodeNextOffset(), (int)this.sizeInBytes(kind));
    }

    public long getArrayElementOffset(JavaKind kind, int index) {
        return this.getArrayBaseOffset(kind) + index * this.sizeInBytes(kind);
    }

    public long getArraySize(JavaKind kind, int length) {
        return this.alignUp((long)this.getArrayBaseOffset(kind) + ((long)length << this.getArrayIndexShift(kind)));
    }

    public static JavaKind getCallSignatureKind(boolean isEntryPoint, ResolvedJavaType type, MetaAccessProvider metaAccess, TargetDescription target) {
        if (metaAccess.lookupJavaType(WordBase.class).isAssignableFrom(type)) {
            return target.wordJavaKind;
        }
        if (isEntryPoint && GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)type, CEnum.class)) {
            return JavaKind.Int;
        }
        return type.getJavaKind();
    }
}

