/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.nfi;

import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.truffle.nfi.NativeAPI;
import com.oracle.svm.truffle.nfi.NativeAPIImpl;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_impl_NFIContext;
import com.oracle.svm.truffle.nfi.libffi.LibFFI;
import com.oracle.truffle.nfi.types.NativeSimpleType;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.c.function.CFunctionPointer;

public final class NFIInitialization {
    private static final CGlobalData<LibFFI.ffi_type> ffi_type_pointer = CGlobalDataFactory.forSymbol("ffi_type_pointer");
    private static final CGlobalData<LibFFI.ffi_type> ffi_type_void = CGlobalDataFactory.forSymbol("ffi_type_void");
    private static final CGlobalData<LibFFI.ffi_type> ffi_type_uint8 = CGlobalDataFactory.forSymbol("ffi_type_uint8");
    private static final CGlobalData<LibFFI.ffi_type> ffi_type_sint8 = CGlobalDataFactory.forSymbol("ffi_type_sint8");
    private static final CGlobalData<LibFFI.ffi_type> ffi_type_uint16 = CGlobalDataFactory.forSymbol("ffi_type_uint16");
    private static final CGlobalData<LibFFI.ffi_type> ffi_type_sint16 = CGlobalDataFactory.forSymbol("ffi_type_sint16");
    private static final CGlobalData<LibFFI.ffi_type> ffi_type_uint32 = CGlobalDataFactory.forSymbol("ffi_type_uint32");
    private static final CGlobalData<LibFFI.ffi_type> ffi_type_sint32 = CGlobalDataFactory.forSymbol("ffi_type_sint32");
    private static final CGlobalData<LibFFI.ffi_type> ffi_type_uint64 = CGlobalDataFactory.forSymbol("ffi_type_uint64");
    private static final CGlobalData<LibFFI.ffi_type> ffi_type_sint64 = CGlobalDataFactory.forSymbol("ffi_type_sint64");
    private static final CGlobalData<LibFFI.ffi_type> ffi_type_float = CGlobalDataFactory.forSymbol("ffi_type_float");
    private static final CGlobalData<LibFFI.ffi_type> ffi_type_double = CGlobalDataFactory.forSymbol("ffi_type_double");

    private static void initializeNativeSimpleType(Target_com_oracle_truffle_nfi_impl_NFIContext context, NativeSimpleType simpleType, LibFFI.ffi_type ffiType) {
        int size = (int)ffiType.size().rawValue();
        short alignment = ffiType.alignment();
        context.initializeSimpleType(simpleType, size, alignment, ffiType.rawValue());
    }

    static void initializeSimpleTypes(Target_com_oracle_truffle_nfi_impl_NFIContext context) {
        NFIInitialization.initializeNativeSimpleType(context, NativeSimpleType.POINTER, ffi_type_pointer.get());
        NFIInitialization.initializeNativeSimpleType(context, NativeSimpleType.VOID, ffi_type_void.get());
        NFIInitialization.initializeNativeSimpleType(context, NativeSimpleType.UINT8, ffi_type_uint8.get());
        NFIInitialization.initializeNativeSimpleType(context, NativeSimpleType.SINT8, ffi_type_sint8.get());
        NFIInitialization.initializeNativeSimpleType(context, NativeSimpleType.UINT16, ffi_type_uint16.get());
        NFIInitialization.initializeNativeSimpleType(context, NativeSimpleType.SINT16, ffi_type_sint16.get());
        NFIInitialization.initializeNativeSimpleType(context, NativeSimpleType.UINT32, ffi_type_uint32.get());
        NFIInitialization.initializeNativeSimpleType(context, NativeSimpleType.SINT32, ffi_type_sint32.get());
        NFIInitialization.initializeNativeSimpleType(context, NativeSimpleType.UINT64, ffi_type_uint64.get());
        NFIInitialization.initializeNativeSimpleType(context, NativeSimpleType.SINT64, ffi_type_sint64.get());
        NFIInitialization.initializeNativeSimpleType(context, NativeSimpleType.FLOAT, ffi_type_float.get());
        NFIInitialization.initializeNativeSimpleType(context, NativeSimpleType.DOUBLE, ffi_type_double.get());
        NFIInitialization.initializeNativeSimpleType(context, NativeSimpleType.STRING, ffi_type_pointer.get());
        NFIInitialization.initializeNativeSimpleType(context, NativeSimpleType.OBJECT, ffi_type_pointer.get());
    }

    static void initializeContext(NativeAPI.NativeTruffleContext ctx) {
        ctx.nativeAPI().setGetTruffleContextFunction((NativeAPI.GetTruffleContextFunction)NativeAPIImpl.GET_TRUFFLE_CONTEXT.getFunctionPointer());
        ctx.nativeAPI().setNewObjectRefFunction((NativeAPI.NewObjectRefFunction)NativeAPIImpl.NEW_OBJECT_REF.getFunctionPointer());
        ctx.nativeAPI().setReleaseObjectRefFunction((NativeAPI.ReleaseObjectRefFunction)NativeAPIImpl.RELEASE_OBJECT_REF.getFunctionPointer());
        ctx.nativeAPI().setReleaseAndReturnFunction((NativeAPI.ReleaseAndReturnFunction)NativeAPIImpl.RELEASE_AND_RETURN.getFunctionPointer());
        ctx.nativeAPI().setIsSameObjectFunction((NativeAPI.IsSameObjectFunction)NativeAPIImpl.IS_SAME_OBJECT.getFunctionPointer());
        ctx.nativeAPI().setNewClosureRefFunction((NativeAPI.NewClosureRefFunction)NativeAPIImpl.NEW_CLOSURE_REF.getFunctionPointer());
        ctx.nativeAPI().setReleaseClosureRefFunction((NativeAPI.ReleaseClosureRefFunction)NativeAPIImpl.RELEASE_CLOSURE_REF.getFunctionPointer());
        ctx.nativeAPI().setGetClosureObjectFunction((NativeAPI.GetClosureObjectFunction)NativeAPIImpl.GET_CLOSURE_OBJECT.getFunctionPointer());
        ctx.threadAPI().setGetTruffleEnvFunction((NativeAPI.GetTruffleEnvFunction)NativeAPIImpl.GET_TRUFFLE_ENV.getFunctionPointer());
        ctx.threadAPI().setAttachCurrentThreadFunction((NativeAPI.AttachCurrentThreadFunction)NativeAPIImpl.ATTACH_CURRENT_THREAD.getFunctionPointer());
        ctx.threadAPI().setDetachCurrentThreadFunction((NativeAPI.DetachCurrentThreadFunction)NativeAPIImpl.DETACH_CURRENT_THREAD.getFunctionPointer());
        ctx.setFunctions(ctx.threadAPI());
        ctx.setIsolate(CurrentIsolate.getIsolate());
    }

    static void initializeEnv(NativeAPI.NativeTruffleEnv env, NativeAPI.NativeTruffleContext ctx) {
        env.setFunctions(ctx.nativeAPI());
        env.setContext(ctx);
        env.setIsolateThread(CurrentIsolate.getCurrentThread());
    }

    static interface InitializeNativeSimpleTypeCallback
    extends CFunctionPointer {
    }
}

