/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.snippets;

import com.oracle.svm.core.graal.nodes.UnreachableNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateIntrinsics;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.hosted.nodes.AssertStampNode;
import com.oracle.svm.hosted.nodes.AssertTypeStateNode;
import com.oracle.svm.hosted.nodes.DiscardStampNode;
import java.util.Map;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.TriState;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.replacements.nodes.ExplodeLoopNode;
import org.graalvm.word.LocationIdentity;

public final class AssertSnippets
extends SubstrateTemplates
implements Snippets {
    @Snippet
    protected static Object assertStampSnippet(Object object, @Snippet.ConstantParameter boolean alwaysNull, @Snippet.ConstantParameter boolean nonNull, @Snippet.ConstantParameter boolean exactType, DynamicHub expectedHub, byte[] message) {
        Object objectWithoutStamp = DiscardStampNode.discardStamp(object);
        if (AssertSnippets.checkStamp(object, alwaysNull, nonNull, exactType, expectedHub)) {
            return PiNode.piCastToSnippetReplaceeStamp((Object)objectWithoutStamp);
        }
        SubstrateIntrinsics.runtimeCall((ForeignCallDescriptor)SnippetRuntime.REPORT_TYPE_ASSERTION_ERROR, message, objectWithoutStamp);
        throw UnreachableNode.unreachable();
    }

    private static boolean checkStamp(Object object, boolean alwaysNull, boolean nonNull, boolean exactType, DynamicHub expectedHub) {
        if (object != null) {
            if (alwaysNull) {
                return false;
            }
            if (expectedHub != null) {
                if (exactType) {
                    return expectedHub == KnownIntrinsics.readHub(object);
                }
                return DynamicHub.toClass(expectedHub).isAssignableFrom(object.getClass());
            }
            return true;
        }
        return !nonNull;
    }

    @Snippet
    protected static Object assertTypeStateSnippet(Object object, @Snippet.ConstantParameter boolean nonNull, @Snippet.VarargsParameter DynamicHub[] expectedHubs, byte[] message) {
        Object objectWithoutStamp = DiscardStampNode.discardStamp(object);
        if (AssertSnippets.checkTypeState(objectWithoutStamp, nonNull, expectedHubs)) {
            return PiNode.piCastToSnippetReplaceeStamp((Object)objectWithoutStamp);
        }
        SubstrateIntrinsics.runtimeCall((ForeignCallDescriptor)SnippetRuntime.REPORT_TYPE_ASSERTION_ERROR, message, objectWithoutStamp);
        throw UnreachableNode.unreachable();
    }

    private static boolean checkTypeState(Object object, boolean nonNull, DynamicHub[] expectedHubs) {
        if (expectedHubs.length == 0 && nonNull) {
            return false;
        }
        if (object != null) {
            DynamicHub objectHub = KnownIntrinsics.readHub(object);
            ExplodeLoopNode.explodeLoop();
            for (DynamicHub expectedHub : expectedHubs) {
                if (expectedHub != objectHub) continue;
                return true;
            }
            return false;
        }
        return !nonNull;
    }

    public static void registerLowerings(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        new AssertSnippets(options, factories, providers, snippetReflection, lowerings);
    }

    private AssertSnippets(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, factories, providers, snippetReflection);
        lowerings.put(AssertStampNode.class, new AssertStampLowering());
        lowerings.put(AssertTypeStateNode.class, new AssertTypeStateLowering());
    }

    protected class AssertTypeStateLowering
    implements NodeLoweringProvider<AssertTypeStateNode> {
        private final SnippetTemplate.SnippetInfo assertTypeState;

        protected AssertTypeStateLowering() {
            this.assertTypeState = AssertSnippets.this.snippet((Class<? extends Snippets>)AssertSnippets.class, "assertTypeStateSnippet", new LocationIdentity[0]);
        }

        @Override
        public final void lower(AssertTypeStateNode node, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.assertTypeState, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("object", (Object)node.getInput());
            args.addConst("nonNull", (Object)(node.getTypeState().getNullSeen() == TriState.FALSE ? 1 : 0));
            JavaTypeProfile.ProfiledType[] types = node.getTypeState().getTypes();
            ConstantNode[] expectedHubs = new ConstantNode[types.length];
            for (int i = 0; i < expectedHubs.length; ++i) {
                expectedHubs[i] = ConstantNode.forConstant((JavaConstant)AssertSnippets.this.providers.getConstantReflection().asJavaClass(types[i].getType()), (MetaAccessProvider)AssertSnippets.this.providers.getMetaAccess(), (StructuredGraph)node.graph());
            }
            args.addVarargs("expectedHubs", Class.class, StampFactory.forKind((JavaKind)JavaKind.Object), (Object)expectedHubs);
            String msg = ((Object)((Object)node)).getClass().getSimpleName() + " failed: " + node.graph().method().format("%H.%n(%p)") + " @ " + node.toString(Verbosity.Short) + " expected type state " + node.getTypeState() + " but found ";
            args.add("message", (Object)msg.getBytes());
            AssertSnippets.this.template((ValueNode)node, args).instantiate(AssertSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    protected class AssertStampLowering
    implements NodeLoweringProvider<AssertStampNode> {
        private final SnippetTemplate.SnippetInfo assertStamp;

        protected AssertStampLowering() {
            this.assertStamp = AssertSnippets.this.snippet((Class<? extends Snippets>)AssertSnippets.class, "assertStampSnippet", new LocationIdentity[0]);
        }

        @Override
        public final void lower(AssertStampNode node, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.assertStamp, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("object", (Object)node.getInput());
            args.addConst("alwaysNull", (Object)StampTool.isPointerAlwaysNull((Stamp)node.stamp(NodeView.DEFAULT)));
            args.addConst("nonNull", (Object)StampTool.isPointerNonNull((Stamp)node.stamp(NodeView.DEFAULT)));
            args.addConst("exactType", (Object)StampTool.isExactType((Stamp)node.stamp(NodeView.DEFAULT)));
            ResolvedJavaType type = StampTool.typeOrNull((Stamp)node.stamp(NodeView.DEFAULT));
            args.add("expectedHub", type == null ? null : ConstantNode.forConstant((JavaConstant)AssertSnippets.this.providers.getConstantReflection().asJavaClass(type), (MetaAccessProvider)AssertSnippets.this.providers.getMetaAccess(), (StructuredGraph)node.graph()));
            String msg = ((Object)((Object)node)).getClass().getSimpleName() + " failed: " + node.graph().method().format("%H.%n(%p)") + " @ " + node.toString(Verbosity.Short) + " expected stamp " + node.stamp(NodeView.DEFAULT) + " but found ";
            args.add("message", (Object)msg.getBytes());
            AssertSnippets.this.template((ValueNode)node, args).instantiate(AssertSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

