/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.code.ImageCodeInfo;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.DeoptEntryInfopoint;
import com.oracle.svm.core.graal.code.CGlobalDataReference;
import com.oracle.svm.core.graal.code.SubstrateDataBuilder;
import com.oracle.svm.core.graal.code.amd64.AMD64InstructionPatcher;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.Counter;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.code.CompilationInfo;
import com.oracle.svm.hosted.code.CompilationInfoSupport;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.MethodPointer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.code.site.DataSectionReference;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.code.DataSection;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.WordFactory;

public class NativeImageCodeCache {
    public static final int CODE_ALIGNMENT = 16;
    private static final byte CODE_FILLER_BYTE = -52;
    private final NativeImageHeap imageHeap;
    private final Map<HostedMethod, CompilationResult> compilations;
    private final NavigableMap<Integer, CompilationResult> compilationsByStart = new TreeMap<Integer, CompilationResult>();
    private final DataSection dataSection;
    private int codeCacheSize;
    private final Map<JavaConstant, String> constantReasons = new HashMap<JavaConstant, String>();

    public NativeImageCodeCache(Map<HostedMethod, CompilationResult> compilations, NativeImageHeap imageHeap) {
        this.compilations = compilations;
        this.imageHeap = imageHeap;
        this.dataSection = new DataSection();
    }

    public int getCodeCacheSize() {
        assert (this.codeCacheSize > 0);
        return this.codeCacheSize;
    }

    public int getConstantsSize() {
        return this.dataSection.getSectionSize();
    }

    public int getAlignedConstantsSize() {
        return ConfigurationValues.getObjectLayout().alignUp(this.getConstantsSize());
    }

    public CompilationResult getCompilationAtOffset(int offset) {
        Map.Entry<Integer, CompilationResult> floor = this.compilationsByStart.floorEntry(offset);
        if (floor != null) {
            return floor.getValue();
        }
        return null;
    }

    public void layoutMethods(DebugContext debug) {
        try (Indent indent = debug.logAndIndent("layout methods");){
            assert (this.codeCacheSize == 0);
            HostedMethod firstMethod = null;
            for (Map.Entry<HostedMethod, CompilationResult> entry : this.compilations.entrySet()) {
                HostedMethod method = entry.getKey();
                if (firstMethod == null) {
                    firstMethod = method;
                }
                CompilationResult compilationResult = entry.getValue();
                this.compilationsByStart.put(this.codeCacheSize, compilationResult);
                method.setCodeAddressOffset(this.codeCacheSize);
                this.codeCacheSize = NumUtil.roundUp((int)(this.codeCacheSize + compilationResult.getTargetCodeSize()), (int)16);
            }
            FrameInfoCustomization frameInfoCustomization = new FrameInfoCustomization();
            CodeInfoEncoder codeInfoEncoder = new CodeInfoEncoder(frameInfoCustomization, null);
            for (Map.Entry entry : this.compilations.entrySet()) {
                HostedMethod method = (HostedMethod)entry.getKey();
                CompilationResult compilation = (CompilationResult)entry.getValue();
                codeInfoEncoder.addMethod(method, compilation, method.getCodeAddressOffset());
            }
            if (NativeImageOptions.PrintMethodHistogram.getValue().booleanValue()) {
                System.out.println("encoded deopt entry points                 ; " + frameInfoCustomization.numDeoptEntryPoints);
                System.out.println("encoded during call entry points           ; " + frameInfoCustomization.numDuringCallEntryPoints);
            }
            ImageCodeInfo imageCodeInfo = CodeInfoTable.getImageCodeCache();
            codeInfoEncoder.encodeAll();
            codeInfoEncoder.install(imageCodeInfo);
            imageCodeInfo.setData(MethodPointer.factory(firstMethod), WordFactory.unsigned((int)this.codeCacheSize));
            if (CodeInfoEncoder.Options.CodeInfoEncoderCounters.getValue().booleanValue()) {
                for (Counter counter : ((CodeInfoEncoder.Counters)ImageSingletons.lookup(CodeInfoEncoder.Counters.class)).group.getCounters()) {
                    System.out.println(counter.getName() + " ; " + counter.getValue());
                }
            }
            if (Options.VerifyDeoptimizationEntryPoints.getValue().booleanValue()) {
                this.verifyDeoptEntries(imageCodeInfo);
            }
            assert (this.verifyMethods(codeInfoEncoder));
        }
    }

    private void verifyDeoptEntries(ImageCodeInfo imageCodeInfo) {
        boolean hasError = false;
        ArrayList<Map.Entry<AnalysisMethod, Set<Long>>> deoptEntries = new ArrayList<Map.Entry<AnalysisMethod, Set<Long>>>(CompilationInfoSupport.singleton().getDeoptEntries().entrySet());
        deoptEntries.sort((e1, e2) -> ((AnalysisMethod)e1.getKey()).format("%H.%n(%p)").compareTo(((AnalysisMethod)e2.getKey()).format("%H.%n(%p)")));
        for (Map.Entry entry : deoptEntries) {
            HostedMethod method = this.imageHeap.getUniverse().lookup((JavaMethod)entry.getKey());
            ArrayList encodedBcis = new ArrayList((Collection)entry.getValue());
            encodedBcis.sort((v1, v2) -> Long.compare(v1, v2));
            Iterator iterator = encodedBcis.iterator();
            while (iterator.hasNext()) {
                long encodedBci = (Long)iterator.next();
                hasError |= NativeImageCodeCache.verifyDeoptEntry(imageCodeInfo, method, encodedBci);
            }
        }
        if (hasError) {
            VMError.shouldNotReachHere("Verification of deoptimization entry points failed");
        }
    }

    private static boolean verifyDeoptEntry(ImageCodeInfo imageCodeInfo, HostedMethod method, long encodedBci) {
        int deoptOffsetInImage = method.getDeoptOffsetInImage();
        if (deoptOffsetInImage <= 0) {
            return NativeImageCodeCache.error(method, encodedBci, "entry point method not compiled");
        }
        CodeInfoQueryResult result = new CodeInfoQueryResult();
        long relativeIP = imageCodeInfo.lookupDeoptimizationEntrypoint(deoptOffsetInImage, encodedBci, result);
        if (relativeIP < 0L) {
            return NativeImageCodeCache.error(method, encodedBci, "entry point not found");
        }
        if (result.getFrameInfo() == null || !result.getFrameInfo().isDeoptEntry() || result.getFrameInfo().getEncodedBci() != encodedBci) {
            return NativeImageCodeCache.error(method, encodedBci, "entry point found, but wrong property");
        }
        return false;
    }

    private static boolean error(HostedMethod method, long encodedBci, String msg) {
        System.out.println(method.format("%H.%n(%p)") + ", encodedBci " + encodedBci + " (bci " + FrameInfoDecoder.readableBci(encodedBci) + "): " + msg);
        return true;
    }

    private boolean verifyMethods(CodeInfoEncoder codeInfoEncoder) {
        for (Map.Entry<HostedMethod, CompilationResult> entry : this.compilations.entrySet()) {
            codeInfoEncoder.verifyMethod(entry.getValue(), entry.getKey().getCodeAddressOffset());
        }
        return true;
    }

    public void layoutConstants() {
        for (CompilationResult compilation : this.compilations.values()) {
            for (DataSection.Data data : compilation.getDataSection()) {
                if (!(data instanceof SubstrateDataBuilder.ObjectData)) continue;
                SubstrateObjectConstant constant = ((SubstrateDataBuilder.ObjectData)data).getConstant();
                this.constantReasons.put(constant, compilation.getName());
            }
            this.dataSection.addAll(compilation.getDataSection());
        }
        this.dataSection.close();
    }

    public void addConstantsToHeap() {
        for (DataSection.Data data : this.dataSection) {
            if (!(data instanceof SubstrateDataBuilder.ObjectData)) continue;
            SubstrateObjectConstant constant = ((SubstrateDataBuilder.ObjectData)data).getConstant();
            this.addConstantToHeap(constant);
        }
        for (CompilationResult compilationResult : this.compilations.values()) {
            for (DataPatch patch : compilationResult.getDataPatches()) {
                if (!(patch.reference instanceof ConstantReference)) continue;
                this.addConstantToHeap((Constant)((ConstantReference)patch.reference).getConstant());
            }
        }
    }

    private void addConstantToHeap(Constant constant) {
        Object obj = SubstrateObjectConstant.asObject(constant);
        if (!this.imageHeap.getMetaAccess().lookupJavaType((Class)obj.getClass()).getWrapped().isInstantiated()) {
            throw VMError.shouldNotReachHere("Non-instantiated type referenced by a compiled method: " + obj.getClass().getName());
        }
        this.imageHeap.addObject(obj, false, this.constantReasons.get(constant));
    }

    public void patchMethods(RelocatableBuffer relocs) {
        for (Map.Entry<HostedMethod, CompilationResult> entry : this.compilations.entrySet()) {
            HostedMethod method = entry.getKey();
            CompilationResult compilation = entry.getValue();
            int compStart = method.getCodeAddressOffset();
            AMD64InstructionPatcher patcher = new AMD64InstructionPatcher(compilation);
            for (Infopoint infopoint : compilation.getInfopoints()) {
                if (!(infopoint instanceof Call) || !((Call)infopoint).direct) continue;
                Call call = (Call)infopoint;
                int callTargetStart = ((HostedMethod)call.target).getCodeAddressOffset();
                int pcDisplacement = callTargetStart - (compStart + call.pcOffset);
                patcher.findPatchData(call.pcOffset, pcDisplacement).apply(compilation.getTargetCode());
            }
            for (DataPatch dataPatch : compilation.getDataPatches()) {
                Reference ref = dataPatch.reference;
                AMD64InstructionPatcher.PatchData patchData = patcher.findPatchData(dataPatch.pcOffset, 0);
                long siteOffset = compStart + patchData.operandPosition;
                if (ref instanceof DataSectionReference || ref instanceof CGlobalDataReference) {
                    long addend = patchData.nextInstructionPosition - patchData.operandPosition;
                    relocs.addPCRelativeRelocationWithAddend((int)siteOffset, patchData.operandSize, addend, ref);
                    continue;
                }
                if (ref instanceof ConstantReference) {
                    assert (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) : "Inlined object references must be base-relative";
                    relocs.addDirectRelocationWithoutAddend((int)siteOffset, patchData.operandSize, ref);
                    continue;
                }
                throw VMError.shouldNotReachHere("Unknown type of reference in code");
            }
        }
    }

    public void writeConstants(RelocatableBuffer buffer) {
        ByteBuffer bb = buffer.getBuffer();
        this.dataSection.buildDataSection(bb, (position, constant) -> this.imageHeap.writeReference(buffer, position, SubstrateObjectConstant.asObject((Constant)constant), "VMConstant: " + constant));
    }

    public void writeCode(RelocatableBuffer buffer) {
        int startPos = buffer.getPosition();
        for (Map.Entry<HostedMethod, CompilationResult> entry : this.compilations.entrySet()) {
            HostedMethod method = entry.getKey();
            CompilationResult compilation = entry.getValue();
            buffer.setPosition(startPos + method.getCodeAddressOffset());
            int codeSize = compilation.getTargetCodeSize();
            buffer.putBytes(compilation.getTargetCode(), 0, codeSize);
            for (int i = codeSize; i < NumUtil.roundUp((int)codeSize, (int)16); ++i) {
                buffer.putByte((byte)-52);
            }
        }
        buffer.setPosition(startPos);
    }

    public Map<HostedMethod, CompilationResult> getCompilations() {
        return this.compilations;
    }

    public void printCompilationResults() {
        System.out.println("--- compiled methods");
        for (Map.Entry<HostedMethod, CompilationResult> entry : this.compilations.entrySet()) {
            HostedMethod method = entry.getKey();
            System.out.format("%8d %5d %s: frame %d\n", method.getCodeAddressOffset(), entry.getValue().getTargetCodeSize(), method.format("%H.%n(%p)"), entry.getValue().getTotalFrameSize());
        }
        System.out.println("--- vtables:");
        for (HostedType type : this.imageHeap.getUniverse().getTypes()) {
            for (int i = 0; i < type.getVTable().length; ++i) {
                CompilationResult comp;
                HostedMethod method = type.getVTable()[i];
                if (method == null || (comp = this.compilations.get(type.getVTable()[i])) == null) continue;
                System.out.format("%d %s @ %d: %s = 0x%x\n", type.getTypeID(), type.toJavaName(false), i, method.format("%r %n(%p)"), method.getCodeAddressOffset());
            }
        }
    }

    private static class FrameInfoCustomization
    extends FrameInfoEncoder.NamesFromMethod {
        int numDeoptEntryPoints;
        int numDuringCallEntryPoints;

        private FrameInfoCustomization() {
        }

        @Override
        protected boolean shouldStoreMethod() {
            return false;
        }

        @Override
        protected boolean shouldInclude(ResolvedJavaMethod method, Infopoint infopoint) {
            CompilationInfo compilationInfo = ((HostedMethod)method).compilationInfo;
            BytecodeFrame topFrame = infopoint.debugInfo.frame();
            if (this.isDeoptEntry(method, infopoint)) {
                if (infopoint instanceof DeoptEntryInfopoint) {
                    ++this.numDeoptEntryPoints;
                } else if (infopoint instanceof Call) {
                    ++this.numDuringCallEntryPoints;
                } else {
                    throw VMError.shouldNotReachHere();
                }
                return true;
            }
            BytecodeFrame rootFrame = topFrame;
            while (rootFrame.caller() != null) {
                rootFrame = rootFrame.caller();
            }
            assert (rootFrame.getMethod().equals(method));
            boolean isDeoptEntry = compilationInfo.isDeoptEntry(rootFrame.getBCI(), rootFrame.duringCall, rootFrame.rethrowException);
            if (infopoint instanceof DeoptEntryInfopoint) {
                assert (isDeoptEntry);
                assert (topFrame == rootFrame) : "Deoptimization target has inlined frame";
                ++this.numDeoptEntryPoints;
                return true;
            }
            if (isDeoptEntry && topFrame.duringCall) {
                assert (infopoint instanceof Call);
                assert (topFrame == rootFrame) : "Deoptimization target has inlined frame";
                ++this.numDuringCallEntryPoints;
                return true;
            }
            for (BytecodeFrame frame = topFrame; frame != null; frame = frame.caller()) {
                if (!CompilationInfoSupport.singleton().isFrameInformationRequired(frame.getMethod())) continue;
                return true;
            }
            return compilationInfo.canDeoptForTesting();
        }

        @Override
        protected boolean isDeoptEntry(ResolvedJavaMethod method, Infopoint infopoint) {
            BytecodeFrame topFrame;
            CompilationInfo compilationInfo = ((HostedMethod)method).compilationInfo;
            BytecodeFrame rootFrame = topFrame = infopoint.debugInfo.frame();
            while (rootFrame.caller() != null) {
                rootFrame = rootFrame.caller();
            }
            assert (rootFrame.getMethod().equals(method));
            boolean isDeoptEntry = compilationInfo.isDeoptEntry(rootFrame.getBCI(), rootFrame.duringCall, rootFrame.rethrowException);
            if (infopoint instanceof DeoptEntryInfopoint) {
                assert (isDeoptEntry);
                assert (topFrame == rootFrame) : "Deoptimization target has inlined frame";
                return true;
            }
            if (isDeoptEntry && topFrame.duringCall) {
                assert (infopoint instanceof Call);
                assert (topFrame == rootFrame) : "Deoptimization target has inlined frame";
                return true;
            }
            return false;
        }
    }

    public static class Options {
        @Option(help={"Verify that all possible deoptimization entry points have been properly compiled and registered in the metadata"})
        public static final HostedOptionKey<Boolean> VerifyDeoptimizationEntryPoints = new HostedOptionKey<Boolean>(false);
    }
}

