/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.code.RestrictHeapAccessCallees;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;

@AutomaticFeature
class RestrictHeapAccessCalleesFeature
implements Feature {
    RestrictHeapAccessCalleesFeature() {
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(RestrictHeapAccessCallees.class, (Object)new RestrictHeapAccessCallees());
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        List<ResolvedJavaMethod> assertionErrorConstructorList = RestrictHeapAccessCalleesFeature.initializeAssertionErrorConstructors(access);
        ((RestrictHeapAccessCallees)ImageSingletons.lookup(RestrictHeapAccessCallees.class)).setAssertionErrorConstructors(assertionErrorConstructorList);
    }

    private static List<ResolvedJavaMethod> initializeAssertionErrorConstructors(Feature.DuringAnalysisAccess access) {
        ArrayList<ResolvedJavaMethod> result = new ArrayList<ResolvedJavaMethod>();
        result.add(RestrictHeapAccessCalleesFeature.findAssertionConstructor(access, new Class[0]));
        result.add(RestrictHeapAccessCalleesFeature.findAssertionConstructor(access, Boolean.TYPE));
        result.add(RestrictHeapAccessCalleesFeature.findAssertionConstructor(access, Character.TYPE));
        result.add(RestrictHeapAccessCalleesFeature.findAssertionConstructor(access, Integer.TYPE));
        result.add(RestrictHeapAccessCalleesFeature.findAssertionConstructor(access, Long.TYPE));
        result.add(RestrictHeapAccessCalleesFeature.findAssertionConstructor(access, Float.TYPE));
        result.add(RestrictHeapAccessCalleesFeature.findAssertionConstructor(access, Double.TYPE));
        result.add(RestrictHeapAccessCalleesFeature.findAssertionConstructor(access, Object.class));
        result.add(RestrictHeapAccessCalleesFeature.findAssertionConstructor(access, String.class, Throwable.class));
        return result;
    }

    private static ResolvedJavaMethod findAssertionConstructor(Feature.DuringAnalysisAccess access, Class<?> ... parameterTypes) {
        try {
            Constructor reflectiveConstructor = AssertionError.class.getConstructor(parameterTypes);
            AnalysisMethod resolvedConstructor = ((FeatureImpl.DuringAnalysisAccessImpl)access).getMetaAccess().lookupJavaMethod(reflectiveConstructor);
            return resolvedConstructor;
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw VMError.shouldNotReachHere("Should have found AssertionError constructor." + ex);
        }
    }
}

