/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.annotation.AnnotationSubstitutionType;
import com.oracle.svm.hosted.annotation.CustomSubstitutionField;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;

public class AnnotationSubstitutionField
extends CustomSubstitutionField {
    private final ResolvedJavaMethod accessorMethod;
    private final Map<JavaConstant, JavaConstant> valueCache;
    private final SnippetReflectionProvider snippetReflection;

    public AnnotationSubstitutionField(AnnotationSubstitutionType declaringClass, ResolvedJavaMethod accessorMethod, SnippetReflectionProvider snippetReflection) {
        super(declaringClass);
        this.accessorMethod = accessorMethod;
        this.snippetReflection = snippetReflection;
        this.valueCache = Collections.synchronizedMap(new HashMap());
    }

    public String getName() {
        return this.accessorMethod.getName();
    }

    public JavaType getType() {
        return this.accessorMethod.getSignature().getReturnType(this.accessorMethod.getDeclaringClass());
    }

    @Override
    public JavaConstant readValue(JavaConstant receiver) {
        JavaConstant result = this.valueCache.get(receiver);
        if (result == null) {
            try {
                Proxy proxy = (Proxy)this.snippetReflection.asObject(Proxy.class, receiver);
                Method reflectionMethod = proxy.getClass().getDeclaredMethod(this.accessorMethod.getName(), new Class[0]);
                reflectionMethod.setAccessible(true);
                result = this.snippetReflection.forBoxed(this.getJavaKind(), reflectionMethod.invoke((Object)proxy, new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
            this.valueCache.put(receiver, result);
        }
        return result;
    }

    @Override
    public boolean allowConstantFolding() {
        return true;
    }

    @Override
    public boolean injectFinalForRuntimeCompilation() {
        return true;
    }

    public String toString() {
        return "AnnotationField<" + this.format("%h.%n") + ">";
    }
}

