/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.AnalysisPolicy;
import com.oracle.graal.pointsto.api.HostVM;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.annotate.UnknownClass;
import com.oracle.svm.core.annotate.UnknownObjectField;
import com.oracle.svm.core.annotate.UnknownPrimitiveField;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jdk.JavaLangSubstitutions;
import com.oracle.svm.core.jdk.Target_java_lang_ClassLoader;
import com.oracle.svm.core.util.HostedStringDeduplication;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ClassInitializationFeature;
import com.oracle.svm.hosted.ImageSingletonsSupportImpl;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.c.GraalAccess;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.phases.AnalysisGraphBuilderPhase;
import com.oracle.svm.hosted.substitute.UnsafeAutomaticSubstitutionProcessor;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.RelocatedPointer;

public final class SVMHost
implements HostVM {
    private final ConcurrentHashMap<AnalysisType, DynamicHub> typeToHub = new ConcurrentHashMap();
    private final ConcurrentHashMap<DynamicHub, AnalysisType> hubToType = new ConcurrentHashMap();
    private final OptionValues options;
    private final Platform platform;
    private final AnalysisPolicy analysisPolicy;
    private final ClassLoader classLoader;
    private final ClassInitializationFeature classInitializationFeature;
    private final HostedStringDeduplication stringTable;

    public SVMHost(OptionValues options, Platform platform, AnalysisPolicy analysisPolicy, ClassLoader classLoader) {
        this.options = options;
        this.platform = platform;
        this.analysisPolicy = analysisPolicy;
        this.classLoader = classLoader;
        this.classInitializationFeature = ClassInitializationFeature.singleton();
        this.stringTable = HostedStringDeduplication.singleton();
    }

    public OptionValues options() {
        return this.options;
    }

    public AnalysisPolicy analysisPolicy() {
        return this.analysisPolicy;
    }

    public GraphBuilderPhase.Instance createGraphBuilderPhase(HostedProviders providers, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext) {
        return new AnalysisGraphBuilderPhase(providers.getMetaAccess(), providers.getStampProvider(), providers.getConstantReflection(), providers.getConstantFieldProvider(), graphBuilderConfig, optimisticOpts, initialIntrinsicContext, providers.getWordTypes());
    }

    public String inspectServerContentPath() {
        return (String)PointstoOptions.InspectServerContentPath.getValue(this.options);
    }

    public void warn(String message) {
        System.err.println("warning: " + message);
    }

    public String getImageName() {
        return (String)NativeImageOptions.Name.getValue(this.options);
    }

    public boolean isRelocatedPointer(Object originalObject) {
        return originalObject instanceof RelocatedPointer;
    }

    public boolean isCFunction(AnalysisMethod result) {
        return result.getAnnotation(CFunction.class) != null;
    }

    public void clearInThread() {
        Thread.currentThread().setContextClassLoader(SVMHost.class.getClassLoader());
        ImageSingletonsSupportImpl.HostedManagement.clearInThread();
    }

    public void installInThread(Object vmConfig) {
        Thread.currentThread().setContextClassLoader(this.classLoader);
        ImageSingletonsSupportImpl.HostedManagement.installInThread((ImageSingletonsSupportImpl.HostedManagement)vmConfig);
    }

    public Object getConfiguration() {
        return ImageSingletonsSupportImpl.HostedManagement.get();
    }

    public boolean platformSupported(ResolvedJavaField field) {
        return NativeImageGenerator.includedIn(this.platform, (Platforms)field.getAnnotation(Platforms.class));
    }

    public boolean platformSupported(ResolvedJavaMethod method) {
        return NativeImageGenerator.includedIn(this.platform, (Platforms)method.getAnnotation(Platforms.class));
    }

    public boolean platformSupported(ResolvedJavaType type) {
        return NativeImageGenerator.includedIn(this.platform, (Platforms)type.getAnnotation(Platforms.class));
    }

    public void registerType(AnalysisType analysisType) {
        this.classInitializationFeature.maybeInitializeHosted((ResolvedJavaType)analysisType);
        DynamicHub hub = this.createHub(analysisType);
        DynamicHub existing = this.typeToHub.put(analysisType, hub);
        assert (existing == null);
        existing = this.hubToType.put(hub, analysisType);
        assert (existing == null);
        UnsafeAutomaticSubstitutionProcessor automaticSubstitutions = (UnsafeAutomaticSubstitutionProcessor)((Object)ImageSingletons.lookup(UnsafeAutomaticSubstitutionProcessor.class));
        automaticSubstitutions.computeSubstitutions(GraalAccess.getOriginalProviders().getMetaAccess().lookupJavaType(analysisType.getJavaClass()), this.options);
    }

    public boolean isInitialized(AnalysisType type) {
        boolean shouldInitializeAtRuntime = this.classInitializationFeature.shouldInitializeAtRuntime((ResolvedJavaType)type);
        assert (shouldInitializeAtRuntime || type.getWrapped().isInitialized()) : "Types that are not marked for runtime initializations must have been initialized";
        return !shouldInitializeAtRuntime;
    }

    public Optional<AnalysisMethod> handleForeignCall(ForeignCallDescriptor foreignCallDescriptor, ForeignCallsProvider foreignCallsProvider) {
        SubstrateForeignCallsProvider foreignCalls = (SubstrateForeignCallsProvider)foreignCallsProvider;
        Optional<AnalysisMethod> targetMethod = Optional.empty();
        if (foreignCalls.getForeignCalls().size() > 0) {
            SubstrateForeignCallLinkage linkage = foreignCalls.lookupForeignCall(foreignCallDescriptor);
            targetMethod = Optional.of((AnalysisMethod)linkage.getMethod());
        }
        return targetMethod;
    }

    public DynamicHub dynamicHub(ResolvedJavaType type) {
        AnalysisType aType;
        if (type instanceof AnalysisType) {
            aType = (AnalysisType)type;
        } else if (type instanceof HostedType) {
            aType = ((HostedType)type).getWrapped();
        } else {
            throw VMError.shouldNotReachHere();
        }
        return this.typeToHub.get(aType);
    }

    public AnalysisType lookupType(DynamicHub hub) {
        return this.hubToType.get(hub);
    }

    private DynamicHub createHub(AnalysisType type) {
        DynamicHub superHub = null;
        if (type.isInstanceClass() && type.getSuperclass() != null || type.isArray()) {
            superHub = this.dynamicHub((ResolvedJavaType)type.getSuperclass());
        }
        DynamicHub componentHub = null;
        if (type.isArray()) {
            componentHub = this.dynamicHub((ResolvedJavaType)type.getComponentType());
        }
        Class javaClass = type.getJavaClass();
        boolean isStatic = Modifier.isStatic(javaClass.getModifiers());
        boolean isSynthetic = javaClass.isSynthetic();
        Target_java_lang_ClassLoader hubClassLoader = JavaLangSubstitutions.ClassLoaderSupport.getInstance().getOrCreate(javaClass.getClassLoader());
        String className = type.toClassName().intern();
        String sourceFileName = this.stringTable.deduplicate(type.getSourceFileName(), true);
        return new DynamicHub(className, type.isLocal(), superHub, componentHub, sourceFileName, isStatic, isSynthetic, hubClassLoader);
    }

    public static boolean isUnknownClass(ResolvedJavaType resolvedJavaType) {
        return resolvedJavaType.getAnnotation(UnknownClass.class) != null;
    }

    public static boolean isUnknownObjectField(ResolvedJavaField resolvedJavaField) {
        return resolvedJavaField.getAnnotation(UnknownObjectField.class) != null;
    }

    public static boolean isUnknownPrimitiveField(AnalysisField field) {
        return field.getAnnotation(UnknownPrimitiveField.class) != null;
    }
}

