/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal;

import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.code.amd64.SubstrateAMD64Backend;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SharedRuntimeMethod;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.graal.meta.SubstrateMethod;
import com.oracle.svm.hosted.FeatureImpl;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.CompilationWrapper;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.gen.NodeMatchRules;
import org.graalvm.compiler.core.match.MatchStatement;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.DiagnosticsOutputDirectory;
import org.graalvm.compiler.debug.GlobalMetrics;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.CompositeValueClass;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.alloc.trace.TraceAllocationPhase;
import org.graalvm.compiler.lir.phases.LIRPhase;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.GraphDecoder;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class GraalSupport {
    private RuntimeConfiguration runtimeConfig;
    private Suites suites;
    private LIRSuites lirSuites;
    private SubstrateMethod[] methodsToCompile;
    private byte[] graphEncoding;
    private Object[] graphObjects;
    private NodeClass<?>[] graphNodeTypes;
    public Map<Class<?>, NodeClass<?>> nodeClasses;
    public Map<Class<?>, LIRInstructionClass<?>> instructionClasses;
    public Map<Class<?>, CompositeValueClass<?>> compositeValueClasses;
    public HashMap<Class<? extends NodeMatchRules>, EconomicMap<Class<? extends Node>, List<MatchStatement>>> matchRuleRegistry;
    protected Map<Class<?>, BasePhase.BasePhaseStatistics> basePhaseStatistics;
    protected Map<Class<?>, LIRPhase.LIRPhaseStatistics> lirPhaseStatistics;
    protected Map<Class<?>, TraceAllocationPhase.AllocationStatistics> traceAllocationPhaseStatistics;
    protected Function<Providers, Backend> runtimeBackendProvider;
    protected final GlobalMetrics metricValues = new GlobalMetrics();
    protected final List<DebugHandlersFactory> debugHandlersFactories = new ArrayList<DebugHandlersFactory>();
    protected final DiagnosticsOutputDirectory outputDirectory = new DiagnosticsOutputDirectory((OptionValues)RuntimeOptionValues.singleton());
    protected final Map<CompilationWrapper.ExceptionAction, Integer> compilationProblemsPerAction = new EnumMap<CompilationWrapper.ExceptionAction, Integer>(CompilationWrapper.ExceptionAction.class);

    public DebugContext openDebugContext(OptionValues options, CompilationIdentifier compilationId, Object compilable) {
        DebugContext.Description description = new DebugContext.Description(compilable, compilationId.toString(CompilationIdentifier.Verbosity.ID));
        return DebugContext.create((OptionValues)options, (DebugContext.Description)description, (GlobalMetrics)this.metricValues, (PrintStream)DebugContext.DEFAULT_LOG_STREAM, this.runtimeConfig.getDebugHandlersFactories());
    }

    public DiagnosticsOutputDirectory getDebugOutputDirectory() {
        return this.outputDirectory;
    }

    public Map<CompilationWrapper.ExceptionAction, Integer> getCompilationProblemsPerAction() {
        return this.compilationProblemsPerAction;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public GraalSupport() {
        this.runtimeBackendProvider = providers -> new SubstrateAMD64Backend((Providers)providers);
        for (DebugHandlersFactory c : GraalServices.load(DebugHandlersFactory.class)) {
            this.debugHandlersFactories.add(c);
        }
    }

    public HashMap<Class<? extends NodeMatchRules>, EconomicMap<Class<? extends Node>, List<MatchStatement>>> getMatchRuleRegistry() {
        return this.matchRuleRegistry;
    }

    public void setMatchRuleRegistry(HashMap<Class<? extends NodeMatchRules>, EconomicMap<Class<? extends Node>, List<MatchStatement>>> matchRuleRegistry) {
        this.matchRuleRegistry = matchRuleRegistry;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void setRuntimeConfig(RuntimeConfiguration runtimeConfig, Suites suites, LIRSuites lirSuites) {
        GraalSupport.get().runtimeConfig = runtimeConfig;
        GraalSupport.get().suites = suites;
        GraalSupport.get().lirSuites = lirSuites;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static boolean setMethodsToCompile(SubstrateMethod[] methodsToCompile) {
        boolean result = false;
        if (!Arrays.equals(GraalSupport.get().methodsToCompile, methodsToCompile)) {
            GraalSupport.get().methodsToCompile = methodsToCompile;
            result = true;
        }
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static boolean setGraphEncoding(byte[] graphEncoding, Object[] graphObjects, NodeClass<?>[] graphNodeTypes) {
        boolean result = false;
        if (!Arrays.equals(GraalSupport.get().graphEncoding, graphEncoding)) {
            GraalSupport.get().graphEncoding = graphEncoding;
            result = true;
        }
        if (!Arrays.deepEquals(GraalSupport.get().graphObjects, graphObjects)) {
            GraalSupport.get().graphObjects = graphObjects;
            result = true;
        }
        if (!Arrays.equals(GraalSupport.get().graphNodeTypes, graphNodeTypes)) {
            GraalSupport.get().graphNodeTypes = graphNodeTypes;
            result = true;
        }
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerImmutableObjects(Feature.CompilationAccess access) {
        access.registerAsImmutable((Object)GraalSupport.get().graphEncoding);
        access.registerAsImmutable((Object)GraalSupport.get().graphObjects);
        access.registerAsImmutable(GraalSupport.get().graphNodeTypes);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void allocatePhaseStatisticsCache() {
        GraalSupport.get().basePhaseStatistics = new HashMap();
        GraalSupport.get().lirPhaseStatistics = new HashMap();
        GraalSupport.get().traceAllocationPhaseStatistics = new HashMap();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerPhaseStatistics(FeatureImpl.DuringAnalysisAccessImpl access) {
        GraalSupport.registerStatistics(GraalSupport.get().basePhaseStatistics, BasePhase.class, BasePhase.BasePhaseStatistics.class, clazz -> new BasePhase.BasePhaseStatistics(clazz), access);
        GraalSupport.registerStatistics(GraalSupport.get().lirPhaseStatistics, LIRPhase.class, LIRPhase.LIRPhaseStatistics.class, clazz -> new LIRPhase.LIRPhaseStatistics(clazz), access);
        GraalSupport.registerStatistics(GraalSupport.get().traceAllocationPhaseStatistics, TraceAllocationPhase.class, TraceAllocationPhase.AllocationStatistics.class, clazz -> new TraceAllocationPhase.AllocationStatistics(clazz), access);
    }

    private static <S> void registerStatistics(Map<Class<?>, S> cache, Class<?> phaseClass, Class<S> statisticsClass, Function<Class<?>, S> lookup, FeatureImpl.DuringAnalysisAccessImpl access) {
        AnalysisType statisticsType = access.getMetaAccess().lookupJavaType(statisticsClass);
        if (!statisticsType.isInstantiated()) {
            statisticsType.registerAsInHeap();
            access.requireAnalysisIteration();
        }
        for (Class<?> phaseSubClass : access.findSubclasses(phaseClass)) {
            AnalysisType phaseSubClassType;
            if (Modifier.isAbstract(phaseSubClass.getModifiers()) || phaseSubClass.getName().contains(".hosted.") || phaseSubClass.getName().contains(".hotspot.") || !(phaseSubClassType = access.getMetaAccess().lookupJavaType(phaseSubClass)).isInstantiated() || cache.containsKey(phaseSubClass)) continue;
            cache.put(phaseSubClass, lookup.apply(phaseSubClass));
            access.requireAnalysisIteration();
        }
    }

    public static GraalSupport get() {
        return (GraalSupport)ImageSingletons.lookup(GraalSupport.class);
    }

    public static RuntimeConfiguration getRuntimeConfig() {
        return GraalSupport.get().runtimeConfig;
    }

    public static Suites getSuites() {
        return GraalSupport.get().suites;
    }

    public static LIRSuites getLIRSuites() {
        return GraalSupport.get().lirSuites;
    }

    public static SubstrateMethod[] getMethodsToCompile() {
        return GraalSupport.get().methodsToCompile;
    }

    public static EncodedGraph encodedGraph(SharedRuntimeMethod method, boolean trackNodeSourcePosition) {
        int startOffset = method.getEncodedGraphStartOffset();
        if (startOffset == -1) {
            return null;
        }
        return new EncodedGraph(GraalSupport.get().graphEncoding, startOffset, GraalSupport.get().graphObjects, GraalSupport.get().graphNodeTypes, null, null, null, false, trackNodeSourcePosition);
    }

    public static StructuredGraph decodeGraph(DebugContext debug, String name, CompilationIdentifier compilationId, SharedRuntimeMethod method) {
        EncodedGraph encodedGraph = GraalSupport.encodedGraph(method, false);
        if (encodedGraph == null) {
            return null;
        }
        boolean isSubstitution = method.getAnnotation(Snippet.class) != null || method.getAnnotation(MethodSubstitution.class) != null;
        StructuredGraph graph = new StructuredGraph.Builder(debug.getOptions(), debug).name(name).method((ResolvedJavaMethod)method).compilationId(compilationId).setIsSubstitution(isSubstitution).build();
        GraphDecoder decoder = new GraphDecoder(ConfigurationValues.getTarget().arch, graph);
        decoder.decode(encodedGraph);
        return graph;
    }

    public static Function<Providers, Backend> getRuntimeBackendProvider() {
        return GraalSupport.get().runtimeBackendProvider;
    }

    public static void setRuntimeBackendProvider(Function<Providers, Backend> backendProvider) {
        GraalSupport.get().runtimeBackendProvider = backendProvider;
    }

    public static class GraalShutdownHook
    implements Runnable {
        @Override
        public void run() {
            GraalSupport graalSupport = GraalSupport.get();
            graalSupport.metricValues.print((OptionValues)RuntimeOptionValues.singleton());
            graalSupport.outputDirectory.close();
        }
    }
}

