/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.windows.WindowsVMLockSupport;
import com.oracle.svm.core.windows.headers.Process;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;

final class WindowsVMMutex
extends VMMutex {
    protected UnsignedWord structOffset;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected WindowsVMMutex() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    protected Process.PCRITICAL_SECTION getStructPointer() {
        return (Process.PCRITICAL_SECTION)Word.objectToUntrackedPointer((Object)((WindowsVMLockSupport)ImageSingletons.lookup(WindowsVMLockSupport.class)).syncStructs).add(this.structOffset);
    }

    @Override
    public VMMutex lock() {
        Process.EnterCriticalSection(this.getStructPointer());
        this.locked = true;
        return this;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.")
    public VMMutex lockNoTransition() {
        Process.EnterCriticalSectionNoTrans(this.getStructPointer());
        this.locked = true;
        return this;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.")
    public void unlock() {
        this.locked = false;
        Process.LeaveCriticalSection(this.getStructPointer());
    }

    @Override
    public void unlockWithoutChecks() {
        this.locked = false;
        Process.LeaveCriticalSectionNoTrans(this.getStructPointer());
    }
}

