/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.posix.headers.Unistd;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.LINUX.class})
class LinuxPhysicalMemory
extends PhysicalMemory {
    LinuxPhysicalMemory() {
    }

    @AutomaticFeature
    static class PhysicalMemoryFeature
    implements Feature {
        PhysicalMemoryFeature() {
        }

        public void afterRegistration(Feature.AfterRegistrationAccess access) {
            ImageSingletons.add(PhysicalMemory.PhysicalMemorySupport.class, (Object)new PhysicalMemorySupportImpl());
        }
    }

    static class PhysicalMemorySupportImpl
    implements PhysicalMemory.PhysicalMemorySupport {
        PhysicalMemorySupportImpl() {
        }

        @Override
        public UnsignedWord size() {
            UnsignedWord numberOfPhysicalMemoryPages = WordFactory.unsigned((long)Unistd.sysconf(Unistd._SC_PHYS_PAGES()));
            UnsignedWord sizeOfAPhysicalMemoryPage = WordFactory.unsigned((long)Unistd.sysconf(Unistd._SC_PAGESIZE()));
            return numberOfPhysicalMemoryPages.multiply(sizeOfAPhysicalMemoryPage);
        }
    }
}

