/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.jdk.SubstrateOperatingSystemMXBean;
import com.oracle.svm.core.jdk.SubstrateRuntimeMXBean;
import com.oracle.svm.core.jdk.SubstrateThreadMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;

@TargetClass(value=ManagementFactory.class)
final class Target_java_lang_management_ManagementFactory {
    Target_java_lang_management_ManagementFactory() {
    }

    @Substitute
    private static List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        return Heap.getHeap().getGC().getGarbageCollectorMXBeanList();
    }

    @Substitute
    private static MemoryMXBean getMemoryMXBean() {
        return Heap.getHeap().getMemoryMXBean();
    }

    @Substitute
    private static RuntimeMXBean getRuntimeMXBean() {
        return (RuntimeMXBean)ImageSingletons.lookup(SubstrateRuntimeMXBean.class);
    }

    @Substitute
    private static ThreadMXBean getThreadMXBean() {
        return (ThreadMXBean)ImageSingletons.lookup(SubstrateThreadMXBean.class);
    }

    @Substitute
    private static OperatingSystemMXBean getOperatingSystemMXBean() {
        return (OperatingSystemMXBean)ImageSingletons.lookup(SubstrateOperatingSystemMXBean.class);
    }
}

