/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.AutomaticFeature;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import org.graalvm.nativeimage.Feature;

@AutomaticFeature
class SystemFeature
implements Feature {
    private static final PrintStream newOut = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.out), 128), true);
    private static final PrintStream newErr = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.err), 128), true);
    private static final InputStream newIn = new BufferedInputStream(new FileInputStream(FileDescriptor.in));

    SystemFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        access.registerObjectReplacer(SystemFeature::replaceStreams);
    }

    private static Object replaceStreams(Object object) {
        if (object == System.out) {
            return newOut;
        }
        if (object == System.err) {
            return newErr;
        }
        if (object == System.in) {
            return newIn;
        }
        return object;
    }
}

