/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.UnsafeAccess;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import org.graalvm.nativeimage.Feature;

@AutomaticFeature
class AtomicFieldUpdaterFeature
implements Feature {
    private final ConcurrentMap<Object, Boolean> processedUpdaters = new ConcurrentHashMap<Object, Boolean>();
    private Consumer<Field> markAsUnsafeAccessed;

    AtomicFieldUpdaterFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        access.registerObjectReplacer(this::processObject);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.markAsUnsafeAccessed = field -> access.registerAsUnsafeAccessed(field);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        this.markAsUnsafeAccessed = null;
    }

    private Object processObject(Object obj) {
        if ((obj instanceof AtomicReferenceFieldUpdater || obj instanceof AtomicIntegerFieldUpdater || obj instanceof AtomicLongFieldUpdater) && this.processedUpdaters.putIfAbsent(obj, true) == null) {
            this.processFieldUpdater(obj);
        }
        return obj;
    }

    private void processFieldUpdater(Object updater) {
        VMError.guarantee(this.markAsUnsafeAccessed != null, "New atomic field updater found after static analysis");
        try {
            Class<?> updaterClass = updater.getClass();
            Field tclassField = updaterClass.getDeclaredField("tclass");
            Field offsetField = updaterClass.getDeclaredField("offset");
            tclassField.setAccessible(true);
            offsetField.setAccessible(true);
            Class tclass = (Class)tclassField.get(updater);
            long searchOffset = offsetField.getLong(updater);
            for (Field f : tclass.getDeclaredFields()) {
                long fieldOffset;
                if (Modifier.isStatic(f.getModifiers()) || (fieldOffset = UnsafeAccess.UNSAFE.objectFieldOffset(f)) != searchOffset) continue;
                this.markAsUnsafeAccessed.accept(f);
                return;
            }
            throw VMError.shouldNotReachHere("unknown field offset class: " + tclass + ", offset = " + searchOffset);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }
}

