/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.graal.code.SubstrateLIRGenerator;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
final class FarReturnLoweredNode
extends ControlSinkNode
implements LIRLowerable {
    public static final NodeClass<FarReturnLoweredNode> TYPE = NodeClass.create(FarReturnLoweredNode.class);
    @Node.Input
    protected ValueNode result;
    @Node.Input
    protected ValueNode sp;
    @Node.Input
    protected ValueNode ip;

    protected FarReturnLoweredNode(ValueNode result, ValueNode sp, ValueNode ip) {
        super(TYPE, StampFactory.forVoid());
        this.result = result;
        this.sp = sp;
        this.ip = ip;
    }

    public void generate(NodeLIRBuilderTool gen) {
        LIRGeneratorTool lirGenTool = gen.getLIRGeneratorTool();
        AllocatableValue resultOperand = lirGenTool.resultOperandFor(this.result.getStackKind(), (ValueKind)LIRKind.fromJavaKind((Architecture)lirGenTool.target().arch, (JavaKind)this.result.getStackKind()));
        lirGenTool.emitMove(resultOperand, gen.operand((Node)this.result));
        ((SubstrateLIRGenerator)lirGenTool).emitFarReturn(resultOperand, gen.operand((Node)this.sp), gen.operand((Node)this.ip));
    }
}

