/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.async;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;
import oracle.xml.async.XSLTransformerConstants;
import oracle.xml.async.XSLTransformerErrorEvent;
import oracle.xml.async.XSLTransformerErrorListener;
import oracle.xml.async.XSLTransformerEvent;
import oracle.xml.async.XSLTransformerListener;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;
import org.w3c.dom.DocumentFragment;

public class XSLTransformer
implements Serializable,
XSLTransformerConstants,
Runnable {
    protected int methodToCall = 0;
    protected DocumentFragment result;
    private int id;
    XMLDocument xmlDocument;
    XSLStylesheet xslStylesheet;
    Reader xmlReader;
    InputStream xmlInputStream;
    URL xmlURL;
    URL refURL;
    OutputStream xslOutputStream;
    XSLProcessor processor;
    private Vector XSLEventListenerVect = new Vector();
    private Vector ErrorEventListenerVect = new Vector();
    private boolean workingFlag;
    Thread thrd;

    public XSLTransformer() {
        this.id = 0;
        this.processor = new XSLProcessor();
        this.thrd = new Thread(this);
        this.workingFlag = false;
    }

    public XSLTransformer(int n) {
        this.id = n;
        this.processor = new XSLProcessor();
        this.thrd = new Thread(this);
        this.workingFlag = false;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public void run() {
        this.workingFlag = true;
        this.fireXSLTransformerEvent(0);
        try {
            switch (this.methodToCall) {
                case 1: {
                    this.result = this.processor.processXSL(this.xslStylesheet, this.xmlDocument);
                    break;
                }
                case 2: {
                    this.result = this.processor.processXSL(this.xslStylesheet, this.xmlInputStream, this.refURL);
                    break;
                }
                case 3: {
                    this.result = this.processor.processXSL(this.xslStylesheet, this.xmlReader, this.refURL);
                    break;
                }
                case 4: {
                    this.result = this.processor.processXSL(this.xslStylesheet, this.xmlURL, this.refURL);
                    break;
                }
                case 5: {
                    this.processor.processXSL(this.xslStylesheet, this.xmlDocument, this.xslOutputStream);
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.fireXSLTransformerErrorEvent(new XSLTransformerErrorEvent(this, exception));
            this.fireXSLTransformerEvent(2);
        }
        this.workingFlag = false;
        this.fireXSLTransformerEvent(1);
    }

    public void addXSLTransformerListener(XSLTransformerListener xSLTransformerListener) {
        this.XSLEventListenerVect.addElement(xSLTransformerListener);
    }

    public void addXSLTransformerErrorListener(XSLTransformerErrorListener xSLTransformerErrorListener) {
        this.ErrorEventListenerVect.addElement(xSLTransformerErrorListener);
    }

    public synchronized void removeXSLTransformerListener(XSLTransformerListener xSLTransformerListener) {
        this.XSLEventListenerVect.removeElement(xSLTransformerListener);
    }

    public synchronized void removeDOMTransformerErrorListener(XSLTransformerErrorListener xSLTransformerErrorListener) {
        this.ErrorEventListenerVect.removeElement(xSLTransformerErrorListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void fireXSLTransformerEvent(int n) {
        Vector vector;
        Serializable serializable = this;
        synchronized (serializable) {
            vector = (Vector)this.XSLEventListenerVect.clone();
        }
        serializable = new XSLTransformerEvent(this, this.id);
        for (int i = 0; i < vector.size(); ++i) {
            XSLTransformerListener xSLTransformerListener = (XSLTransformerListener)vector.elementAt(i);
            if (n == 0) {
                xSLTransformerListener.xslTransformerStarted((XSLTransformerEvent)serializable);
                continue;
            }
            if (n == 1) {
                xSLTransformerListener.xslTransformerOver((XSLTransformerEvent)serializable);
                continue;
            }
            if (n != 2) continue;
            xSLTransformerListener.xslTransformerError((XSLTransformerEvent)serializable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void fireXSLTransformerErrorEvent(XSLTransformerErrorEvent xSLTransformerErrorEvent) {
        Vector vector;
        XSLTransformer xSLTransformer = this;
        synchronized (xSLTransformer) {
            vector = (Vector)this.ErrorEventListenerVect.clone();
        }
        for (int i = 0; i < vector.size(); ++i) {
            XSLTransformerErrorListener xSLTransformerErrorListener = (XSLTransformerErrorListener)vector.elementAt(i);
            xSLTransformerErrorListener.xslTransformerErrorCalled(xSLTransformerErrorEvent);
        }
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLDocument xMLDocument) throws XSLException {
        while (this.workingFlag) {
        }
        this.xslStylesheet = xSLStylesheet;
        this.xmlDocument = xMLDocument;
        this.methodToCall = 1;
        this.thrd.start();
    }

    public void processXSL(XSLStylesheet xSLStylesheet, InputStream inputStream, URL uRL) throws XSLException {
        while (this.workingFlag) {
        }
        this.xslStylesheet = xSLStylesheet;
        this.xmlInputStream = inputStream;
        this.refURL = uRL;
        this.methodToCall = 2;
        this.thrd.start();
    }

    public void processXSL(XSLStylesheet xSLStylesheet, Reader reader, URL uRL) throws XSLException {
        while (this.workingFlag) {
        }
        this.xslStylesheet = xSLStylesheet;
        this.xmlReader = reader;
        this.refURL = uRL;
        this.methodToCall = 3;
        this.thrd.start();
    }

    public void processXSL(XSLStylesheet xSLStylesheet, URL uRL, URL uRL2) throws XSLException {
        while (this.workingFlag) {
        }
        this.xslStylesheet = xSLStylesheet;
        this.xmlURL = uRL;
        this.refURL = uRL2;
        this.methodToCall = 4;
        this.thrd.start();
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLDocument xMLDocument, OutputStream outputStream) throws XSLException {
        while (this.workingFlag) {
        }
        this.xslStylesheet = xSLStylesheet;
        this.xmlDocument = xMLDocument;
        this.xslOutputStream = outputStream;
        this.methodToCall = 5;
        this.thrd.start();
    }

    public final void setErrorStream(OutputStream outputStream) throws IOException {
        while (this.workingFlag) {
        }
        this.processor.setErrorStream(outputStream);
    }

    public final void showWarnings(boolean bl) {
        while (this.workingFlag) {
        }
        this.processor.showWarnings(bl);
    }

    public final void escapeNonASCIICharacters(boolean bl) {
        while (this.workingFlag) {
        }
        this.processor.setAttribute("EscapeNonASCIICharacters", bl);
    }

    public final void setXSLTVersion(XSLProcessor.XSLTVersion xSLTVersion) {
        while (this.workingFlag) {
        }
        this.processor.setXSLTVersion(xSLTVersion);
    }

    public synchronized DocumentFragment getResult() {
        while (this.workingFlag) {
        }
        return this.result;
    }
}

