/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.signing;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.signing.internal.Constants;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@InternalSdk
public enum SigningStrategy {
    STANDARD(Constants.REQUIRED_SIGNING_HEADERS_MAP, Constants.OPTIONAL_SIGNING_HEADERS_MAP, false),
    EXCLUDE_BODY(Constants.REQUIRED_EXCLUDE_BODY_SIGNING_HEADERS_MAP, Constants.OPTIONAL_SIGNING_HEADERS_MAP, true);

    private final Map<String, List<String>> headersToSign;
    private final Map<String, List<String>> optionalHeadersToSign;
    private final boolean skipContentHeadersForStreamingPutRequests;

    @ConstructorProperties(value={"headersToSign", "optionalHeadersToSign", "skipContentHeadersForStreamingPutRequests"})
    private SigningStrategy(Map<String, List<String>> headersToSign, Map<String, List<String>> optionalHeadersToSign, boolean skipContentHeadersForStreamingPutRequests) {
        this.headersToSign = headersToSign;
        this.optionalHeadersToSign = optionalHeadersToSign;
        this.skipContentHeadersForStreamingPutRequests = skipContentHeadersForStreamingPutRequests;
    }

    public Map<String, List<String>> getHeadersToSign() {
        return Collections.unmodifiableMap(this.headersToSign);
    }

    public Map<String, List<String>> getOptionalHeadersToSign() {
        return Collections.unmodifiableMap(this.optionalHeadersToSign);
    }

    public boolean isSkipContentHeadersForStreamingPutRequests() {
        return this.skipContentHeadersForStreamingPutRequests;
    }
}

