/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.StringTokenizer;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.util.FastVector;
import oracle.xml.util.NSNameImpl;
import oracle.xml.xpath.XPathConvertAsExpr;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathSeqType;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLDocumentBuilder;
import oracle.xml.xslt.XSLEventHandler;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLTContext;
import oracle.xml.xslt.XSLTDebuggerTraceEventVars;
import oracle.xml.xslt.XSLVariable;

class XSLTemplate
extends XSLNode
implements Comparable,
XSLConstants {
    private XPathConvertAsExpr asseq;
    private XSLExprBase pattern;
    private float priority;
    private ArrayList<NSName> modes = new ArrayList();
    private boolean allMode;
    int anchorNodeType = -1;
    String anchorNodeLocalName = null;
    private String[] anchorNodeName = new String[2];
    private String anchorNodeNamespace = null;
    String patternString;
    XSLNode xssRoot;
    int importPrecedence;
    int index;
    int importLevel;
    NSName templateNSName;
    boolean isBuiltInElementTemplate = false;

    XSLTemplate(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.localName = "template";
        this.elementType = 6;
    }

    XSLExprBase getPattern() {
        return this.pattern;
    }

    int setImportPrecedence() {
        if (this.xssRoot != null) {
            this.importPrecedence = this.xssRoot.xssImportPrecedence;
        }
        return this.importPrecedence;
    }

    public int compareTo(Object object) {
        XSLTemplate xSLTemplate = (XSLTemplate)object;
        if (this.importPrecedence == xSLTemplate.importPrecedence) {
            return 0;
        }
        if (this.importPrecedence < xSLTemplate.importPrecedence) {
            return -1;
        }
        return 1;
    }

    @Override
    XSLExprBase getContextExpr() {
        return this.pattern;
    }

    XSLExprBase matchTemplate(XMLNode xMLNode, NSName nSName, float f, XSLTContext xSLTContext) throws XSLException, XQException {
        if (this.priority < f) {
            return null;
        }
        if (this.matchMode(nSName) && this.pattern != null) {
            URL uRL = xSLTContext.getBaseURL();
            xSLTContext.setBaseURL(this.baseURL);
            xSLTContext.saveCapturedSubstring(false);
            XSLExprBase xSLExprBase = this.pattern.matchPattern(xMLNode, f, xSLTContext);
            xSLTContext.restoreCapturedSubstring();
            xSLTContext.setBaseURL(uRL);
            if (xSLExprBase != null) {
                return xSLExprBase;
            }
        }
        return null;
    }

    int matchTemplate(XSLExprBase xSLExprBase, NSName nSName, float f) throws XSLException, XQException {
        if (this.matchMode(nSName) && this.pattern != null) {
            return this.pattern.matchPattern(xSLExprBase, f);
        }
        return -1;
    }

    void fireOSBDebuggerTraceEventBefore(XSLTContext xSLTContext) throws XSLException {
        if (xSLTContext.getOSBDebugMode() && !this.isBuiltInElementTemplate) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
            xSLTContext.getOsbDebugAttrStk().push(hashMap);
            hashMap.put("match", this.patternString);
            hashMap.put("name", this.templateNSName);
            this.fireOSBDebuggerTraceEventBeforeExe(xSLTContext, this, "xsl:template");
        }
    }

    @Override
    public void processAction(XSLTContext xSLTContext) throws XSLException, XQException {
        XMLError xMLError = xSLTContext.getError();
        xMLError.setLocator(this);
        String string = xSLTContext.getDefaultCollation();
        URL uRL = xSLTContext.getBaseURL();
        xSLTContext.setBaseURL(this.baseURL);
        this.setDefaultCollation(xSLTContext);
        if (xSLTContext.isInDebugMode()) {
            if (this.patternString == null) {
                this.patternString = "";
            }
            this.addJDWPDataBefore(xSLTContext, this, "xsl:template", this.patternString, (byte)40);
        }
        XSLDocumentBuilder xSLDocumentBuilder = null;
        XSLEventHandler xSLEventHandler = null;
        XSLEventHandler xSLEventHandler2 = null;
        OXMLSequence oXMLSequence = null;
        if (this.asseq != null) {
            xSLDocumentBuilder = xSLTContext.allocXSLDocumentBuilder();
            xSLEventHandler = xSLTContext.allocXSLEventHandler();
            xSLDocumentBuilder.setSequenceConstructor(xSLTContext, this.asseq);
            xSLEventHandler.reset(xSLDocumentBuilder, xSLDocumentBuilder, xSLTContext);
            xSLEventHandler2 = xSLTContext.getEventHandler();
            xSLTContext.setEventHandler(xSLEventHandler);
        }
        this.processChildren(xSLTContext);
        if (this.asseq != null) {
            oXMLSequence = xSLDocumentBuilder.getResultSequence();
            xSLTContext.setEventHandler(xSLEventHandler2);
            xSLTContext.freeXSLDocumentBuilder(xSLDocumentBuilder);
            xSLTContext.freeXSLEventHandler(xSLEventHandler);
            xSLEventHandler2.sequence(oXMLSequence);
        }
        xSLTContext.setBaseURL(uRL);
        xSLTContext.setDefaultCollation(string);
        if (xSLTContext.getOSBDebugMode() && !this.isBuiltInElementTemplate) {
            this.fireOSBDebuggerTraceEventAfterExe(xSLTContext, this, "xsl:template");
            xSLTContext.getOsbDebugAttrStk().pop();
        }
        if (xSLTContext.isInDebugMode()) {
            this.addJDWPDataAfter(this, (byte)41, null);
        }
    }

    @Override
    public void appendChild(XSLNode xSLNode) throws XSLException {
        super.appendChild(xSLNode);
        if (xSLNode instanceof XSLVariable && xSLNode.namespace == "http://www.w3.org/1999/XSL/Transform" && xSLNode.localName == "param") {
            if (this.paramList == null) {
                this.paramList = new FastVector(4);
            }
            this.paramList.addElement(xSLNode);
            ++this.nParams;
            this.children.setSize(this.children.size() - 1);
        }
    }

    @Override
    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException, XQException {
        if (string == "") {
            if (string3 == "priority") {
                if (this.version == 10) {
                    this.priority = new Float(string4).floatValue();
                } else if (string4.matches("[+-]?[0-9]+(.[0-9]+)?")) {
                    this.priority = new Float(string4).floatValue();
                } else {
                    this.xss.err.error1(22245, 1, string4);
                }
            } else if (string3 == "name") {
                this.templateNSName = this.resolveQname(string4);
                if (this.templateNSName != null) {
                    this.xss.addNamedTemplate(this.templateNSName, this);
                } else {
                    this.xss.err.error1(22248, 1, string4);
                }
            } else if (string3 == "match") {
                try {
                    this.pattern = XSLExprBase.createPattern(string4, this, true, this.xss);
                }
                catch (XPathException xPathException) {
                    this.pattern = XSLExprBase.createPattern("/", this, true, this.xss);
                    if (xPathException.getMessage().contains("current-group()")) {
                        this.xss.err.error0(22277, 1);
                    }
                    if (xPathException.getMessage().contains("current-grouping-key()")) {
                        this.xss.err.error0(22278, 1);
                    }
                    String[] stringArray = new String[]{string4, string3, this.getQualifiedName(), xPathException.errId == 22026 || xPathException.errId == 1026 || xPathException.errId == 22013 || xPathException.errId == 1013 ? "" : this.xss.err.getMessage1(22242, xPathException.getMessage())};
                    this.xss.err.error(22241, 1, stringArray);
                }
                this.patternString = string4;
            } else if (string3 == "mode") {
                StringTokenizer stringTokenizer = new StringTokenizer(string4);
                while (stringTokenizer.hasMoreTokens()) {
                    NSName nSName;
                    String string5 = stringTokenizer.nextToken();
                    if (string5.equals("#all")) {
                        if (!this.modes.isEmpty()) {
                            this.xss.err.error0(22249, 1);
                        }
                        this.allMode = true;
                        continue;
                    }
                    if (this.allMode) {
                        this.xss.err.error0(22249, 1);
                    }
                    if ((nSName = string5.equals("#default") ? new NSNameImpl() : this.resolveQname(string5)) == null) {
                        this.xss.err.error1(22248, 1, string5);
                    }
                    if (this.modes.contains(nSName)) {
                        this.xss.err.error1(22247, 1, string5);
                    }
                    this.modes.add(nSName);
                }
                if (!this.allMode && this.modes.isEmpty()) {
                    this.xss.err.error1(22246, 1, string4);
                }
            } else if (string3 == "as") {
                OXMLSequenceType oXMLSequenceType = XPathSeqType.createSequenceType(string4, this, this.xss);
                this.asseq = new XPathConvertAsExpr(oXMLSequenceType);
            }
        }
        super.setAttribute(string, string2, string3, string4);
    }

    @Override
    public void startContent() throws XSLException {
        if (this.pattern == null && this.templateNSName == null) {
            this.xss.err.error2(22243, 1, "match", "template");
        }
        if (this.getAttribute("", "priority") != null) {
            if (this.pattern != null) {
                this.pattern.setPriority(this.priority);
            }
        } else if (this.pattern != null) {
            this.priority = this.pattern.getPriority();
        }
        if (this.pattern != null) {
            this.anchorNodeType = this.pattern.getAnchorType();
            this.pattern.getAnchorName(this.anchorNodeName);
            this.anchorNodeNamespace = this.anchorNodeName[0];
            this.anchorNodeLocalName = this.anchorNodeName[1];
        }
        if (this.modes.isEmpty()) {
            this.modes.add(new NSNameImpl());
        }
    }

    @Override
    void endContent() throws XSLException, XQException {
        super.endContent();
    }

    @Override
    public void finalizeXSLNode() throws XSLException, XQException {
        for (int i = 0; i < this.nParams; ++i) {
            ((XSLNode)this.paramList.elementAt(i)).finalizeXSLNode();
        }
        if (this.pattern == null) {
            if (this.getAttribute("", "priority") != null) {
                this.xss.err.error1(22244, 1, "priority");
            } else if (this.getAttribute("", "mode") != null) {
                this.xss.err.error1(22244, 1, "mode");
            }
        }
        super.finalizeXSLNode();
    }

    boolean matchMode(NSName nSName) {
        if (this.allMode) {
            return true;
        }
        return this.modes.contains(nSName);
    }

    NSName getMode() {
        return this.modes.get(0);
    }

    float getPriority() {
        return this.priority;
    }

    int getImportPrecedence() {
        return this.importPrecedence;
    }

    void setParams(Hashtable hashtable, XSLTContext xSLTContext) throws XSLException, XQException {
        Cloneable cloneable;
        this.fireOSBDebuggerTraceEventBefore(xSLTContext);
        XMLError xMLError = xSLTContext.getError();
        xMLError.setLocator(this);
        URL uRL = xSLTContext.getBaseURL();
        xSLTContext.setBaseURL(this.baseURL);
        XPathSequence xPathSequence = null;
        if (xSLTContext.isInDebugMode() && (((LinkedList)(cloneable = this.xss.getFrames())).size() == 0 || ((LinkedList)cloneable).size() > 0 && ((LinkedList)cloneable).getLast() != null)) {
            ((LinkedList)cloneable).add(null);
            this.xss.frameValues.add(new LinkedList());
            this.xss.frameParams.add(new Integer(1));
        }
        cloneable = xSLTContext.peekTunnelParams();
        XSLTDebuggerTraceEventVars xSLTDebuggerTraceEventVars = null;
        HashMap<String, Object> hashMap = null;
        if (hashtable != null) {
            for (int i = 0; i < this.nParams; ++i) {
                XSLVariable xSLVariable = (XSLVariable)this.paramList.elementAt(i);
                xPathSequence = null;
                if (xSLVariable.isTunnel()) {
                    if (cloneable != null) {
                        xPathSequence = (XPathSequence)((HashMap)cloneable).get(xSLVariable.getName());
                    }
                } else {
                    xPathSequence = (XPathSequence)hashtable.get(xSLVariable.getName());
                }
                if (xPathSequence != null) {
                    xPathSequence = (XPathSequence)xPathSequence.clone();
                    if (xSLVariable.asseq != null) {
                        xSLVariable.asseq.convert(xPathSequence);
                        if (xSLVariable.hasDefault()) {
                            xSLVariable.getValue(xSLTContext);
                        }
                    }
                } else {
                    xPathSequence = xSLVariable.getValue(xSLTContext);
                }
                xSLTContext.pushVariable(xPathSequence);
                if (xSLTContext.isInDebugMode()) {
                    this.addParamValuesNums(this.xss, this.xss.getFrames().size() - 1, xPathSequence);
                }
                if (!xSLTContext.getOSBDebugMode()) continue;
                hashMap = new HashMap(2);
                xSLTContext.getOsbDebugAttrStk().push(hashMap);
                hashMap.put("name", xSLVariable.getName());
                hashMap.put("value", xPathSequence);
                xSLTDebuggerTraceEventVars = new XSLTDebuggerTraceEventVars(xSLVariable, false);
                xSLTContext.pushOSBDebugVar(xSLTDebuggerTraceEventVars);
                xSLVariable.setParamPos(i + 1);
                xSLTDebuggerTraceEventVars.setParamPos(i + 1);
                this.fireOSBDebuggerTraceEventBeforeExe(xSLTContext, xSLVariable, "xsl:" + xSLVariable.localName);
                xSLTDebuggerTraceEventVars.setValue(xPathSequence);
                this.fireOSBDebuggerTraceEventAfterExe(xSLTContext, xSLVariable, "xsl:" + xSLVariable.localName);
                xSLTContext.getOsbDebugAttrStk().pop();
            }
        } else {
            for (int i = 0; i < this.nParams; ++i) {
                xPathSequence = null;
                XSLVariable xSLVariable = (XSLVariable)this.paramList.elementAt(i);
                if (xSLVariable.isTunnel() && cloneable != null) {
                    xPathSequence = (XPathSequence)((HashMap)cloneable).get(xSLVariable.getName());
                }
                if (xSLTContext.getOSBDebugMode()) {
                    hashMap = new HashMap<String, Object>(2);
                    xSLTContext.getOsbDebugAttrStk().push(hashMap);
                    hashMap.put("name", xSLVariable.getName());
                    xSLTDebuggerTraceEventVars = new XSLTDebuggerTraceEventVars(xSLVariable, false);
                    xSLTContext.pushOSBDebugVar(xSLTDebuggerTraceEventVars);
                    xSLVariable.setParamPos(i + 1);
                    xSLTDebuggerTraceEventVars.setParamPos(i + 1);
                    this.fireOSBDebuggerTraceEventBeforeExe(xSLTContext, xSLVariable, "xsl:" + xSLVariable.localName);
                }
                xPathSequence = xPathSequence != null ? (XPathSequence)xPathSequence.clone() : xSLVariable.getValue(xSLTContext);
                xSLTContext.pushVariable(xPathSequence);
                if (xSLTContext.isInDebugMode()) {
                    this.addParamValuesNums(this.xss, this.xss.getFrames().size() - 1, xPathSequence);
                }
                if (!xSLTContext.getOSBDebugMode()) continue;
                hashMap.put("value", xPathSequence);
                xSLTDebuggerTraceEventVars.setValue(xPathSequence);
                this.fireOSBDebuggerTraceEventAfterExe(xSLTContext, xSLVariable, "xsl:" + xSLVariable.localName);
                xSLTContext.getOsbDebugAttrStk().pop();
            }
        }
        xSLTContext.setBaseURL(uRL);
    }

    private void addParamValuesNums(XSLStylesheet xSLStylesheet, int n, XPathSequence xPathSequence) {
        LinkedList linkedList = (LinkedList)xSLStylesheet.frameValues.get(n);
        linkedList.add(xPathSequence);
        Integer n2 = (Integer)xSLStylesheet.frameParams.get(n);
        xSLStylesheet.frameParams.set(n, new Integer(n2 + 1));
    }

    @Override
    void printChildren(PrintWriter printWriter, int n) {
        for (int i = 0; i < this.nParams; ++i) {
            ((XSLNode)this.paramList.elementAt(i)).printXSLNode(printWriter, n);
        }
        super.printChildren(printWriter, n);
    }
}

