/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.xpath.CastableAsExpr;
import oracle.xml.xpath.ComparisonExpr;
import oracle.xml.xpath.XPathCompileEvents;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathSeqType;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExpr;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xslt.XSLException;

class TreatExpr
extends XSLExprBase {
    private OXMLSequenceType seqType;

    TreatExpr() {
    }

    static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException, XQException {
        XSLExprBase xSLExprBase = XSLExpr.isXPath20Compatible(xSLParseString) ? CastableAsExpr.parse(xSLParseString) : ComparisonExpr.parse(xSLParseString);
        if (xSLParseString.peekToken(23)) {
            XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
            if (xPathCompileEvents != null) {
                xPathCompileEvents.reportEventsNoParam(222, 0);
            }
            TreatExpr treatExpr = new TreatExpr();
            treatExpr.setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
            treatExpr.leftExpr = xSLExprBase;
            treatExpr.seqType = XPathSeqType.parse(xSLParseString);
            if (xPathCompileEvents != null) {
                xPathCompileEvents.reportEventsNoParam(222, 1);
            }
            return treatExpr;
        }
        return xSLExprBase;
    }

    @Override
    void cacheSubExpr() throws XQException {
        if (this.leftExpr.canCacheExpr()) {
            this.leftExpr = this.leftExpr.createCachedExpr();
        }
    }

    @Override
    boolean canCacheExpr() {
        return this.leftExpr.canCacheExpr();
    }

    @Override
    public String getNormalizedExpr() throws XQException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(23);
        stringBuffer.append(XPathSeqType.getNormalizedExpr(this.seqType));
        stringBuffer.append(this.leftExpr.getNormalizedExpr());
        return stringBuffer.toString();
    }

    @Override
    int checkPosLastFN() {
        if (this.flag < 0) {
            this.flag = this.leftExpr.checkPosLastFN();
        }
        return this.flag;
    }

    @Override
    public void evaluate(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        xPathRuntimeContext.setCompatibilityFlags(this.getXSLTVersion(), this.isBackwardCompatibilityMode(), this.isForwardCompatibilityMode());
        this.leftExpr.evaluate(xPathRuntimeContext);
        OXMLSequence oXMLSequence = xPathRuntimeContext.peekExprValue();
        if (!oXMLSequence.isOfType(this.seqType)) {
            throw new XPathException(1036, XPathSequence.getTypeString(oXMLSequence), this.seqType.getDataType().getName());
        }
    }
}

